/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.sysinfo.client.ContentEvent;
import com.sun.admin.sysinfo.client.ContentListener;
import com.sun.admin.sysinfo.client.VSysInfo;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import java.util.Vector;

public abstract class Content {
    private static Vector instances = new Vector();
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected boolean bRefreshInProgress = false;
    protected boolean bLocked = false;
    protected VScopeNode rootNode = null;
    protected VConsoleProperties properties = null;
    protected VDisplayModel displayModel = null;
    protected VSysInfo theApp;

    public Content(VSysInfo vSysInfo) {
        this.theApp = vSysInfo;
        instances.addElement(this);
    }

    protected void setDisplayModel() {
        this.properties = this.theApp.getProperties();
        this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
    }

    public Vector getSelected() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        return this.displayModel.getSelectedNodes();
    }

    public VScopeNode getSelectedNode() {
        Vector vector = this.getSelected();
        if (vector.size() > 0) {
            return (VScopeNode)vector.firstElement();
        }
        return null;
    }

    public void setSelected(Vector vector) {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        this.displayModel.setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
    }

    public int getNumSelections() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        return this.displayModel.getSelectedNodes().size();
    }

    public void clearSelection() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        this.displayModel.clearSelection();
        this.fireItemPressed(0);
    }

    public abstract void dateTime();

    public abstract void refresh();

    public void onDoubleClick() {
    }

    public abstract String whatAmI();

    protected abstract void updateStatusBar(int var1);

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    public void die() {
        instances.removeElement(this);
    }

    public static void broadcastUpdate(Object object, Object object2, boolean bl) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object2 == null && !bl) {
            return;
        }
        int n = 0;
        while (n < instances.size()) {
            Content content = (Content)instances.elementAt(n);
            if (!content.isRefreshed()) {
                // empty if block
            }
            ++n;
        }
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public abstract void clear();

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public synchronized boolean isLocked() {
        return this.bLocked;
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        this.listeners.addElement(contentListener);
    }

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ContentListener contentListener = (ContentListener)this.listeners.elementAt(n2);
            contentListener.itemPressed(contentEvent);
            ++n2;
        }
    }
}

