/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Hashtable;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.Debug;
import javax.wbem.client.LocalUserPrincipal;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.ClientSecurityFactory;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;
import javax.wbem.security.UserPasswordEncryptionProvider;

public class SunDigestClientSecurity
implements ClientSecurityContext {
    private static boolean ssl_enabled = true;
    private static final String mechanism = "sundigest";
    private static final String WBEM_LOCAL_TYPE = "__LOCAL";
    private static final String WBEM_LOCAL_DIR = "/var/sadm/wbem/security";
    private static final int WBEM_LOCAL_NONCE_SIZE = 16;
    private static final String BAD_HASH = ".B.A.D.H.A.S.H.";
    private static final String FAKE_HASH = ".F.A.K.E.H.A.S.H.";
    private static boolean initialized = false;
    private static MessageDigest md = null;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey cprivkey;
    private static PublicKey cpubkey;
    private static UserPasswordEncryptionProvider pep;
    private CIMNameSpace nameSpace;
    private Principal principal;
    private String userName;
    private byte[] userPswd;
    private byte[] secret;
    private String nsHost;
    private String nsPath;
    private boolean bEstablished = false;
    private boolean bLocalMode = false;
    private PublicKey spubkey;
    private String initialKey = "InitialKey";
    private byte[] cchallenge1;
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] encryptKey = null;
    protected static Hashtable insecureHosts;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    private static synchronized void initialize() throws NoSuchAlgorithmException {
        if (!initialized) {
            String string;
            md = MessageDigest.getInstance("MD5");
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            cprivkey = keypair.getPrivate();
            cpubkey = keypair.getPublic();
            try {
                string = ClientSecurityFactory.getProperty("security.password.provider.class");
                Class<?> clazz = Class.forName(string);
                pep = (UserPasswordEncryptionProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.trace1("Error getting password encryption provider: " + exception.getMessage());
                throw new NoSuchAlgorithmException("NO_PASSWORD_PROVIDER");
            }
            string = System.getProperty("sun.smc.internal.ssl.enable", "yes");
            if (!string.equals("yes")) {
                ssl_enabled = false;
            }
            initialized = true;
        }
    }

    public SunDigestClientSecurity() throws NoSuchAlgorithmException {
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
        SunDigestClientSecurity.initialize();
    }

    public SunDigestClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(cIMNameSpace);
        this.setPrincipal(principal);
        this.setCredential(object);
        SunDigestClientSecurity.initialize();
    }

    public String getMechanism() {
        return mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        if (cIMNameSpace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = cIMNameSpace;
        this.nsHost = cIMNameSpace.getHost();
        this.nsPath = cIMNameSpace.getNameSpace();
    }

    public void setPrincipal(Principal principal) throws CIMException {
        if (principal == null || !(principal instanceof UserPrincipal)) {
            Debug.trace1("Invalid client user principal");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = principal;
        this.userName = principal.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            Debug.trace1("Invalid client user principal");
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (principal instanceof LocalUserPrincipal) {
            this.bLocalMode = true;
        }
    }

    public void setCredential(Object object) throws CIMException {
        String string = null;
        if (object != null) {
            if (object instanceof PasswordCredential) {
                string = new String(((PasswordCredential)object).getUserPassword());
            } else if (object instanceof String) {
                string = new String((String)object);
            }
        }
        if (string == null) {
            Debug.trace1("Invalid credential for user " + this.userName);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int n = string.length();
        this.userPswd = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.userPswd[n2] = (byte)c;
            ++n2;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getRoleName() {
        return null;
    }

    public String getRolePassword() {
        return null;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        String string = "";
        if (this.userPswd.length > 0) {
            char[] cArray = new char[this.userPswd.length];
            int n = 0;
            while (n < this.userPswd.length) {
                cArray[n] = (char)(0 | this.userPswd[n] & 0xFF);
                ++n;
            }
            string = new String(cArray);
        }
        return string;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return cpubkey;
    }

    public PublicKey getServerPublicKey() {
        return this.spubkey;
    }

    public PrivateKey getPrivateKey() {
        return cprivkey;
    }

    public MessageDigest getMD() {
        return md;
    }

    public Signature getSigner() {
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateHello() {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            this.cchallenge1 = new byte[16];
            SecurityUtil.secrand.nextBytes(this.cchallenge1);
            md.reset();
            md.update(this.cchallenge1);
            md.update(this.initialKey.getBytes());
            byte[] byArray = md.digest();
            String string = this.userName;
            if (this.bLocalMode) {
                string = string + ":" + WBEM_LOCAL_TYPE;
            }
            byte[] byArray2 = string.getBytes();
            byte[] byArray3 = this.nsPath.getBytes();
            byte[] byArray4 = SecurityUtil.hashData(byArray2, byArray);
            byte[] byArray5 = SecurityUtil.hashData(byArray3, byArray);
            md.reset();
            md.update(this.cchallenge1);
            md.update(this.initialKey.getBytes());
            md.update(byArray4);
            SecurityMessage securityMessage = SecurityMessage.hello(this.cchallenge1, byArray4, byArray5, md.digest(byArray5));
            return securityMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateResponse(SecurityMessage securityMessage) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            Object object;
            Object object2;
            if (!securityMessage.isChallenge()) {
                throw new IllegalArgumentException("not a challenge message");
            }
            this.schallenge1 = securityMessage.getChallenge();
            md.reset();
            md.update(securityMessage.getChallenge());
            byte[] byArray = md.digest(this.initialKey.getBytes());
            md.reset();
            md.update(securityMessage.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(securityMessage.getSalt());
            if (!MessageDigest.isEqual(md.digest(securityMessage.getSessionId()), securityMessage.getChecksum())) {
                throw new IllegalArgumentException("Checksum error");
            }
            byte[] byArray2 = SecurityUtil.extractHashedData(securityMessage.getSalt(), byArray);
            this.sessionId = securityMessage.getSessionId();
            if (byArray2 == null || this.sessionId == null) {
                throw new IllegalArgumentException("Null salt/session");
            }
            String string = new String(byArray2);
            this.secret = null;
            if (string.startsWith("$__LOCAL$")) {
                Debug.trace2("Local authentication for " + this.userName);
                this.bLocalMode = true;
                object2 = null;
                object = null;
                int n = WBEM_LOCAL_TYPE.length() + 2;
                try {
                    object2 = "/var/sadm/wbem/security/" + string.substring(n);
                    Debug.trace3("Authentication file name: " + (String)object2);
                    object = new FileInputStream((String)object2);
                    byte[] byArray3 = new byte[96];
                    int n2 = ((FileInputStream)object).read(byArray3);
                    if (n2 > 0) {
                        byte[] byArray4 = new byte[n2];
                        System.arraycopy(byArray3, 0, byArray4, 0, n2);
                        String string2 = new String(byArray4, "UTF-8");
                        byte[] byArray5 = this.fromHex(string2);
                        this.secret = SecurityUtil.extractHashedData(byArray5, this.cchallenge1);
                        Debug.trace3("Authentication shared secret: " + this.toHex(this.secret));
                    }
                }
                catch (Exception exception) {
                    Debug.trace1("Error reading local auth file: " + exception.getMessage());
                }
                try {
                    if (object != null) {
                        ((FileInputStream)object).close();
                    }
                }
                catch (Exception exception) {}
            } else if (!SunDigestClientSecurity.isServerSecure(this.nsHost)) {
                Debug.trace2("Password based authentication for " + this.userName);
                this.bLocalMode = false;
                object2 = null;
                object = null;
                try {
                    object = pep.encryptPassword(this.userName, string, new String(this.userPswd));
                }
                catch (Exception exception) {
                    object = BAD_HASH;
                }
                if (object != null && ((String)object).length() > 0) {
                    if (((String)object).charAt(0) == '$') {
                        try {
                            int n = ((String)object).lastIndexOf(36);
                            object2 = ((String)object).substring(n + 1);
                        }
                        catch (Exception exception) {}
                    } else {
                        object2 = object;
                    }
                }
                if (object2 != null) {
                    try {
                        this.secret = ((String)object2).getBytes("UTF-8");
                        Debug.trace3("Authentication shared secret: " + new String(this.secret));
                    }
                    catch (Exception exception) {}
                }
            } else {
                try {
                    this.secret = ssl_enabled ? FAKE_HASH.getBytes("UTF-8") : BAD_HASH.getBytes("UTF-8");
                }
                catch (Exception exception) {
                    Debug.trace1("SunDigestClient: Error using UTF-8 converter " + exception.getMessage());
                }
            }
            if (this.secret == null) {
                try {
                    this.secret = BAD_HASH.getBytes("UTF-8");
                    Debug.trace3("Authentication shared secret is bad ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            md.reset();
            md.update(securityMessage.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(this.secret);
            byArray = md.digest();
            object2 = null;
            object2 = this.bLocalMode ? (Object)SecurityUtil.hashData(this.secret, byArray) : (Object)SecurityUtil.hashData(this.userPswd, byArray);
            md.reset();
            md.update(securityMessage.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(this.secret);
            md.update((byte[])object2);
            md.update(cpubkey.getEncoded());
            object = SecurityMessage.response((byte[])object2, cpubkey, this.sessionId, md.digest(this.sessionId));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checkResult(SecurityMessage securityMessage) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!securityMessage.isResult()) {
                throw new IllegalArgumentException("not a result message");
            }
            byte[] byArray = this.bLocalMode ? this.secret : this.userPswd;
            md.reset();
            md.update(this.getChallenge());
            md.update(byArray);
            byte[] byArray2 = md.digest();
            md.reset();
            md.update(this.getChallenge());
            md.update(byArray);
            md.update(securityMessage.getSessionId());
            this.spubkey = securityMessage.getPublicKey();
            md.update(this.spubkey.getEncoded());
            md.update(securityMessage.getResponse());
            if (!MessageDigest.isEqual(md.digest(), securityMessage.getChecksum())) {
                Debug.trace1("Authentication checksum failure for " + this.userName);
                throw new IllegalArgumentException("mutual authentication failed");
            }
            this.sessionKey = SecurityUtil.extractHashedData(securityMessage.getResponse(), byArray2);
            if (this.sessionKey == null) {
                throw new IllegalArgumentException("Null response");
            }
            this.encryptKey = new byte[this.sessionKey.length];
            System.arraycopy(this.sessionKey, 0, this.encryptKey, 0, this.sessionKey.length);
            byte[] byArray3 = this.sessionKey;
            return byArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityToken getSecurityToken(String[] stringArray) throws CIMException {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            SecurityToken securityToken = new SecurityToken();
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = string + stringArray[n];
                ++n;
            }
            byte[] byArray = string.getBytes();
            MessageDigest messageDigest2 = this.getMD();
            messageDigest2.reset();
            messageDigest2.update(this.getSessionKey());
            messageDigest2.update(byArray);
            byte[] byArray2 = messageDigest2.digest();
            securityToken.setChecksum(byArray2);
            securityToken.setSessionId(this.getSessionId());
            SecurityToken securityToken2 = securityToken;
            return securityToken2;
        }
    }

    public synchronized void incSessionKey() {
        SecurityUtil.incByteArray(this.sessionKey);
    }

    public String trans51Format(String string) throws CIMException {
        if (string.length() > 15 || this.encryptKey == null) {
            Debug.trace1("Cannot encrypt data; invalid data or session key");
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] byArray = string.getBytes();
        int n = this.encryptKey.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.encryptKey, 0, byArray2, 0, n);
        byte[] byArray3 = new byte[n];
        SecurityUtil.secrand.nextBytes(byArray3);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray[n2]);
            ++n2;
        }
        int n4 = n2++;
        byArray2[n4] = (byte)(byArray2[n4] ^ 0);
        while (n2 < byArray2.length) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[n2]);
            ++n2;
        }
        String string2 = this.toHex(byArray2);
        return string2;
    }

    private String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = 0;
            boolean bl = false;
            char c = string.charAt(n2);
            int n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(n4 << 4 & 0xF0);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            bl = false;
            c = string.charAt(++n2);
            n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(byArray[n3] | (byte)(n4 & 0xF));
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            ++n3;
            ++n2;
        }
        return byArray;
    }

    public static void setInsecureHost(String string) {
        String string2 = "unknown";
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            string2 = inetAddressArray[0].getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!insecureHosts.containsKey(string2)) {
            insecureHosts.put(string2, string);
        }
    }

    public static boolean isServerSecure(String string) {
        return !insecureHosts.containsKey(string) && !insecureHosts.containsValue(string);
    }

    static {
        pep = null;
        insecureHosts = new Hashtable();
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

