/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import com.sun.xml.tree.XmlDocument;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.adapter.http.transport.HttpServerRequestHandler;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class HttpEventRequestHandler
extends HttpServerRequestHandler {
    CIMListener clientListener;
    private CIMXml xmlInst;
    private List events = new ArrayList();

    public HttpEventRequestHandler(CIMListener cIMListener) {
        this.clientListener = cIMListener;
        this.xmlInst = CIMXmlFactory.getCIMXmlImpl();
        EventProcessor eventProcessor = new EventProcessor();
        eventProcessor.setDaemon(true);
        eventProcessor.start();
    }

    public boolean checkAuthentication(InboundRequest inboundRequest) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(InboundRequest inboundRequest) {
        try {
            XmlDocument xmlDocument = this.getXmlDocument(inboundRequest);
            DataOutputStream dataOutputStream = new DataOutputStream(inboundRequest.getResponseOutputStream());
            String string = inboundRequest.getHeaderField("CIMExportMethod");
            if (string == null || !string.equals("ExportIndication")) {
                this.do501Error(dataOutputStream);
                return;
            }
            List list = this.events;
            synchronized (list) {
                this.events.add(new CIMEvent(this.xmlInst.getCIMInstance((Node)xmlDocument)));
                this.events.notify();
            }
            xmlDocument = this.xmlInst.getXMLResponse(null, xmlDocument, null);
            xmlDocument.write((OutputStream)dataOutputStream);
        }
        catch (SAXException sAXException) {
            DataOutputStream dataOutputStream = new DataOutputStream(inboundRequest.getResponseOutputStream());
            sAXException.printStackTrace();
            Exception exception = sAXException.getException();
            String string = "Parse Error with Request:\n";
            if (exception == null) {
                exception = sAXException;
            }
            if (sAXException instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)sAXException;
                string = string + "** URI: " + sAXParseException.getSystemId() + "\n";
                string = string + "** Line: " + sAXParseException.getLineNumber() + "\n";
            }
            this.do500Error(dataOutputStream, "XML Parsing error: <b>" + string + "</b>");
            System.out.println(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addResponseHeaderFields(InboundRequest inboundRequest) {
        inboundRequest.setRespondHeaderField("CIMOperation", "ExportMethodResponse");
    }

    private class EventProcessor
    extends Thread {
        private EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                List list = HttpEventRequestHandler.this.events;
                synchronized (list) {
                    while (HttpEventRequestHandler.this.events.isEmpty()) {
                        try {
                            HttpEventRequestHandler.this.events.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    HttpEventRequestHandler.this.clientListener.indicationOccured((CIMEvent)HttpEventRequestHandler.this.events.remove(0));
                }
            }
        }
    }
}

