/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.security.SMCSSLConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;
import java.security.KeyStore;
import java.util.Hashtable;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SMCRMISocketFactory
extends RMISocketFactory
implements Serializable {
    protected static SSLServerSocketFactory ssf = null;
    protected static SSLSocketFactory csf = null;
    protected static ServerSocketFactory sf = null;
    protected static SocketFactory cf = null;
    protected static Hashtable insecureHosts = new Hashtable();

    public ServerSocket createServerSocket(int n) throws IOException {
        String string = System.getProperty("sun.smc.internal.ssl.enable", "yes");
        if (string.equals("no")) {
            if (sf == null) {
                sf = ServerSocketFactory.getDefault();
            }
            return sf.createServerSocket(n);
        }
        if (ssf == null) {
            try {
                char[] cArray = SMCSSLConfig.getKeyStorePasswd();
                System.setProperty("javax.net.ssl.keyStorePassword", new String(cArray));
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(SMCSSLConfig.getSMCServerKeyStore()), cArray);
                keyManagerFactory.init(keyStore, cArray);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SMCX509");
                trustManagerFactory.init((KeyStore)null);
                sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                ssf = sSLContext.getServerSocketFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ssf = null;
                throw new IOException("RMISSLSocketFactory: Failed to initialize Server SSL Context " + exception);
            }
        }
        return ssf.createServerSocket(n);
    }

    public Socket createSocket(String string, int n) throws IOException {
        boolean bl = true;
        String string2 = System.getProperty("sun.smc.internal.ssl.enable", "yes");
        if (string2.equals("no")) {
            bl = false;
        } else if (!SMCRMISocketFactory.isServerSecure(string)) {
            bl = false;
        }
        if (!bl) {
            if (cf == null) {
                cf = SocketFactory.getDefault();
            }
            return cf.createSocket(string, n);
        }
        if (csf == null) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SMCX509");
                trustManagerFactory.init((KeyStore)null);
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                csf = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                csf = null;
                throw new IOException("RMISSLSocketFactory: Failed to initialize Client SSL Context " + exception);
            }
        }
        return csf.createSocket(string, n);
    }

    public static void setInsecureHost(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        String string2 = inetAddressArray[0].getHostAddress();
        if (!insecureHosts.containsKey(string2)) {
            insecureHosts.put(string2, string);
        }
    }

    public static boolean isServerSecure(String string) {
        return !insecureHosts.containsKey(string) && !insecureHosts.containsValue(string);
    }
}

