/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11PubKey;

class JSSSignatureSpi
extends SignatureSpi {
    Signature sig;
    SignatureAlgorithm alg;

    private JSSSignatureSpi() {
    }

    protected JSSSignatureSpi(SignatureAlgorithm signatureAlgorithm) {
        this.alg = signatureAlgorithm;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.sig = this.getSigContext(privateKey);
            this.sig.initSign((org.mozilla.jss.crypto.PrivateKey)privateKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Algorithm not supported");
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Token exception occurred");
        }
    }

    private Signature getSigContext(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, TokenException {
        if (!(privateKey instanceof org.mozilla.jss.crypto.PrivateKey)) {
            throw new InvalidKeyException();
        }
        org.mozilla.jss.crypto.PrivateKey privateKey2 = (org.mozilla.jss.crypto.PrivateKey)privateKey;
        CryptoToken cryptoToken = privateKey2.getOwningToken();
        return cryptoToken.getSignatureContext(this.alg);
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getThreadToken();
            this.sig = cryptoToken.getSignatureContext(this.alg);
            if (!(publicKey instanceof PK11PubKey)) {
                if (!publicKey.getFormat().equalsIgnoreCase("X.509")) {
                    throw new InvalidKeyException("Unsupported public key format: " + publicKey.getFormat());
                }
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
                KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), "Mozilla-JSS");
                publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            }
            this.sig.initVerify(publicKey);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidKeyException("Unable to convert non-JSS key to JSS key");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Unable to convert non-JSS key to JSS key");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Algorithm not supported");
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Token exception occurred");
        }
    }

    public void engineUpdate(byte by) throws SignatureException {
        try {
            this.sig.update(by);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.sig.update(byArray, n, n2);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public byte[] engineSign() throws SignatureException {
        try {
            return this.sig.sign();
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            return this.sig.sign(byArray, n, n2);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        try {
            return this.sig.verify(byArray);
        }
        catch (TokenException tokenException) {
            throw new SignatureException("TokenException: " + tokenException.toString());
        }
    }

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        try {
            this.sig.setParameter(algorithmParameterSpec);
        }
        catch (TokenException tokenException) {
            throw new InvalidAlgorithmParameterException("TokenException: " + tokenException.toString());
        }
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("name/value parameters not supported");
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("name/value parameters not supported");
    }

    public static class SHA512RSA
    extends JSSSignatureSpi {
        public SHA512RSA() {
            super(SignatureAlgorithm.RSASignatureWithSHA512Digest);
        }
    }

    public static class SHA384RSA
    extends JSSSignatureSpi {
        public SHA384RSA() {
            super(SignatureAlgorithm.RSASignatureWithSHA384Digest);
        }
    }

    public static class SHA256RSA
    extends JSSSignatureSpi {
        public SHA256RSA() {
            super(SignatureAlgorithm.RSASignatureWithSHA256Digest);
        }
    }

    public static class SHA1RSA
    extends JSSSignatureSpi {
        public SHA1RSA() {
            super(SignatureAlgorithm.RSASignatureWithSHA1Digest);
        }
    }

    public static class MD5RSA
    extends JSSSignatureSpi {
        public MD5RSA() {
            super(SignatureAlgorithm.RSASignatureWithMD5Digest);
        }
    }

    public static class MD2RSA
    extends JSSSignatureSpi {
        public MD2RSA() {
            super(SignatureAlgorithm.RSASignatureWithMD2Digest);
        }
    }

    public static class SHA512EC
    extends JSSSignatureSpi {
        public SHA512EC() {
            super(SignatureAlgorithm.ECSignatureWithSHA512Digest);
        }
    }

    public static class SHA384EC
    extends JSSSignatureSpi {
        public SHA384EC() {
            super(SignatureAlgorithm.ECSignatureWithSHA384Digest);
        }
    }

    public static class SHA256EC
    extends JSSSignatureSpi {
        public SHA256EC() {
            super(SignatureAlgorithm.ECSignatureWithSHA256Digest);
        }
    }

    public static class SHA1EC
    extends JSSSignatureSpi {
        public SHA1EC() {
            super(SignatureAlgorithm.ECSignatureWithSHA1Digest);
        }
    }

    public static class DSA
    extends JSSSignatureSpi {
        public DSA() {
            super(SignatureAlgorithm.DSASignatureWithSHA1Digest);
        }
    }
}

