/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmmf.CertOrEncCert;
import org.mozilla.jss.pkix.cmmf.CertResponse;
import org.mozilla.jss.pkix.cmmf.CertifiedKeyPair;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;

public class CertRepContent
implements ASN1Value {
    private byte[][] caPubs;
    private SEQUENCE response;
    public static final Tag TAG = SEQUENCE.TAG;

    private CertRepContent() {
    }

    public CertRepContent(byte[][] byArray, SEQUENCE sEQUENCE) {
        this.caPubs = byArray;
        this.response = sEQUENCE;
    }

    public CertRepContent(byte[][] byArray) {
        this.caPubs = byArray;
        this.response = new SEQUENCE();
    }

    public CertRepContent(SEQUENCE sEQUENCE) {
        this.caPubs = null;
        this.response = sEQUENCE;
    }

    public void addCertResponse(CertResponse certResponse) {
        this.response.addElement(certResponse);
    }

    public byte[][] getCaPubs() {
        return this.caPubs;
    }

    public SEQUENCE getResponse() {
        return this.response;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.caPubs != null) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            for (int i = 0; i < this.caPubs.length; ++i) {
                sEQUENCE2.addElement(new ANY(SEQUENCE.TAG, this.caPubs[i]));
            }
            sEQUENCE.addElement(new Tag(1L), sEQUENCE2);
        }
        sEQUENCE.addElement(this.response);
        sEQUENCE.encode(tag, outputStream);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: CertRepContent <certfile> <outputfile>");
                System.out.println("certfile should contain a DER-encoded X.509 certificate");
                System.exit(-1);
            }
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            byte[][] byArrayArray = new byte[2][];
            byArrayArray[0] = new byte[fileInputStream.available()];
            fileInputStream.read(byArrayArray[0]);
            byArrayArray[1] = byArrayArray[0];
            PKIStatusInfo pKIStatusInfo = new PKIStatusInfo(2, 0x30000000);
            pKIStatusInfo.addFreeText("And your mother dresses you funny");
            pKIStatusInfo.addFreeText("so there");
            CertifiedKeyPair certifiedKeyPair = new CertifiedKeyPair(new CertOrEncCert(byArrayArray[0]));
            CertResponse certResponse = new CertResponse(new INTEGER(54L), pKIStatusInfo, certifiedKeyPair);
            CertRepContent certRepContent = new CertRepContent(byArrayArray);
            certRepContent.addCertResponse(certResponse);
            certRepContent.encode(fileOutputStream);
            System.out.println("Success!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

