/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class CMCCertId
implements ASN1Value {
    private SEQUENCE issuer;
    private INTEGER serial;
    private BIT_STRING issuerUID;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public SEQUENCE getIssuer() {
        return this.issuer;
    }

    public INTEGER getSerial() {
        return this.serial;
    }

    public BIT_STRING getIssuerUID() {
        return this.issuerUID;
    }

    private CMCCertId() {
    }

    public CMCCertId(SEQUENCE sEQUENCE, INTEGER iNTEGER, BIT_STRING bIT_STRING) {
        if (sEQUENCE == null || iNTEGER == null) {
            throw new IllegalArgumentException("parameter to CMCCertId constructor is null");
        }
        if (sEQUENCE.size() == 0) {
            throw new IllegalArgumentException("issuer parameter to CMCCertId constructor is empty");
        }
        this.sequence = new SEQUENCE();
        this.issuer = sEQUENCE;
        this.sequence.addElement(sEQUENCE);
        this.serial = iNTEGER;
        this.sequence.addElement(iNTEGER);
        if (bIT_STRING != null) {
            this.sequence.addElement(bIT_STRING);
        }
    }

    public CMCCertId(ANY aNY, INTEGER iNTEGER, BIT_STRING bIT_STRING) {
        if (aNY == null || iNTEGER == null) {
            throw new IllegalArgumentException("parameter to CMCCertId constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuer = new SEQUENCE();
        this.issuer.addElement(aNY);
        this.sequence.addElement(this.issuer);
        this.serial = iNTEGER;
        this.sequence.addElement(iNTEGER);
        if (bIT_STRING != null) {
            this.sequence.addElement(bIT_STRING);
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new CMCCertId((SEQUENCE)sEQUENCE.elementAt(0), (INTEGER)sEQUENCE.elementAt(1), (BIT_STRING)sEQUENCE.elementAt(2));
        }
    }
}

