/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.SecretDecoderRing.Encoding;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.TokenException;

public class Decryptor {
    private CryptoToken token;
    private KeyManager keyManager;

    public Decryptor(CryptoToken cryptoToken) {
        this.token = cryptoToken;
        this.keyManager = new KeyManager(cryptoToken);
    }

    public byte[] decrypt(byte[] byArray) throws CryptoManager.NotInitializedException, GeneralSecurityException, TokenException {
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getThreadToken();
        try {
            cryptoManager.setThreadToken(this.token);
            Encoding encoding = (Encoding)ASN1Util.decode(Encoding.getTemplate(), byArray);
            EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.fromOID(encoding.getEncryptionOID());
            SecretKey secretKey = this.keyManager.lookupKey(encryptionAlgorithm, encoding.getKeyID());
            if (secretKey == null) {
                throw new InvalidKeyException("No matching key found");
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(encoding.getIv());
            javax.crypto.Cipher cipher2 = javax.crypto.Cipher.getInstance(encryptionAlgorithm.toString(), "Mozilla-JSS");
            cipher2.init(2, (Key)secretKey, ivParameterSpec);
            byte[] byArray2 = cipher2.doFinal(encoding.getCiphertext());
            byte[] byArray3 = Cipher.unPad(byArray2, encryptionAlgorithm.getBlockSize());
            return byArray3;
        }
        catch (InvalidBERException invalidBERException) {
            throw new GeneralSecurityException(invalidBERException.toString());
        }
        catch (IllegalStateException illegalStateException) {
            throw new GeneralSecurityException(illegalStateException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new javax.crypto.BadPaddingException(badPaddingException.getMessage());
        }
        finally {
            cryptoManager.setThreadToken(cryptoToken);
        }
    }
}

