/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import java.io.Serializable;
import java.security.Principal;

public class AuthenticationPrincipal
implements Principal,
Cloneable,
Serializable {
    static final long serialVersionUID = -3789454378649277037L;
    public static final int AUTH_SOLARIS_USER = 0;
    public static final int AUTH_MGMT_SERVER = 1;
    public static final int AUTH_NT_USER = 2;
    private static final int AUTH_PRINCIPAL_TYPE_EOL = 2;
    private int type;
    private String name;
    private String role;
    private String host;
    private String userDesc = null;
    private String roleDesc = null;

    public AuthenticationPrincipal(int n, String string, String string2) throws AuthenticationException {
        if (n < 0 || n > 2) {
            throw new AuthenticationException("EXSS_IPT", (Object)new Integer(n));
        }
        this.type = n;
        if (string == null || string.trim().length() == 0) {
            throw new AuthenticationException("EXSS_IPN");
        }
        this.name = string;
        this.role = string2 == null || string2.trim().length() == 0 ? null : string2;
        this.host = null;
    }

    public boolean equals(Object object) {
        AuthenticationPrincipal authenticationPrincipal = null;
        boolean bl = false;
        if (object instanceof AuthenticationPrincipal && (authenticationPrincipal = (AuthenticationPrincipal)object).getUserType() == this.type && this.name.equals(authenticationPrincipal.getName())) {
            String string = authenticationPrincipal.getRoleName();
            if (this.role != null && string != null) {
                if (this.role.equals(string)) {
                    bl = true;
                }
            } else if (this.role == null && string == null) {
                bl = true;
            }
        }
        return bl;
    }

    public String getName() {
        return this.role == null ? this.name : this.role;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "Solaris-user: ";
                break;
            }
            case 1: {
                string = "Mgmt-server: ";
                break;
            }
            case 2: {
                string = "NT-user: ";
                break;
            }
            default: {
                string = "Unknown-type: ";
            }
        }
        String string2 = string + this.name;
        if (this.userDesc != null) {
            string2 = string2 + "(" + this.userDesc + ")";
        }
        if (this.role != null) {
            string2 = string2 + " in role: " + this.role;
        }
        if (this.roleDesc != null) {
            string2 = string2 + "(" + this.roleDesc + ")";
        }
        if (this.host != null) {
            string2 = string2 + " at host: " + this.host;
        }
        return string2;
    }

    public int hashCode() {
        String string = new String(this.type + this.name);
        if (this.role != null) {
            string = string.concat(this.role);
        }
        return string.hashCode();
    }

    public String getUserName() {
        return this.name;
    }

    public int getUserType() {
        return this.type;
    }

    public String getRoleName() {
        return this.role;
    }

    public String getHostName() {
        return this.host;
    }

    public void setHostName(String string) {
        this.host = string;
    }

    public AuthenticationPrincipal newCopy() throws AuthenticationException {
        AuthenticationPrincipal authenticationPrincipal = new AuthenticationPrincipal(this.type, this.name, this.role);
        if (this.host != null) {
            authenticationPrincipal.setHostName(this.host);
        }
        return authenticationPrincipal;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public String getRoleDesc() {
        return this.roleDesc;
    }

    public void setUserDesc(String string) {
        this.userDesc = string;
    }

    public void setRoleDesc(String string) {
        this.roleDesc = string;
    }
}

