
import java.rmi.*;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.PasswordCredential;
import java.util.Enumeration;

/**
 * Deletes the class specified in the command line. Works in the default
 * namespace root/cimv2.
 */
public class DeleteClass {
    public static void main(String args[]) throws CIMException {
	CIMClient cc = null;
	if (args.length != 4) {
	    System.out.println
        ("Usage: DeleteClass host className username password"); 
	    System.exit(1);
	}
	try {
	    CIMNameSpace cns = new CIMNameSpace(args[0]);
	    UserPrincipal up = new UserPrincipal(args[2]);
	    PasswordCredential pc = new PasswordCredential(args[3]);

	    cc = new CIMClient(cns, up, pc);

	    CIMObjectPath cop = new CIMObjectPath(args[1]);
	    cc.deleteClass(cop);
	}
	catch (Exception e) {
	    System.out.println("Exception: "+e);
	}
	if (cc != null) {
	    cc.close();
	}
    }
}
