/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpVar;

public class SnmpVarbindList
extends SnmpVarBindList {
    public SnmpVarbindList() {
    }

    public SnmpVarbindList(String string) {
        super(string);
    }

    public SnmpVarbindList(String string, Vector vector) {
        this(vector);
        this.identity = string;
    }

    public SnmpVarbindList(Vector vector) {
        this.elementData = new Object[vector.size()];
        this.capacityIncrement = 5;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            this.addElement(new SnmpVar(snmpVarBind));
        }
    }

    SnmpVarbindList(SnmpVarBindList snmpVarBindList) {
        this.elementData = new Object[snmpVarBindList.size()];
        this.capacityIncrement = 5;
        Enumeration enumeration = snmpVarBindList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            this.addElement(new SnmpVar(snmpVarBind));
        }
    }

    public SnmpVarbindList(SnmpVarbindList snmpVarbindList) {
        this((SnmpVarBindList)snmpVarbindList);
    }

    public synchronized void addVarbindList(SnmpVarbindList snmpVarbindList) {
        this.addVarBindList(snmpVarbindList);
    }

    public synchronized void addVariable(String string) throws SnmpStatusException {
        SnmpVar snmpVar = new SnmpVar(string);
        this.addVariable(snmpVar);
    }

    public synchronized void addVariable(SnmpVar snmpVar) {
        this.addVarBind(snmpVar);
    }

    public synchronized void addVariable(String[] stringArray) throws SnmpStatusException {
        this.addVariable(stringArray, null);
    }

    public final synchronized void addVariable(String[] stringArray, String string) throws SnmpStatusException {
        int n = 0;
        while (n < stringArray.length) {
            SnmpVar snmpVar = new SnmpVar(stringArray[n]);
            snmpVar.addInstance(string);
            this.addElement(snmpVar);
            ++n;
        }
    }

    public synchronized SnmpVarBindList cloneWithValue() {
        SnmpVarbindList snmpVarbindList = new SnmpVarbindList();
        snmpVarbindList.setTimestamp(this.getTimestamp());
        snmpVarbindList.ensureCapacity(this.size());
        int n = 0;
        while (n < this.size()) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n];
            snmpVarbindList.addElement(snmpVar.clone());
            ++n;
        }
        return snmpVarbindList;
    }

    public synchronized SnmpVarBindList cloneWithoutValue() {
        SnmpVarbindList snmpVarbindList = new SnmpVarbindList();
        int n = this.size();
        snmpVarbindList.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            snmpVarbindList.addElement(snmpVar.cloneWithoutValue());
            ++n2;
        }
        return snmpVarbindList;
    }

    public final synchronized SnmpVar getSnmpVarAt(int n) {
        return (SnmpVar)this.getVarBindAt(n);
    }

    public synchronized Enumeration getVarbindEnumeration() {
        return this.getVarBindList();
    }

    public synchronized int getVariableCount() {
        return this.getVarBindCount();
    }

    public synchronized boolean removeVarbindList(SnmpVarbindList snmpVarbindList) {
        return this.removeVarBindList(snmpVarbindList);
    }

    public synchronized boolean removeVariable(String string) throws SnmpStatusException {
        return this.removeVarBind(string);
    }

    public synchronized boolean removeVariable(SnmpVar snmpVar) {
        return this.removeVarBind(snmpVar);
    }

    public synchronized boolean removeVariable(String[] stringArray) throws SnmpStatusException {
        return this.removeVarBind(stringArray);
    }

    public synchronized boolean removeVariable(String[] stringArray, String string) throws SnmpStatusException {
        return this.removeVarBind(stringArray, string);
    }

    public final synchronized void replaceVariable(SnmpVar snmpVar, int n) {
        this.replaceVarBind(snmpVar, n);
    }

    public final synchronized void setVarbindList(Vector vector) {
        this.setVarbindList(vector, false);
    }

    public final synchronized void setVarbindList(Vector vector, boolean bl) {
        Vector vector2 = vector;
        synchronized (vector2) {
            int n = vector.size();
            this.setSize(n);
            vector.copyInto(this.elementData);
            if (bl) {
                int n2 = 0;
                while (n2 < n) {
                    SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
                    this.elementData[n2] = snmpVar.clone();
                    ++n2;
                }
            }
        }
    }

    public synchronized SnmpVarBindList splitAt(int n) {
        SnmpVarbindList snmpVarbindList = null;
        if (n > this.elementCount) {
            return snmpVarbindList;
        }
        snmpVarbindList = new SnmpVarbindList();
        int n2 = this.size();
        int n3 = n;
        while (n3 < n2) {
            snmpVarbindList.addElement(this.elementData[n3]);
            ++n3;
        }
        this.elementCount = n;
        this.trimToSize();
        return snmpVarbindList;
    }

    public synchronized Vector toVector(boolean bl) {
        int n = this.elementCount;
        if (!bl) {
            return (Vector)super.clone();
        }
        Vector<Object> vector = new Vector<Object>(n, 5);
        int n2 = 0;
        while (n2 < n) {
            SnmpVar snmpVar = (SnmpVar)this.elementData[n2];
            vector.addElement(snmpVar.clone());
            ++n2;
        }
        return vector;
    }

    public synchronized String vbListToString() {
        return this.varBindListToString();
    }
}

