/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.prodreg;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.prodreg.ProdRegAPI;
import com.sun.wbem.prodreg.ProdRegException;
import com.sun.wbem.prodreg.RegistryComponent;
import com.sun.wbem.prodreg.RegistryQuery;
import com.sun.wbem.prodreg.SoftwareElement;
import com.sun.wbem.prodreg.SoftwareFeature;
import com.sun.wbem.prodreg.SoftwareProduct;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.UserPrincipal;
import java.security.Principal;
import java.util.Vector;

public class ProductRegistry {
    private ProdRegAPI reg;
    private final int PRODUCT = 0;
    private final int FEATURE = 1;
    private final int ELEMENT = 2;
    private final int ALL = 3;

    public ProductRegistry(CIMClient cIMClient) throws ProdRegException {
        this.reg = new ProdRegAPI(cIMClient);
    }

    public ProductRegistry(String string) throws ProdRegException {
        this("", string);
    }

    public ProductRegistry(String string, String string2) throws ProdRegException {
        CIMClient cIMClient = null;
        if (this.isCimomRunning()) {
            CIMNameSpace cIMNameSpace;
            if (string.equals("")) {
                cIMNameSpace = new CIMNameSpace();
                string = cIMNameSpace.getHost();
            }
            try {
                cIMNameSpace = new CIMNameSpace(string, "root/cimv2");
                UserPrincipal userPrincipal = new UserPrincipal("root");
                PasswordCredential passwordCredential = new PasswordCredential(string2);
                cIMClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential, 1);
            }
            catch (CIMException cIMException) {
                throw new ProdRegException("PR_ERR_CONNECT_CIMOM");
            }
        }
        this.reg = new ProdRegAPI(cIMClient);
    }

    public void addChild(SoftwareFeature softwareFeature, SoftwareElement softwareElement) throws ProdRegException {
        if (this.addChildComponent(softwareFeature, softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void addChild(SoftwareFeature softwareFeature, SoftwareFeature softwareFeature2) throws ProdRegException {
        if (this.addChildComponent(softwareFeature, softwareFeature2) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void addChild(SoftwareProduct softwareProduct, SoftwareElement softwareElement) throws ProdRegException {
        if (this.addChildComponent(softwareProduct, softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void addChild(SoftwareProduct softwareProduct, SoftwareFeature softwareFeature) throws ProdRegException {
        if (this.addChildComponent(softwareProduct, softwareFeature) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void addChild(SoftwareProduct softwareProduct, SoftwareProduct softwareProduct2) throws ProdRegException {
        if (this.addChildComponent(softwareProduct, softwareProduct2) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    private int addChildComponent(RegistryComponent registryComponent, RegistryComponent registryComponent2) {
        return this.reg.addChildComponent(registryComponent, registryComponent2);
    }

    public void addRequiredComponent(RegistryComponent registryComponent, RegistryComponent registryComponent2) throws ProdRegException {
        if (this.reg.addRequiredComponent(registryComponent, registryComponent2) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void createElement(SoftwareElement softwareElement) throws ProdRegException {
        if (this.reg.register(softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void createFeature(SoftwareFeature softwareFeature) throws ProdRegException {
        if (this.reg.register(softwareFeature) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void createProduct(SoftwareProduct softwareProduct) throws ProdRegException {
        if (this.reg.register(softwareProduct) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void deleteElement(SoftwareElement softwareElement) throws ProdRegException {
        if (this.reg.unregister(softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void deleteFeature(SoftwareFeature softwareFeature) throws ProdRegException {
        if (this.reg.unregister(softwareFeature) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void deleteProduct(SoftwareProduct softwareProduct) throws ProdRegException {
        if (this.reg.unregister(softwareProduct) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public Vector getAllElements() {
        return this.getTypeVector(this.reg.getAll(), 2);
    }

    public Vector getAllFeatures() {
        return this.getTypeVector(this.reg.getAll(), 1);
    }

    public Vector getAllProducts() {
        return this.getTypeVector(this.reg.getAll(), 0);
    }

    public Vector getChildComponents(RegistryComponent registryComponent) {
        return this.getTypeVector(this.reg.getChildComponents(registryComponent), 3);
    }

    public RegistryComponent getComponent(RegistryQuery registryQuery) {
        return this.reg.get(registryQuery);
    }

    public Vector getDependentComponents(RegistryComponent registryComponent) {
        return this.getTypeVector(this.reg.getDependentComponents(registryComponent), 3);
    }

    public SoftwareElement getElement(RegistryQuery registryQuery) {
        RegistryComponent registryComponent = this.getComponent(registryQuery);
        if (registryComponent != null && registryComponent instanceof SoftwareElement) {
            return (SoftwareElement)registryComponent;
        }
        return null;
    }

    public SoftwareFeature getFeature(RegistryQuery registryQuery) {
        RegistryComponent registryComponent = this.getComponent(registryQuery);
        if (registryComponent != null && registryComponent instanceof SoftwareFeature) {
            return (SoftwareFeature)registryComponent;
        }
        return null;
    }

    public RegistryComponent getParent(RegistryComponent registryComponent) {
        return this.reg.getParent(registryComponent);
    }

    public SoftwareProduct getProduct(RegistryQuery registryQuery) {
        RegistryComponent registryComponent = this.getComponent(registryQuery);
        if (registryComponent != null && registryComponent instanceof SoftwareProduct) {
            return (SoftwareProduct)registryComponent;
        }
        return null;
    }

    public Vector getRequiredComponents(RegistryComponent registryComponent) {
        return this.getTypeVector(this.reg.getRequiredComponents(registryComponent), 3);
    }

    public Vector getTopLevelProducts() {
        return this.reg.getTopLevelProducts();
    }

    private Vector getTypeVector(RegistryComponent[] registryComponentArray, int n) {
        Vector<RegistryComponent> vector = new Vector<RegistryComponent>();
        if (registryComponentArray != null) {
            int n2 = 0;
            while (n2 < registryComponentArray.length) {
                RegistryComponent registryComponent = registryComponentArray[n2];
                switch (n) {
                    case 0: {
                        if (registryComponent instanceof SoftwareProduct) {
                            vector.add(registryComponent);
                        }
                    }
                    case 1: {
                        if (registryComponent instanceof SoftwareFeature) {
                            vector.add(registryComponent);
                        }
                    }
                    case 2: {
                        if (registryComponent instanceof SoftwareElement) {
                            vector.add(registryComponent);
                        }
                    }
                    case 3: {
                        vector.add(registryComponent);
                    }
                }
                ++n2;
            }
        }
        if (vector.size() < 1) {
            vector = null;
        }
        return vector;
    }

    private boolean isCimomRunning() {
        CIMClient cIMClient = null;
        try {
            cIMClient = new CIMClient();
        }
        catch (CIMException cIMException) {
            return false;
        }
        return true;
    }

    public void removeChild(SoftwareFeature softwareFeature, SoftwareElement softwareElement) throws ProdRegException {
        if (this.removeChildComponent(softwareFeature, softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void removeChild(SoftwareFeature softwareFeature, SoftwareFeature softwareFeature2) throws ProdRegException {
        if (this.removeChildComponent(softwareFeature, softwareFeature2) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void removeChild(SoftwareProduct softwareProduct, SoftwareElement softwareElement) throws ProdRegException {
        if (this.removeChildComponent(softwareProduct, softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void removeChild(SoftwareProduct softwareProduct, SoftwareFeature softwareFeature) throws ProdRegException {
        if (this.removeChildComponent(softwareProduct, softwareFeature) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void removeChild(SoftwareProduct softwareProduct, SoftwareProduct softwareProduct2) throws ProdRegException {
        if (this.removeChildComponent(softwareProduct, softwareProduct2) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    private int removeChildComponent(RegistryComponent registryComponent, RegistryComponent registryComponent2) {
        return this.reg.removeChildComponent(registryComponent, registryComponent2);
    }

    public void removeRequiredComponent(RegistryComponent registryComponent, RegistryComponent registryComponent2) throws ProdRegException {
        if (this.reg.removeRequiredComponent(registryComponent, registryComponent2) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void setElement(SoftwareElement softwareElement) throws ProdRegException {
        if (this.reg.register(softwareElement) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void setFeature(SoftwareFeature softwareFeature) throws ProdRegException {
        if (this.reg.register(softwareFeature) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }

    public void setProduct(SoftwareProduct softwareProduct) throws ProdRegException {
        if (this.reg.register(softwareProduct) == 0) {
            throw new ProdRegException("PR_ERR_FAILED");
        }
    }
}

