/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.CannotDeferException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.InstallerEvent;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.ManipulatorEvent;
import com.sun.patchpro.manipulators.ManipulatorListener;
import com.sun.patchpro.manipulators.NoManipulatorException;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.RemoverEvent;
import com.sun.patchpro.manipulators.VerifierEvent;
import com.sun.patchpro.model.BackoutDirectoryAccessException;
import com.sun.patchpro.model.DuplicatePatchException;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.InsufficientFileSystemSpaceException;
import com.sun.patchpro.model.InvalidPatchSourceDirectoryException;
import com.sun.patchpro.model.InvalidPatchTypeException;
import com.sun.patchpro.model.NonRootUserException;
import com.sun.patchpro.model.PatchBundlesExtractionException;
import com.sun.patchpro.model.PatchDependenciesException;
import com.sun.patchpro.model.PatchInstallException;
import com.sun.patchpro.model.PatchIsRiskyException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.SequesterDirectoryAccessException;
import com.sun.patchpro.model.SunOSPkgaddAccessException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchContents;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.SunOSTarFileHandler;
import com.sun.patchpro.util.TarFileHandlerFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchBundleInstaller
implements ManipulatorListener {
    static final String SEQUESTER_DIR_NOT_WRITABLE = "Sequester directory is not writable.";
    static final String BACKOUT_DIR_NOT_WRITABLE = "Backout directory is not writable.";
    static final String EMPTY_PATCH_LIST = "Empty patch list.";
    static final String EMPTY_PATCH_BUNDLE = "Empty patch bundle was detected.";
    public static final String FAIL_TO_INSTALL = "Failed to install a patch.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s) for:";
    static final String INTERNAL_SYSTEM_DATA_NOT_VALID = "Internal system data is not valid.";
    static final String INVALID_ARGUMENT_LIST = "Invalid argument list.";
    static final String INVALID_HOST = "Invalid host.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Specified filename for the patch bundle is invalid.";
    static final String INVALID_PATCH_TYPE = "Cannot determine patch type.";
    static final String NO_INSTALL_ALLOWED = "Policy does not allow installation of patches.";
    public static final String NON_INSTALLABLE_PATCH_TYPE = "Patch type not installable in this case.";
    public static final String DEFERRED_INSTALLABLE_PATCH_TYPE = "Patch type not installable in this case.";
    public static final String PATCH_REQT_NOT_MET = "Patch requirement for this patch is not met. ";
    static final String PATCH_NOT_SELECTED = "The patch is not selected.";
    static final String PATCH_SOURCE_DIR_NOT_VALID = "Invalid patch source directory.";
    static final String REQUIRED_PATCH_REVOKED = "Required patch has been revoked. ";
    static final String PROBLEM_EXTRACTING_PATCHES = "Problem extracting patches from patch bundles.";
    static final String RISKY_PATCH = "Recognized a discontinued, obsolete or point patch.";
    public static final String PATCHADD_PATCH_ALREADY_APPLIED = "Patch is already present.";
    public static final String PATCHADD_NON_ROOT_UID = "Not allowed to apply patches as non-root user.";
    public static final String PATCHADD_PKGADD_NOT_FOUND = "Not able to access /usr/sbin/pkgadd.";
    public static final String PATCHADD_NOT_ENOUGH_SPACE = "Not enough file system space for patch installation.";
    public static final String PROBLEM_INSTALLING_PATCH = "Problem installing patch.";
    public static final String NO_SEQUESTER_SPECIFIED = "No sequester directory has been specified.";
    public static final String DISALLOWED_PATCHES_FILE = "disallowed_patch_list";
    private Vector disallowedPatches;
    private PatchPro model;
    boolean thisPatchInstallDone;
    boolean thisPatchInstallFailed;
    boolean debug;
    boolean installAuthenticate;
    int numberOfPatchesToInstall;
    int numberOfPatchesProcessed;
    boolean bundleFailed;
    File sourceDirectory;
    File backoutDirectory;
    File sequesterDirectory;
    LocalizedMessages msgcat;
    PatchListImpl installedList;
    PatchListImpl sequesteredList;
    PatchListImpl deferredList;
    PatchListImpl failedInstallList;
    PatchListImpl unexpectedPropertyList;
    PatchListImpl uninstalledList;
    PatchProLog log;
    PatchProProperties properties;
    SignatureValidationUtil validationUtility;
    Vector listeners;
    Collection exceptionRepository;
    SessionData sessionData;
    private boolean warnedNoInstall;

    public PatchBundleInstaller() throws Exception {
        block5: {
            this.thisPatchInstallDone = false;
            this.thisPatchInstallFailed = false;
            this.debug = false;
            this.installAuthenticate = true;
            this.numberOfPatchesToInstall = 0;
            this.numberOfPatchesProcessed = 0;
            this.bundleFailed = false;
            this.uninstalledList = new PatchListImpl();
            this.validationUtility = null;
            this.warnedNoInstall = false;
            this.properties = PatchProProperties.getInstance();
            this.msgcat = new LocalizedMessages(this.properties.getLocale());
            this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
            this.log = PatchProLog.getInstance();
            try {
                String string = this.properties.getProperty("patchpro.log.file", "system");
                this.log.setLogger(new ApplicationLog(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.installAuthenticate = this.properties.getProperty("patchpro.patch.install.authenticate", "true").equals("true");
            this.listeners = new Vector();
            if (!this.properties.installAuthenticationRequired()) break block5;
            try {
                this.validationUtility = SignatureValidationUtil.getValidationUtility(this.properties, this.validationUtility);
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage(noKeystorePresentException.getMessage(), "patchpro.security.kslocation is not defined or file does not exist.")));
                this.log.println(this, 3, PatchProLog.createMessage(3, noKeystorePresentException.getMessage()));
            }
            catch (NoSigningCertException noSigningCertException) {
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage(noSigningCertException.getMessage(), "Failed to create the signature validation utility")));
                this.log.println(this, 3, PatchProLog.createMessage(3, noSigningCertException.getMessage() + ":" + noSigningCertException.getSigningCertAlias()));
            }
        }
    }

    protected void initialize(Host host) {
        this.sessionData = host.getSessionData();
        this.exceptionRepository = this.sessionData.getPatchProExceptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(installPatchListener);
        }
    }

    public PatchList install(Host host, PatchList patchList, File file, File file2, PatchPro patchPro) {
        return this.install(host, null, patchList, file, file2, patchPro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchList install(Host host, Host host2, PatchList patchList, File file, File file2, PatchPro patchPro) {
        Object object;
        FileOutputStream fileOutputStream;
        Object object2;
        String string;
        String string2;
        Object object3;
        Serializable serializable;
        Object object4;
        String string3;
        Object object5;
        Object object6;
        this.model = patchPro;
        Enumeration enumeration = null;
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent();
            this.log.println(this, 4, EMPTY_PATCH_LIST);
            return patchList;
        }
        if (file == null || !file.exists()) {
            this.handleProblem(true, new InvalidPatchSourceDirectoryException("InvalidPatchSourceDirectoryException", "InvalidPatchSourceDirectoryException.MESSAGE", "InvalidPatchSourceDirectoryException.REMEDY", 2), "PatchBundleInstaller.PATCH_SOURCE_DIR_NOT_VALID", PATCH_SOURCE_DIR_NOT_VALID);
            return patchList;
        }
        this.sourceDirectory = file;
        if (host == null) {
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("PatchBundleInstaller.INVALID_HOST", INVALID_HOST)));
            this.log.println(this, 3, INVALID_HOST);
            return patchList;
        }
        this.backoutDirectory = file2;
        if (file2 != null) {
            if (!file2.exists()) {
                file2.mkdirs();
            } else if (!file2.isDirectory() || !file2.canWrite()) {
                this.handleProblem(true, new BackoutDirectoryAccessException("BackoutDirectoryAccessException", "BackoutDirectoryAccessException.MESSAGE", "BackoutDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.BACKOUT_DIR_NOT_WRITABLE", BACKOUT_DIR_NOT_WRITABLE);
                return patchList;
            }
        }
        File file3 = this.sequesterDirectory = this.sequesterDirectory == null ? new File(this.properties.getProperty("patchpro.patch.sequester.directory")) : this.sequesterDirectory;
        if (this.sequesterDirectory == null) {
            this.handleProblem(true, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.NO_SEQUESTER_SPECIFIED", NO_SEQUESTER_SPECIFIED);
            return patchList;
        }
        if (!this.sequesterDirectory.exists()) {
            this.sequesterDirectory.mkdirs();
        } else if (!this.sequesterDirectory.isDirectory() || !this.sequesterDirectory.canWrite()) {
            this.handleProblem(true, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.SEQUESTER_DIR_NOT_WRITABLE", SEQUESTER_DIR_NOT_WRITABLE);
            return patchList;
        }
        HostSpecificInterpreter hostSpecificInterpreter = this.sessionData.getInterpreter();
        if (!this.properties.installIsAllowed(patchPro.isInteractive())) {
            object6 = "PatchBundleInstaller.NO_INSTALL_ALLOWED";
            object5 = "InvalidPatchTypeException.MESSAGE";
            boolean bl = true;
            if (patchPro.isInteractive()) {
                string3 = "InvalidPatchTypeException.INTERACTIVE_REMEDY";
            } else {
                string3 = "InvalidPatchTypeException.REMEDY";
                bl = false;
            }
            this.handleProblem(bl, new InvalidPatchTypeException("InvalidPatchTypeException", (String)object5, string3, 4), (String)object6, NO_INSTALL_ALLOWED);
            this.warnedNoInstall = true;
        }
        object6 = patchList;
        this.numberOfPatchesToInstall = object6.size();
        if (this.numberOfPatchesToInstall <= 0) {
            this.handleProblem(true, new PatchBundlesExtractionException("PatchBundlesExtractionException", "PatchBundlesExtractionException.MESSAGE", "PatchBundlesExtractionException.REMEDY", 2), "PatchBundleInstaller.EMPTY_PATH_LIST", "numberOfPatchesToInstall (" + this.numberOfPatchesToInstall + ") <= 0");
            return patchList;
        }
        this.log.println(this, 7, "Number of patches to install: " + this.numberOfPatchesToInstall);
        object5 = null;
        string3 = null;
        PatchInfo patchInfo = null;
        PatchProperties patchProperties = null;
        Enumeration enumeration2 = null;
        Enumeration enumeration3 = null;
        Realization realization = null;
        this.disallowedPatches = new Vector();
        int n = 0;
        while (n < this.numberOfPatchesToInstall) {
            block80: {
                try {
                    Vector<HardwareComponent> vector = null;
                    vector = new Vector<HardwareComponent>();
                    object5 = object6.getPatchAt(n);
                    enumeration2 = object6.getIPatchAt(n).getRealizations();
                    while (enumeration2.hasMoreElements()) {
                        realization = (Realization)enumeration2.nextElement();
                        enumeration3 = realization.getHardwareComponents();
                        while (enumeration3.hasMoreElements()) {
                            vector.addElement((HardwareComponent)enumeration3.nextElement());
                        }
                    }
                    enumeration = vector.size() == 0 ? null : vector.elements();
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block80;
                }
                this.log.println(this, 7, "Dealing with patch: " + object5.getPatchID().getPatchID());
                if (!this.checkPatchDependencies(hostSpecificInterpreter, (Patch)object5)) {
                    this.uninstalledList.addIPatch((IPatch)object5);
                    object4 = null;
                    try {
                        object4 = new Manipulator((Patch)object5, host, null, this.validationUtility);
                    }
                    catch (NoSuchImageException noSuchImageException) {
                        // empty catch block
                    }
                    this.disallowedPatches.addElement(object5.getPatchID().getPatchID());
                    this.handleProblem((Manipulable)object4, false, 10, new PatchDependenciesException("PatchDependenciesException", "PatchDependenciesException.MESSAGE", "PatchDependenciesException.REMEDY", 5), "PatchBundleInstaller.PATCH_REQT_NOT_MET", "Patch requirement for this patch is not met.  " + object5.getPatchID().getPatchID());
                    ++this.numberOfPatchesProcessed;
                } else {
                    patchInfo = object5.getPatchInfo();
                    patchProperties = patchInfo.getProperties();
                    serializable = object5.getPatchContents();
                    try {
                        object4 = ((PatchContents)serializable).getManipulator(this.sourceDirectory, host, host2, enumeration, this.validationUtility);
                        switch (object4.getStrategy(patchPro.isInteractive())) {
                            case 1: {
                                try {
                                    this.installPatch((Manipulable)object4);
                                }
                                catch (InstallFailedException installFailedException) {
                                    this.uninstalledList.addIPatch((IPatch)object5);
                                    this.handleProblem((Manipulable)object4, true, 8, new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 4), "PatchBundleInstaller.FAIL_TO_INSTALL", object5.getPatchID().getPatchID() + ": " + PROBLEM_INSTALLING_PATCH);
                                }
                                break;
                            }
                            case 3: {
                                try {
                                    this.uninstalledList.addIPatch((IPatch)object5);
                                    object4.sequester();
                                    this.sessionData.addToPatchList(10, (Patch)object5, this.msgcat.getMessage("Patch type not installable in this case.", "Patch type not installable in this case."));
                                    this.log.println(this, 6, object5.getPatchID().getPatchID() + ": " + "Patch type not installable in this case.");
                                }
                                catch (IOException iOException) {
                                    this.handleProblem((Manipulable)object4, true, 10, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.FAIL_TO_INSTALL", SEQUESTER_DIR_NOT_WRITABLE);
                                }
                                break;
                            }
                            case 2: {
                                try {
                                    this.uninstalledList.addIPatch((IPatch)object5);
                                    object4.defer();
                                    this.sessionData.addToPatchList(11, (Patch)object5, this.msgcat.getMessage("Patch type not installable in this case.", "Patch will be installed at the next scheduled reboot."));
                                    this.log.println(this, 6, object5.getPatchID().getPatchID() + ": " + "Patch type not installable in this case.");
                                }
                                catch (CannotDeferException cannotDeferException) {
                                    this.handleProblem((Manipulable)object4, true, 10, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.FAIL_TO_INSTALL", SEQUESTER_DIR_NOT_WRITABLE);
                                }
                                break;
                            }
                            case 4: {
                                this.uninstalledList.addIPatch((IPatch)object5);
                                if (!patchPro.isInteractive()) {
                                    object3 = "PatchBundleInstaller.PATCH_IS_RISKY";
                                    string2 = "PatchIsRiskyException.MESSAGE";
                                    string = "PatchIsRiskyException.REMEDY";
                                    this.handleProblem((Manipulable)object4, true, 7, new PatchIsRiskyException("PatchIsRiskyException", string2, string, 2), (String)object3, "Recognized a discontinued, obsolete or point patch. " + object5.getPatchID().getPatchID());
                                    break;
                                }
                                if (patchProperties.isDiscontinued() || patchProperties.isNonstandard() || patchProperties.isPointpatch() || patchProperties.isObsolete()) {
                                    object3 = "PatchBundleInstaller.PATCH_RISKY_INTERACTIVE";
                                    string2 = "PatchIsRiskyException.INTERACTIVE_MESSAGE";
                                    string = "PatchIsRiskyException.INTERACTIVE_REMEDY";
                                    object2 = new PatchIsRiskyException("PatchIsRiskyException", string2, string, 2);
                                    this.handleProblem((Manipulable)object4, true, 7, (PatchProException)object2, (String)object3, "Policy does not allow installation of patches. " + object5.getPatchID().getPatchID());
                                    break;
                                }
                                object3 = patchProperties.isInteractive() ? "PatchBundleInstaller.PATCH_INTERACTIVE" : "PatchBundleInstaller.PATCH_INVALID";
                                this.disallowedPatches.addElement(object5.getPatchID().getPatchID());
                                string2 = "InvalidPatchTypeException.INTERACTIVE_MESSAGE";
                                string = "InvalidPatchTypeException.INTERACTIVE_REMEDY";
                                object2 = new InvalidPatchTypeException("InvalidPatchTypeException", string2, string, 5);
                                this.handleProblem((Manipulable)object4, true, 0, (PatchProException)object2, (String)object3, "Policy does not allow installation of patches. " + object5.getPatchID().getPatchID());
                                break;
                            }
                            default: {
                                this.uninstalledList.addIPatch((IPatch)object5);
                                this.handleProblem((Manipulable)object4, true, 7, new PatchIsRiskyException("PatchIsRiskyException", "PatchIsRiskyException.MESSAGE", "PatchIsRiskyException.REMEDY", 4), "PatchBundleInstaller.RISKY_PATCH_TYPE", "Recognized a discontinued, obsolete or point patch. " + object5.getPatchID().getPatchID());
                                break;
                            }
                        }
                    }
                    catch (NoManipulatorException noManipulatorException) {
                        this.handleProblem(new Manipulator(), true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleInstaller.INVALID_PATCH_TYPE", "Patch type not installable in this case. " + object5.getPatchID().getPatchID());
                    }
                    catch (NoSuchImageException noSuchImageException) {
                        this.handleProblem(new Manipulator(), true, 0, new PatchNotFoundException("PatchNotFoundException", "PatchNotFoundException.MESSAGE", "PatchNotFoundException.REMEDY", 4), "Installer.NO_PATCH_IMAGE", "The installer cannot find the patch. " + object5.getPatchID().getPatchID());
                    }
                    ++this.numberOfPatchesProcessed;
                }
                this.dispatchProgressEvent();
            }
            ++n;
        }
        this.log.println(this, 7, "PatchBundleInstaller: Done with all patches.");
        this.dispatchProgressEvent();
        object4 = null;
        serializable = null;
        object3 = this.sourceDirectory.listFiles();
        string2 = null;
        string = null;
        if (object3 == null) {
            this.log.println(this, 4, "No download summary file to be sequestered.");
        } else {
            object2 = null;
            fileOutputStream = null;
            object = new byte[16384];
            int n2 = 0;
            while (n2 < ((File[])object3).length) {
                string2 = object3[n2].getName();
                string = object3[n2].getPath();
                if (string2.indexOf("patchpro_dnld_") != -1 && ((File)(object4 = new File(string))).exists()) {
                    try {
                        object2 = null;
                        fileOutputStream = null;
                        serializable = new File(this.sequesterDirectory.getPath() + File.separator + string2);
                        if (!((File)serializable).exists()) {
                            ((File)serializable).createNewFile();
                        }
                        object2 = new FileInputStream(((File)object4).getPath());
                        fileOutputStream = new FileOutputStream(((File)serializable).getPath());
                        int n3 = 0;
                        while ((n3 = ((FileInputStream)object2).read((byte[])object, 0, ((Object)object).length)) != -1) {
                            fileOutputStream.write((byte[])object, 0, n3);
                        }
                    }
                    catch (IOException iOException) {
                        this.log.printStackTrace(this, 2, iOException);
                    }
                    catch (Exception exception) {
                        this.log.printStackTrace(this, 2, exception);
                    }
                    finally {
                        try {
                            if (object2 != null) {
                                ((FileInputStream)object2).close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    if (((File)object4).delete()) {
                        System.out.println(((File)object4).getPath() + " " + this.msgcat.getMessage("PatchBundleInstaller.moved", "has been moved to") + " " + ((File)serializable).getPath());
                    } else {
                        System.out.println(((File)object4).getPath() + " " + this.msgcat.getMessage("PatchBundleInstaller.copied", "has been copied to") + " " + ((File)serializable).getPath());
                    }
                }
                ++n2;
            }
        }
        if (this.disallowedPatches.size() > 0) {
            object2 = new File(this.sourceDirectory, DISALLOWED_PATCHES_FILE);
            try {
                fileOutputStream = new FileOutputStream((File)object2);
                object = new PrintStream(fileOutputStream);
                Iterator iterator = this.disallowedPatches.iterator();
                while (iterator.hasNext()) {
                    ((PrintStream)object).println(iterator.next());
                }
                ((PrintStream)object).close();
                fileOutputStream.close();
                System.out.println(" \n" + this.msgcat.getMessage("PatchBundleInstaller.disallowedFile", "ID's of the patches that are disallowed by the installation policy have been \nwritten to file") + "\n\t" + ((File)object2).getPath() + "\n" + this.msgcat.getMessage("PatchBundleInstaller.disallowedInstruction", new String[]{((File)object2).getPath()}, "Please use \n\tsmpatch add -x idlist=<patch_list_file> \nto install these patches."));
            }
            catch (IOException iOException) {
                System.err.println("Failed when writing to file " + ((File)object2).getPath() + ":" + iOException.getMessage());
            }
        }
        this.dispatchDoneEvent();
        try {
            object2 = this.sessionData.getPatchesNotInstalled();
        }
        catch (Exception exception) {
            object2 = new PatchListImpl();
        }
        return object2;
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    public Percentage installProgress() {
        Percentage percentage;
        float f = 100.0f;
        if (this.numberOfPatchesToInstall != 0) {
            f = (float)this.numberOfPatchesProcessed / (float)this.numberOfPatchesToInstall * 100.0f;
        }
        try {
            percentage = new Percentage((int)f);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "PatchBundleInstaller.getPatchInstallProgress(): Unable to create a Percentage from " + f + ".");
            f = 100.0f;
            percentage = new Percentage((int)f);
        }
        return percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgressEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(n);
                installPatchListener.installPatchProgress(new InstallPatchEvent(this));
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDoneEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(n);
                installPatchListener.installPatchDone(new InstallPatchEvent(this));
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchFailedEvent(String string) {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(n);
                installPatchListener.installPatchFailed(new InstallPatchEvent(this, string));
                ++n;
            }
        }
    }

    private void addToPatchList(int n, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
    }

    private void addToPatchList(int n, int n2, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
        this.sessionData.addToPatchList(n2, patch, string);
    }

    private void extractBundle(File file) {
        SunOSTarFileHandler sunOSTarFileHandler = new SunOSTarFileHandler();
        try {
            sunOSTarFileHandler.extract(file.getPath(), file.getPath(), "patchesBundle.tar", false);
        }
        catch (TarFileHandlerFailedException tarFileHandlerFailedException) {}
    }

    private boolean checkPatchDependencies(HostSpecificInterpreter hostSpecificInterpreter, Patch patch) {
        String[] stringArray;
        this.log.println(this, 7, "Checking patch dependencies for: " + patch.getPatchID().getPatchID());
        PatchInfo patchInfo = patch.getPatchInfo();
        if (patchInfo == null) {
            this.log.println(this, 3, patch.getPatchID().getPatchID() + ": " + INTERNAL_SYSTEM_DATA_NOT_VALID + ": patchInfo is null");
            return false;
        }
        String string = patchInfo.getRequires();
        if (string.indexOf("(") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        } else {
            try {
                stringArray = hostSpecificInterpreter.getPatchList(string);
            }
            catch (ParseError parseError) {
                this.log.printStackTrace(this, 3, parseError);
                return false;
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            if (this.uninstalledList.getIPatchByIDString(stringArray[n]) != null) {
                this.log.println(this, 4, patch.getPatchID().getPatchID() + ": " + REQUIRED_PATCH_REVOKED + " " + stringArray[n]);
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean allPatchTypesAreAllowed(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            if (!vector2.contains(vector.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPatch(Manipulable manipulable) throws InstallFailedException {
        Installable installable = null;
        Patch patch = manipulable.getPatch();
        this.thisPatchInstallDone = false;
        this.thisPatchInstallFailed = false;
        try {
            try {
                installable = manipulable.getInstaller();
                Thread thread = new Thread(installable);
                installable.addListener(this);
                thread.start();
                while (!this.thisPatchInstallDone) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                installable.removeListener(this);
                if (thread != null) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.thisPatchInstallFailed) {
                    throw new PatchInstallFailedException(installable.getFailure().getMessage());
                }
                System.out.println(patch.getPatchID().getPatchID() + " " + this.msgcat.getMessage("PatchBundleInstaller.applied", "has been applied."));
                this.log.println(this, 7, "Just invoked installPatch for: " + patch.getPatchID().getPatchID());
                this.sessionData.addToPatchList(9, patch, "");
            }
            catch (InstallFailedException installFailedException) {
                this.recordInstallFailedException(installFailedException, patch);
                if (installFailedException instanceof PatchInstallFailedException) {
                    this.log.println(this, 1, "Failed to install a patch. " + patch.getPatchID().getPatchID() + "\n\npatchadd utility failed. " + "Reason code :" + ((PatchInstallFailedException)installFailedException).getReasonCode() + "\n" + ((PatchInstallFailedException)installFailedException).getMessage());
                } else {
                    this.log.println(this, 1, "Failed to install a patch. " + patch.getPatchID().getPatchID());
                }
                this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_INSTALL", "Fail to install a patch.") + " " + patch.getPatchID().getPatchID()));
                this.log.printStackTrace(this, 7, installFailedException);
                Object var7_9 = null;
                if (installable != null) {
                    installable.removeListener(this);
                }
            }
            Object var7_8 = null;
            if (installable != null) {
                installable.removeListener(this);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (installable != null) {
                installable.removeListener(this);
            }
            throw throwable;
        }
    }

    private void handleProblem(Manipulable manipulable) {
        this.handleProblem(manipulable, true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleInstaller.INVALID_PATCH_TYPE", INVALID_PATCH_TYPE);
    }

    private void handleProblem(boolean bl, PatchProException patchProException, String string, String string2) {
        this.handleProblem(null, bl, -1, patchProException, string, string2);
    }

    private void handleProblem(Manipulable manipulable, boolean bl, int n, PatchProException patchProException, String string, String string2) {
        Patch patch;
        String string3 = "";
        this.bundleFailed = true;
        Object[] objectArray = null;
        if (manipulable != null && (patch = manipulable.getPatch()) != null) {
            string3 = new String("" + patch.getPatchID().getPatchID());
            objectArray = new Object[]{string3};
            if (!this.model.isInteractive()) {
                if (n == 10) {
                    this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, objectArray, "Patch has failed for an unknown reason."));
                } else {
                    this.addToPatchList(n, 10, patch, this.msgcat.getMessage(string, objectArray, "Patch has failed for an unknown reason."));
                }
                try {
                    manipulable.sequester();
                }
                catch (IOException iOException) {}
            } else {
                this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, objectArray, "Patch has failed for an unknown reason."));
            }
        }
        if (!this.warnedNoInstall) {
            this.updateExceptionRepository(patchProException);
            this.log.println(this, patchProException.getSeverity(), string2);
            if (bl) {
                if (objectArray != null) {
                    this.dispatchFailedEvent(PatchProLog.createMessage(patchProException.getSeverity(), this.msgcat.getMessage(string, objectArray, "Patch install has failed for an unknown reason.")));
                } else {
                    this.dispatchFailedEvent(PatchProLog.createMessage(patchProException.getSeverity(), this.msgcat.getMessage(string, "Patch install has failed for an unknown reason.")));
                }
            }
        }
    }

    private void recordInstallFailedException(InstallFailedException installFailedException, Patch patch) {
        if (installFailedException instanceof PatchInstallFailedException) {
            int n = ((PatchInstallFailedException)installFailedException).getReasonCode();
            switch (n) {
                case 2: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_PATCH_ALREADY_APPLIED);
                    DuplicatePatchException duplicatePatchException = new DuplicatePatchException("DuplicatePatchException", "DuplicatePatchException.MESSAGE", "DuplicatePatchException.REMEDY", 3);
                    this.updateExceptionRepository(duplicatePatchException);
                    break;
                }
                case 3: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_NON_ROOT_UID);
                    NonRootUserException nonRootUserException = new NonRootUserException("NonRootUserException", "NonRootUserException.MESSAGE", "NonRootUserException.REMEDY", 3);
                    this.updateExceptionRepository(nonRootUserException);
                    break;
                }
                case 9: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_PKGADD_NOT_FOUND);
                    SunOSPkgaddAccessException sunOSPkgaddAccessException = new SunOSPkgaddAccessException("SunOSPkgaddAccessException", "SunOSPkgaddAccessException.MESSAGE", "SunOSPkgaddAccessException.REMEDY", 3);
                    this.updateExceptionRepository(sunOSPkgaddAccessException);
                    break;
                }
                case 18: {
                    this.addToPatchList(8, patch, PATCHADD_NOT_ENOUGH_SPACE);
                    InsufficientFileSystemSpaceException insufficientFileSystemSpaceException = new InsufficientFileSystemSpaceException("InsufficientFileSystemSpaceException", "InsufficientFileSystemSpaceException.MESSAGE", "InsufficientFileSystemSpaceException.REMEDY", 3);
                    this.updateExceptionRepository(insufficientFileSystemSpaceException);
                    break;
                }
                default: {
                    this.sessionData.addToPatchList(7, patch, FAIL_TO_INSTALL);
                    PatchInstallException patchInstallException = new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 3);
                    this.updateExceptionRepository(patchInstallException);
                }
            }
        }
    }

    private void updateExceptionRepository(PatchProException patchProException) {
        if (!this.exceptionRepository.contains(patchProException)) {
            this.exceptionRepository.add(patchProException);
        }
    }

    public void manipulatorProgress(ManipulatorEvent manipulatorEvent) {
        this.dispatchProgressEvent();
    }

    public void manipulatorDone(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
    }

    public void manipulatorFailed(InstallerEvent installerEvent) {
        Exception exception = ((Installable)installerEvent.getSource()).getFailure();
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent(exception.getMessage());
    }

    public void manipulatorFailed(RemoverEvent removerEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Remover event.");
    }

    public void manipulatorFailed(VerifierEvent verifierEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Verifier event.");
    }

    public void manipulatorFailed(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Manipulable event.");
    }
}

