/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.database;

import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.NoSuchDatabaseException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.SimpleDatabase;
import com.sun.patchpro.database.PatchBaseRecord;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.RealizationRecord;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchProperties;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MemoryPatchDB
implements PatchDB,
Serializable {
    private String OSName = null;
    private String OSRelease = null;
    private String Architecture = null;
    private URL patchbaseUrl;
    private URL realizationUrl;
    private SimpleDatabase patchBaseDB;
    private SimpleDatabase realizationDB;

    public MemoryPatchDB() {
    }

    public MemoryPatchDB(SimpleDatabase simpleDatabase, SimpleDatabase simpleDatabase2) {
        this.patchBaseDB = simpleDatabase;
        this.realizationDB = simpleDatabase2;
    }

    public MemoryPatchDB(String string, String string2, String string3, SimpleDatabase simpleDatabase, SimpleDatabase simpleDatabase2) {
        this.patchBaseDB = simpleDatabase;
        this.realizationDB = simpleDatabase2;
        this.setTarget(string, string2, string3);
    }

    public void setTarget(String string, String string2, String string3) {
        this.OSName = string;
        this.OSRelease = string2;
        this.Architecture = string3;
    }

    public void setDatabase(String string) {
    }

    public void openDatabase() throws NoSuchDatabaseException {
    }

    public void closeDatabase() {
        try {
            if (this.patchBaseDB != null) {
                this.patchBaseDB.closeDatabase();
                this.patchBaseDB = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.realizationDB != null) {
                this.realizationDB.closeDatabase();
                this.realizationDB = null;
            }
        }
        catch (Throwable throwable) {}
    }

    public Enumeration getPatches(Realization realization) throws NoSuchPatchException {
        RealizationRecord realizationRecord;
        Hashtable hashtable = new Hashtable();
        String string = new String(realization.getBasename() + "-" + realization.getVersion());
        try {
            realizationRecord = (RealizationRecord)this.realizationDB.findObject("realization", (Object)string);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new NoSuchPatchException("No patches for " + string + ".");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            PatchProLog.getInstance().println(this, 3, noSuchFieldException.getMessage());
            throw new NoSuchPatchException("Could not find Field.");
        }
        catch (Error error) {
            PatchProLog.getInstance().println(this, 2, error.getMessage());
            throw error;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(realizationRecord.patchIDs);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PatchBaseRecord patchBaseRecord = this.basicGetPatch(string2, true);
            this.qualifyPatch(patchBaseRecord, hashtable);
        }
        if (hashtable.isEmpty()) {
            throw new NoSuchPatchException("No patches meet the criteria.");
        }
        return hashtable.elements();
    }

    public PatchImpl getPatch(PatchID patchID) throws NoSuchPatchException {
        PatchImpl patchImpl = null;
        String string = new String(patchID.getBasecode() + "-" + patchID.getRevision());
        PatchBaseRecord patchBaseRecord = this.basicGetPatch(string, false);
        try {
            patchImpl = this.constructPatchObject(patchBaseRecord);
        }
        catch (Exception exception) {
            PatchProLog.getInstance().println(this, 2, "MemoryPatchDB.getPatch: Unable to  construct patch, " + string + ". Error is " + exception.getMessage() + ".");
            throw new NoSuchPatchException("Could not construct patch from patch ID.");
        }
        return patchImpl;
    }

    public PatchImpl getLatestPatch(PatchID patchID) throws NoSuchPatchException {
        PatchImpl patchImpl = null;
        String string = new String(patchID.getBasecode() + "-" + patchID.getRevision());
        PatchBaseRecord patchBaseRecord = this.basicGetPatch(string, true);
        try {
            patchImpl = this.constructPatchObject(patchBaseRecord);
        }
        catch (Exception exception) {
            PatchProLog.getInstance().println(this, 2, "MemoryPatchDB.getLatestPatch: Unable to  construct patch, " + string + ". Error is " + exception.getMessage() + ".");
            throw new NoSuchPatchException("Could not construct patch from patch ID.");
        }
        return patchImpl;
    }

    private void qualifyPatch(PatchBaseRecord patchBaseRecord, Hashtable hashtable) {
        block7: {
            if (hashtable.containsKey(patchBaseRecord.patchBaseCode)) break block7;
            if (this.OSName != null && patchBaseRecord.targetOS.compareTo(this.OSName) != 0) {
                return;
            }
            if (this.OSRelease != null) {
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(patchBaseRecord.targetRelease);
                while (stringTokenizer.hasMoreTokens()) {
                    if (stringTokenizer.nextToken().compareTo(this.OSRelease) != 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            if (this.Architecture != null && patchBaseRecord.targetArchitecture.indexOf(this.Architecture) == -1) {
                return;
            }
            try {
                PatchImpl patchImpl = this.constructPatchObject(patchBaseRecord);
                hashtable.put(patchImpl.getPatchID().getBasecode(), patchImpl);
            }
            catch (MalformedPatchException malformedPatchException) {
                PatchProLog.getInstance().println(this, 2, "MemoryPatchDB.qualifyPatch: Unable to construct a patch object from, " + patchBaseRecord.patchBaseCode + "-" + patchBaseRecord.patchVersion + ".");
            }
        }
    }

    private PatchImpl constructPatchObject(PatchBaseRecord patchBaseRecord) throws MalformedPatchException {
        String string = new String("unknown");
        PatchID patchID = new PatchID(patchBaseRecord.patchBaseCode + "-" + patchBaseRecord.patchVersion);
        PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
        patchInfoImpl.setSynopsis(patchBaseRecord.synopsis);
        patchInfoImpl.setArchitecture(patchBaseRecord.targetArchitecture);
        patchInfoImpl.setOS(patchBaseRecord.targetOS);
        patchInfoImpl.setRelease(patchBaseRecord.targetRelease);
        patchInfoImpl.setType(patchBaseRecord.type);
        StringTokenizer stringTokenizer = new StringTokenizer(patchBaseRecord.corrects);
        while (stringTokenizer.hasMoreElements()) {
            string = (String)stringTokenizer.nextElement();
            try {
                patchInfoImpl.addRealization(new Realization(string));
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                PatchProLog.getInstance().println(this, 2, "MemoryPatchDB.constructPatchObject: Ignoring invalid realization, " + string + ", in patch " + patchID.getPatchID() + ".");
            }
        }
        patchInfoImpl.setObsolesces(patchBaseRecord.obsolesces);
        patchInfoImpl.setRequires(patchBaseRecord.requires);
        patchInfoImpl.setConstraint(patchBaseRecord.constraint);
        patchInfoImpl.setIncompat(patchBaseRecord.incompatibleWith);
        patchInfoImpl.setPrefers(patchBaseRecord.prefers);
        patchInfoImpl.setProperties(new PatchProperties(patchBaseRecord.properties));
        if (patchBaseRecord.obsolescedBy != null && patchBaseRecord.obsolescedBy.compareTo("") != 0) {
            try {
                patchInfoImpl.setObsolescedBy(new PatchID(patchBaseRecord.obsolescedBy));
            }
            catch (MalformedPatchException malformedPatchException) {
                // empty catch block
            }
        }
        return new PatchImpl(patchInfoImpl, patchID);
    }

    /*
     * Unable to fully structure code
     */
    private PatchBaseRecord basicGetPatch(String var1_1, boolean var2_2) throws NoSuchPatchException {
        var3_3 = this.getPatchBaseCode(var1_1);
        var4_4 = this.getPatchVersion(var1_1);
        var8_5 = null;
        var5_6 = new Integer(var4_4);
        try {
            var6_7 = this.patchBaseDB.findList("patchBaseCode", (Object)var3_3);
            if (true) ** GOTO lbl28
        }
        catch (NoSuchObjectException var9_8) {
            throw new NoSuchPatchException("No patch matches the base code " + var3_3 + ".");
        }
        catch (NoSuchFieldException var10_11) {
            throw new DatabaseError((Exception)var10_11, "MemoryPatchDB.basicGetPatch: patchBaseCode is apparently not a valid field!!!");
        }
        do {
            try {
                var7_12 = (PatchBaseRecord)this.patchBaseDB.getObject(((Integer)var6_7.nextElement()).intValue());
            }
            catch (NoSuchObjectException var9_10) {
                var9_10.printStackTrace();
                throw new NoSuchPatchException(var9_10.getMessage());
            }
            if (var2_2) {
                var9_9 = new Integer(var7_12.patchVersion);
                if (var9_9 < var5_6) continue;
                var8_5 = var7_12;
                var5_6 = var9_9;
                continue;
            }
            if (var7_12.patchVersion.compareTo(var4_4) != 0) continue;
            var8_5 = var7_12;
            break;
lbl28:
            // 4 sources

        } while (var6_7.hasMoreElements());
        if (var8_5 == null) {
            if (var2_2) {
                throw new NoSuchPatchException("No patch version equal to or later than " + var1_1 + ".");
            }
            throw new NoSuchPatchException("No patch matching " + var1_1 + ".");
        }
        return var8_5;
    }

    private String getPatchBaseCode(String string) {
        return string.substring(0, string.indexOf("-"));
    }

    private String getPatchVersion(String string) {
        return string.substring(string.indexOf("-") + 1);
    }
}

