/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.ConfigurationReader;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;

public class SunOSTargetInfo
implements BaseDataDetector {
    private PatchProProperties properties;
    private Host targetHost;
    private PatchProLog log = PatchProLog.getInstance();

    public SunOSTargetInfo() {
        this.properties = PatchProProperties.getInstance();
    }

    public void run() {
        block16: {
            Object object;
            String string = this.properties.getProperty("test.patchpro.operatingSystem");
            if (string == null) {
                this.targetHost.setOperatingSystem("SunOS");
            } else {
                this.targetHost.setOperatingSystem(string);
            }
            string = this.properties.getProperty("test.patchpro.OSRelease");
            if (string == null) {
                this.targetHost.setOSRelease(System.getProperty("os.version"));
            } else {
                this.targetHost.setOSRelease(string);
            }
            string = this.properties.getProperty("test.patchpro.arch");
            if (string == null) {
                this.targetHost.setArchitecture(Host.getOSArchitectureName());
            } else {
                this.targetHost.setArchitecture(string);
            }
            String string2 = this.properties.getProperty("patchpro.hdw.read.path");
            File file = new File(string2);
            if (file != null && file.exists() && file.canRead()) {
                object = new ConfigurationReader(string2);
                ((ConfigurationReader)object).readConfig(this.targetHost);
            }
            try {
                string = this.properties.getProperty("test.patchpro.platform");
                if (string == null) {
                    this.targetHost.setPlatform(this.getPlatform());
                } else {
                    this.targetHost.setPlatform(string);
                }
            }
            catch (DetectorFailedException detectorFailedException) {
                // empty catch block
            }
            try {
                object = InetAddress.getLocalHost();
                string = this.properties.getProperty("test.patchpro.hostip");
                if (string == null) {
                    this.targetHost.setAddress(((InetAddress)object).getHostAddress());
                } else {
                    this.targetHost.setAddress(string);
                }
                string = this.properties.getProperty("test.patchpro.hostname");
                if (string == null) {
                    this.targetHost.setHostName(((InetAddress)object).getHostName());
                    break block16;
                }
                this.targetHost.setHostName(string);
            }
            catch (Exception exception) {}
        }
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    private String getPlatform() throws DetectorFailedException {
        byte[] byArray = new byte[100];
        try {
            Process process = Runtime.getRuntime().exec("/usr/bin/uname -i");
            InputStream inputStream = process.getInputStream();
            int n = inputStream.read(byArray, 0, 100);
            if (n == -1) {
                this.log.println(this, 4, "SunOSBaseData.getPlatform(): No platform data found.");
                throw new DetectorFailedException("No platform data found.");
            }
            if (n == 100) {
                this.log.println(this, 4, "SunOSBaseData.getPlatform(): Platform data makes no sense.");
                throw new DetectorFailedException("Platform data makes no sense.");
            }
            return new String(byArray).trim();
        }
        catch (IOException iOException) {
            throw new DetectorFailedException(iOException.getMessage());
        }
    }

    public String getMessage() {
        return "";
    }

    public Percentage percentComplete() {
        return new Percentage(100);
    }

    public void addListener(DetectorListener detectorListener) {
    }

    public void removeListener(DetectorListener detectorListener) {
    }
}

