/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.ConfirmationPageInteractiveDetector;
import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.DiskArrayInteractiveDetector;
import com.sun.patchpro.analysis.FirmwareInteractiveDetector;
import com.sun.patchpro.analysis.InteractiveDetector;
import com.sun.patchpro.analysis.NoMoreDetectorsException;
import com.sun.patchpro.analysis.NoninteractiveException;
import com.sun.patchpro.analysis.TapeSubsystemInteractiveDetector;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.InteractionSet;
import java.util.Enumeration;

public class InteractiveAnalyzer {
    private PatchProLog log;
    private Host targetHost;
    private boolean targetHostIsNew = false;
    private int currentDetector = -1;
    private boolean awaitingInteractionSet = false;
    private boolean movingForward = true;
    private boolean finishedWithInteractiveDetectors = false;
    private InteractiveDetector[] detectors = new InteractiveDetector[]{new FirmwareInteractiveDetector(), new DiskArrayInteractiveDetector(), new TapeSubsystemInteractiveDetector(), new ConfirmationPageInteractiveDetector()};

    public InteractiveAnalyzer(Host host) {
        this.log = PatchProLog.getInstance();
        this.targetHost = host;
        int n = 0;
        while (n < this.detectors.length) {
            this.loadRealizations(this.detectors[n].getRealizations(), host);
            ++n;
        }
        this.initializeDetectors();
    }

    private void loadRealizations(Enumeration enumeration, Host host) {
        while (enumeration.hasMoreElements()) {
            host.addRealization((Realization)enumeration.nextElement(), false);
        }
    }

    public void cancel() {
        this.log.println(this, 2, "Cancel is not implemented in the InteractiveAnalyzer.");
    }

    /*
     * Unable to fully structure code
     */
    public synchronized InteractionSet nextInteractiveDetector() throws NoMoreDetectorsException, DetectorFailedException {
        var1_1 = null;
        var2_2 = true;
        if (this.targetHost != null) ** GOTO lbl14
        throw new DetectorFailedException("nextInteractiveDetector: Target host emulation does not yet exist.");
lbl-1000:
        // 1 sources

        {
            this.setCurrentDetector(true);
            try {
                var1_1 = this.detectors[this.currentDetector].analyze(this.targetHost);
                var1_1.reset();
                this.awaitingInteractionSet = true;
                var2_2 = false;
                break;
            }
            catch (NoninteractiveException var3_3) {
                // empty catch block
            }
lbl14:
            // 2 sources

            ** while (this.hasNextInteractiveDetector())
        }
lbl15:
        // 2 sources

        if (var2_2) {
            throw new NoMoreDetectorsException("nextInteractiveDetector: At the last detector.");
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized InteractionSet priorInteractiveDetector() throws NoMoreDetectorsException, DetectorFailedException {
        var1_1 = null;
        var2_2 = true;
        if (this.targetHost != null) ** GOTO lbl14
        throw new DetectorFailedException("priorInteractiveDetector: Target host emulation does not yet exist.");
lbl-1000:
        // 1 sources

        {
            this.setCurrentDetector(false);
            try {
                var1_1 = this.detectors[this.currentDetector].analyze(this.targetHost);
                var1_1.reset();
                this.awaitingInteractionSet = true;
                var2_2 = false;
                break;
            }
            catch (NoninteractiveException var3_3) {
                // empty catch block
            }
lbl14:
            // 2 sources

            ** while (this.hasPriorInteractiveDetector())
        }
lbl15:
        // 2 sources

        if (var2_2) {
            throw new NoMoreDetectorsException("priorInteractiveDetector: At the first detector.");
        }
        return var1_1;
    }

    public boolean hasNextInteractiveDetector() {
        boolean bl = this.currentDetector + 1 < this.detectors.length;
        return bl;
    }

    public void initializeDetectors() {
        this.currentDetector = -1;
        this.awaitingInteractionSet = false;
    }

    public boolean hasPriorInteractiveDetector() {
        return this.currentDetector >= 1;
    }

    public void setInteractionSet(InteractionSet interactionSet) throws DetectorFailedException {
        if (this.awaitingInteractionSet) {
            this.detectors[this.currentDetector].setInteractionSet(interactionSet);
            this.awaitingInteractionSet = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCurrentDetector(boolean bl) throws NoMoreDetectorsException {
        if (bl) {
            if (!this.hasNextInteractiveDetector()) throw new NoMoreDetectorsException("setCurrentDetector: At the last detector.");
            ++this.currentDetector;
        } else if (this.finishedWithInteractiveDetectors) {
            this.finishedWithInteractiveDetectors = false;
        } else {
            if (!this.hasPriorInteractiveDetector()) throw new NoMoreDetectorsException("setCurrentDetector: At the first detector.");
            --this.currentDetector;
        }
        this.awaitingInteractionSet = false;
    }

    public void finished() {
        this.finishedWithInteractiveDetectors = true;
    }
}

