/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.rbac;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.UMgrPropsPanel;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.rbac.RightAuthProps;
import com.sun.admin.usermgr.client.rbac.RightCmdProps;
import com.sun.admin.usermgr.client.rbac.RightContent;
import com.sun.admin.usermgr.client.rbac.RightGenProps;
import com.sun.admin.usermgr.client.rbac.RightPropsDlg;
import com.sun.admin.usermgr.client.rbac.RightSubProps;
import com.sun.admin.usermgr.common.RightObj;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RightTabs
extends JTabbedPane {
    private RightObj rightObj = null;
    private RightPropsDlg parent;
    private GenInfoPanel infoPanel;
    private RightTabs rightTabs;
    private RightGenProps rightGenProps;
    private RightCmdProps rightCmdProps;
    private RightAuthProps rightAuthProps;
    private RightSubProps rightSubProps;
    private boolean isGenVisited;
    private boolean isCmdVisited;
    private boolean isAuthVisited;
    private boolean isSubVisited;
    private VUserMgr theApp;
    private boolean isNew;
    private ResourceBundle bundle;

    public RightTabs(VUserMgr vUserMgr, RightObj rightObj, GenInfoPanel genInfoPanel, RightPropsDlg rightPropsDlg, boolean bl) {
        this.theApp = vUserMgr;
        this.rightObj = rightObj;
        this.parent = rightPropsDlg;
        this.infoPanel = genInfoPanel;
        this.bundle = vUserMgr.getResourceBundle();
        this.isGenVisited = true;
        this.isCmdVisited = false;
        this.isAuthVisited = false;
        this.isSubVisited = false;
        this.isNew = bl;
        this.RightTabsInit();
    }

    private void RightTabsInit() {
        this.rightTabs = this;
        RightTabsListener rightTabsListener = new RightTabsListener();
        this.addChangeListener(rightTabsListener);
        this.addFocusListener(new TabPaneFocusListener(rightTabsListener));
        this.setupRightTabs(this.rightObj);
    }

    static /* synthetic */ boolean access$11(RightTabs rightTabs) {
        return rightTabs.isSubVisited;
    }

    static /* synthetic */ boolean access$2(RightTabs rightTabs) {
        return rightTabs.isGenVisited;
    }

    static /* synthetic */ boolean access$5(RightTabs rightTabs) {
        return rightTabs.isCmdVisited;
    }

    static /* synthetic */ boolean access$8(RightTabs rightTabs) {
        return rightTabs.isAuthVisited;
    }

    public void enableOKBtn() {
        this.parent.enablePropOKBtn();
    }

    public boolean isUpdatePropsOK(RightObj rightObj) {
        ServiceWrapper serviceWrapper = this.theApp.getUserMgr();
        RightObj rightObj2 = (RightObj)rightObj.clone();
        boolean bl = false;
        boolean bl2 = false;
        if (this.isNew) {
            if (this.isGenVisited) {
                if (this.rightGenProps.isRightNameSyntaxOK() && this.rightGenProps.isRightDescSyntaxOK() && this.rightGenProps.isHelpNameSyntaxOK()) {
                    rightObj2 = this.rightGenProps.updateRightGenProps(rightObj2);
                } else {
                    return false;
                }
            }
            if (this.isCmdVisited) {
                rightObj2 = this.rightCmdProps.updateRightCmdProps(rightObj2);
            }
            if (this.isAuthVisited) {
                rightObj2 = this.rightAuthProps.updateRightAuthProps(rightObj2);
            }
            if (this.isSubVisited) {
                rightObj2 = this.rightSubProps.updateRightSubProps(rightObj2);
            }
            try {
                serviceWrapper.addRight(rightObj2);
                Content content = this.theApp.getTree().getCurrentContent();
                if (content instanceof RightContent) {
                    Vector<RightObj> vector = new Vector<RightObj>();
                    vector.addElement(rightObj2);
                    ((RightContent)content).appendToResultsPane(vector);
                }
            }
            catch (Exception exception) {
                new ErrorDialog(this.theApp.getFrame(), exception.getLocalizedMessage());
                return false;
            }
            return true;
        }
        if (this.isGenVisited) {
            if (this.rightGenProps.isRightDescSyntaxOK() && this.rightGenProps.isHelpNameSyntaxOK()) {
                bl = true;
                rightObj2 = this.rightGenProps.updateRightGenProps(rightObj2);
            } else {
                return false;
            }
        }
        if (this.isAuthVisited) {
            bl = true;
            rightObj2 = this.rightAuthProps.updateRightAuthProps(rightObj2);
        }
        if (this.isSubVisited) {
            bl = true;
            rightObj2 = this.rightSubProps.updateRightSubProps(rightObj2);
        }
        if (this.isCmdVisited) {
            bl2 = true;
            rightObj2 = this.rightCmdProps.updateRightCmdProps(rightObj2);
        }
        if (bl) {
            try {
                serviceWrapper.modifyRight(rightObj2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (bl2) {
            try {
                serviceWrapper.modifyRightEntries(rightObj2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void setupRightTabs(RightObj rightObj) {
        this.rightGenProps = new RightGenProps(this.theApp, rightObj, this.infoPanel, this.isNew, this.rightTabs);
        this.rightTabs.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_tabs_general"), null, this.rightGenProps);
        if (this.theApp.getUserMgr().hasProfMgrExecAttrWriteAuth()) {
            this.rightCmdProps = new RightCmdProps(this.theApp, rightObj, this.infoPanel, this.isNew);
            this.rightTabs.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_tabs_commands"), null, this.rightCmdProps);
        }
        this.rightAuthProps = new RightAuthProps(this.theApp, rightObj, this.infoPanel, this.isNew);
        this.rightTabs.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_tabs_authorizations"), null, this.rightAuthProps);
        this.rightSubProps = new RightSubProps(this.theApp, rightObj, this.infoPanel, this.isNew);
        this.rightTabs.addTab(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"right_tabs_supplementary"), null, this.rightSubProps);
    }

    class RightTabsListener
    implements ChangeListener {
        RightTabsListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            FocusListener focusListener;
            try {
                if (RightTabs.this.rightTabs.getSelectedComponent() == RightTabs.this.rightGenProps) {
                    RightTabs.this.rightGenProps.requestFocus();
                    RightTabs.this.isGenVisited = true;
                } else if (RightTabs.this.rightTabs.getSelectedComponent() == RightTabs.this.rightCmdProps) {
                    RightTabs.this.rightCmdProps.requestFocus();
                    RightTabs.this.isCmdVisited = true;
                } else if (RightTabs.this.rightTabs.getSelectedComponent() == RightTabs.this.rightAuthProps) {
                    RightTabs.this.rightAuthProps.requestFocus();
                    RightTabs.this.isAuthVisited = true;
                } else if (RightTabs.this.rightTabs.getSelectedComponent() == RightTabs.this.rightSubProps) {
                    RightTabs.this.rightSubProps.requestFocus();
                    RightTabs.this.isSubVisited = true;
                }
            }
            catch (Exception exception) {
                RightTabs.this.theApp.reportErrorException(exception);
            }
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            UMgrPropsPanel uMgrPropsPanel = (UMgrPropsPanel)jTabbedPane.getSelectedComponent();
            if (uMgrPropsPanel != null && (focusListener = uMgrPropsPanel.getFocusListener()) != null) {
                focusListener.focusGained(new FocusEvent(jTabbedPane, 1004));
            }
        }
    }

    class TabPaneFocusListener
    implements FocusListener {
        RightTabsListener cl;

        public TabPaneFocusListener(RightTabsListener rightTabsListener) {
            this.cl = rightTabsListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.cl.stateChanged(new ChangeEvent(focusEvent.getComponent()));
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

