/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.XmlInstance;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;

public class CIMNameSpace
implements Serializable {
    static final long serialVersionUID = 200L;
    private String host = ".";
    private String nameSpace = "\\root\\cimv2";
    private URL hostURL = null;

    public CIMNameSpace() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.host = "localhost";
        }
    }

    public CIMNameSpace(String string) {
        try {
            this.hostURL = new URL(string);
            this.host = this.hostURL.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            if (string.indexOf(47) >= 0 || string.indexOf(92) >= 0) {
                throw new IllegalArgumentException(string);
            }
            this.host = string;
        }
    }

    public CIMNameSpace(String string, String string2) {
        this(string);
        this.nameSpace = this.validateNameSpace(string2);
    }

    public String getHost() {
        return this.host;
    }

    public URL getHostURL() {
        return this.hostURL;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void parse(String string) {
        int n = 0;
        String string2 = string.replace('/', '\\');
        if (string2.startsWith("\\\\")) {
            n = string2.indexOf("\\", 3);
            this.host = string2.substring(2, n);
        }
        if (string2.charAt(n) == '\\') {
            ++n;
        }
        this.nameSpace = string2.substring(n, string2.lastIndexOf("\\"));
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setNameSpace(String string) {
        this.nameSpace = this.validateNameSpace(string);
    }

    public String toString() {
        return "\\\\" + this.host + "\\" + this.nameSpace;
    }

    public String toXml() {
        XmlInstance xmlInstance = new XmlInstance();
        return xmlInstance.toXml(this);
    }

    private String validateNameSpace(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "";
        }
        boolean bl = false;
        string = string.replace('/', '\\');
        string = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            stringBuffer.append((char)n);
            if (n == 92) {
                try {
                    while (string.charAt(n3 + 1) == '\\') {
                        ++n3;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n3;
        }
        string = stringBuffer.toString();
        n = string.length();
        if (n > 1 && string.endsWith("\\")) {
            --n;
        }
        return string.substring(0, n).toLowerCase();
    }
}

