/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.ui.ALIGNMENT;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalButtonLayout
implements LayoutManager {
    ALIGNMENT align;
    int hgap;
    int vgap;

    public VerticalButtonLayout() {
        this(ALIGNMENT.CENTER, 5, 5);
    }

    public VerticalButtonLayout(ALIGNMENT aLIGNMENT) {
        this(aLIGNMENT, 5, 5);
    }

    public VerticalButtonLayout(ALIGNMENT aLIGNMENT, int n, int n2) {
        this.align = aLIGNMENT;
        this.hgap = n;
        this.vgap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Serializable serializable;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.height - (insets.top + insets.bottom + this.vgap * 2);
        int n2 = dimension.width - insets.left - insets.right;
        int n3 = container.getComponentCount();
        Dimension dimension2 = new Dimension(0, 0);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            Component component = container.getComponent(n5);
            if (component.isVisible()) {
                serializable = component.getMinimumSize();
                dimension2.height = Math.max(dimension2.height, ((Dimension)serializable).height);
                dimension2.width = Math.max(dimension2.width, ((Dimension)serializable).width);
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            serializable = container.getComponent(n6);
            if (((Component)serializable).isVisible()) {
                ((Component)serializable).setSize(dimension2.width, dimension2.height);
                n4 += dimension2.height;
            }
            ++n6;
        }
        this.moveComponents(container, insets.left, 0, n2, n - n4);
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (serializable.isVisible()) {
                Dimension dimension2 = serializable.getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width = Math.max(dimension.width, dimension2.width);
            }
            ++n2;
        }
        dimension.height = dimension.height * n + (this.vgap * n - 1);
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4) {
        if (this.align != ALIGNMENT.LEFT) {
            if (this.align == ALIGNMENT.CENTER) {
                n2 += n4 / 2;
            } else if (this.align == ALIGNMENT.RIGHT) {
                n2 += n4;
            }
        }
        int n5 = 0;
        while (n5 < container.getComponentCount()) {
            Component component = container.getComponent(n5);
            if (component.isVisible()) {
                Dimension dimension = component.getSize();
                component.setLocation(n + (n3 - dimension.width) / 2, n2);
                n2 += this.vgap + dimension.height;
            }
            ++n5;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (serializable.isVisible()) {
                Dimension dimension2 = serializable.getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width = Math.max(dimension.width, dimension2.width);
            }
            ++n2;
        }
        dimension.height = dimension.height * n + (this.vgap * n - 1);
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }

    public String toString() {
        String string = "";
        if (this.align == ALIGNMENT.LEFT) {
            string = ",align=left";
        } else if (this.align == ALIGNMENT.RIGHT) {
            string = ",align=right";
        } else if (this.align == ALIGNMENT.CENTER) {
            string = ",align=center";
        }
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

