/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.diskmgr.client.AppContent;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.ContentEvent;
import com.sun.admin.diskmgr.client.ContentListener;
import com.sun.admin.diskmgr.client.DiskActionsListener;
import com.sun.admin.diskmgr.client.NavigationSelectionListener;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class DiskMenuBar
extends JMenuBar {
    private VDiskMgr theApp;
    private ResourceBundle bundle;
    private JMenuPlus actionMenu;
    private JMenuItem miPopupOpen;
    private JMenuItem miCreateFdisk;
    private JMenuItem miPopupCreateFdisk;
    private JMenuItem miChangeFdisk;
    private JMenuItem miPopupChangeFdisk;
    private JMenuItem miFormat;
    private JMenuItem miPopupFormat;
    private JMenuItem miClone;
    private JMenuItem miPopupClone;
    private JMenuItem miPopupProperties;
    private JMenuPlus popupMenu;
    private JMenuPlus helpMenu;
    private JMenuItem miAbout;
    private ContentListener contentListener;
    private Content content = null;
    private boolean bX86 = false;

    public DiskMenuBar(VDiskMgr vDiskMgr) {
        this.theApp = vDiskMgr;
        this.bundle = vDiskMgr.getResourceBundle();
        this.bX86 = vDiskMgr.isX86();
    }

    private void buildMenu() {
        DiskActionsListener diskActionsListener;
        this.removeAll();
        DiskActionsListener diskActionsListener2 = diskActionsListener = new DiskActionsListener(this.theApp);
        ActionString actionString = new ActionString(this.bundle, "ActionMenu");
        this.actionMenu = new JMenuPlus(actionString.getString());
        this.actionMenu.setMnemonic(actionString.getMnemonic());
        this.actionMenu.setActionCommand("VMenuID.ACTION");
        if (this.bX86) {
            actionString = new ActionString(this.bundle, "ActionCreateFdisk");
            this.miCreateFdisk = new JMenuItem(actionString.getString());
            this.actionMenu.add(this.miCreateFdisk);
            this.miCreateFdisk.setMnemonic(actionString.getMnemonic());
            this.miCreateFdisk.setActionCommand("CreateFdisk");
            this.miCreateFdisk.addActionListener(diskActionsListener);
            this.miCreateFdisk.setEnabled(false);
            actionString = new ActionString(this.bundle, "ActionChangeFdisk");
            this.miChangeFdisk = new JMenuItem(actionString.getString());
            this.actionMenu.add(this.miChangeFdisk);
            this.miChangeFdisk.setMnemonic(actionString.getMnemonic());
            this.miChangeFdisk.setActionCommand("ChangeFdisk");
            this.miChangeFdisk.addActionListener(diskActionsListener);
            this.miChangeFdisk.setEnabled(false);
        }
        actionString = new ActionString(this.bundle, "ActionFormat");
        this.miFormat = new JMenuItem(actionString.getString());
        this.actionMenu.add(this.miFormat);
        this.miFormat.setMnemonic(actionString.getMnemonic());
        this.miFormat.setActionCommand("Format");
        this.miFormat.addActionListener(diskActionsListener);
        this.miFormat.setEnabled(false);
        actionString = new ActionString(this.bundle, "ActionClone");
        this.miClone = new JMenuItem(actionString.getString());
        this.actionMenu.add(this.miClone);
        this.miClone.setMnemonic(actionString.getMnemonic());
        this.miClone.setActionCommand("Clone");
        this.miClone.addActionListener(diskActionsListener);
        this.miClone.setEnabled(false);
        this.add((JMenu)this.actionMenu);
        actionString = new ActionString(this.bundle, "HelpMenu");
        this.helpMenu = new JMenuPlus(actionString.getString());
        this.helpMenu.setMnemonic(actionString.getMnemonic());
        this.helpMenu.setActionCommand("VMenuID.HELP");
        actionString = new ActionString(this.bundle, "HelpAbout");
        this.miAbout = new JMenuItem(actionString.getString());
        this.helpMenu.add(this.miAbout);
        this.miAbout.setMnemonic(actionString.getMnemonic());
        this.miAbout.setActionCommand("About");
        this.miAbout.addActionListener(diskActionsListener);
        this.miAbout.setEnabled(true);
        this.add((JMenu)this.helpMenu);
        actionString = new ActionString(this.bundle, "ActionMenu");
        this.popupMenu = new JMenuPlus(actionString.getString());
        this.popupMenu.setMnemonic(actionString.getMnemonic());
        actionString = new ActionString(this.bundle, "ActionOpen");
        this.miPopupOpen = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupOpen);
        this.miPopupOpen.setMnemonic(actionString.getMnemonic());
        this.miPopupOpen.setActionCommand("Open");
        this.miPopupOpen.addActionListener(diskActionsListener);
        this.popupMenu.add(new JSeparator());
        if (this.bX86) {
            actionString = new ActionString(this.bundle, "ActionCreateFdisk");
            this.miPopupCreateFdisk = new JMenuItem(actionString.getString());
            this.popupMenu.add(this.miPopupCreateFdisk);
            this.miPopupCreateFdisk.setMnemonic(actionString.getMnemonic());
            this.miPopupCreateFdisk.setActionCommand("CreateFdisk");
            this.miPopupCreateFdisk.addActionListener(diskActionsListener);
            this.miPopupCreateFdisk.setEnabled(false);
            actionString = new ActionString(this.bundle, "ActionChangeFdisk");
            this.miPopupChangeFdisk = new JMenuItem(actionString.getString());
            this.popupMenu.add(this.miPopupChangeFdisk);
            this.miPopupChangeFdisk.setMnemonic(actionString.getMnemonic());
            this.miPopupChangeFdisk.setActionCommand("ChangeFdisk");
            this.miPopupChangeFdisk.addActionListener(diskActionsListener);
            this.miPopupChangeFdisk.setEnabled(false);
            this.popupMenu.add(new JSeparator());
        }
        actionString = new ActionString(this.bundle, "ActionFormat");
        this.miPopupFormat = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupFormat);
        this.miPopupFormat.setMnemonic(actionString.getMnemonic());
        this.miPopupFormat.setActionCommand("Format");
        this.miPopupFormat.addActionListener(diskActionsListener);
        this.miPopupFormat.setEnabled(false);
        actionString = new ActionString(this.bundle, "ActionClone");
        this.miPopupClone = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupClone);
        this.miPopupClone.setMnemonic(actionString.getMnemonic());
        this.miPopupClone.setActionCommand("Clone");
        this.miPopupClone.addActionListener(diskActionsListener);
        this.miPopupClone.setEnabled(false);
        this.popupMenu.add(new JSeparator());
        actionString = new ActionString(this.bundle, "ActionProperties");
        this.miPopupProperties = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupProperties);
        this.miPopupProperties.setMnemonic(actionString.getMnemonic());
        this.miPopupProperties.setActionCommand("Properties");
        this.miPopupProperties.addActionListener(diskActionsListener);
        this.miPopupProperties.setEnabled(false);
        this.setMinimumSize(this.getPreferredSize());
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                DiskMenuBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        this.theApp.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (DiskMenuBar.this.content != null) {
                    DiskMenuBar.this.content.removeContentListener(DiskMenuBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskMenuBar.this.content = treeNodeData.getContent();
                DiskMenuBar.this.content.addContentListener(DiskMenuBar.this.contentListener);
                DiskMenuBar.this.configureForContent();
                DiskMenuBar.this.notifySelectionChange(DiskMenuBar.this.content.getNumSelections());
            }
        });
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.theApp.getDisplayModel().getSelectedNavigationNode());
        this.theApp.fireNavigationSelection(vConsoleEvent);
    }

    private void configureForContent() {
        boolean bl = this.theApp.getDiskMgr().hasWriteAuthorization();
        if (this.theApp.isX86()) {
            this.miCreateFdisk.setEnabled(bl);
            this.miPopupCreateFdisk.setEnabled(bl);
            this.miChangeFdisk.setEnabled(bl);
            this.miPopupChangeFdisk.setEnabled(bl);
        }
        this.miPopupOpen.setEnabled(true);
        this.miPopupProperties.setEnabled(true);
        this.miFormat.setEnabled(bl);
        this.miPopupFormat.setEnabled(bl);
        this.miClone.setEnabled(bl);
        this.miPopupClone.setEnabled(bl);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu.getPopupMenu();
    }

    private void notifySelectionChange(int n) {
        Content content;
        boolean bl = this.theApp.getDiskMgr().hasWriteAuthorization();
        VScopeNode vScopeNode = this.theApp.getTree().getCurrentContent().getSelectedNode();
        if (vScopeNode != null && (content = this.theApp.getTree().getCurrentContent()) instanceof AppContent) {
            TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
            DiskData diskData = treeNodeData.getDiskData();
            boolean bl2 = diskData.hasSolarisPartitions();
            this.miPopupOpen.setEnabled(bl2);
            boolean bl3 = bl && bl2;
            this.miFormat.setEnabled(bl3);
            this.miPopupFormat.setEnabled(bl3);
            Vector vector = this.theApp.getDiskMgr().getCompatibleDisks(diskData);
            boolean bl4 = vector != null && vector.size() > 0;
            boolean bl5 = bl && bl4 && bl2;
            this.miClone.setEnabled(bl5);
            this.miPopupClone.setEnabled(bl5);
            this.miPopupProperties.setEnabled(n == 1 && bl2);
            if (this.bX86) {
                this.miCreateFdisk.setEnabled(bl && bl2);
                this.miPopupCreateFdisk.setEnabled(bl && bl2);
                boolean bl6 = bl && bl2 && diskData.getVPartitions() != null && diskData.getVPartitions().size() > 1;
                this.miChangeFdisk.setEnabled(bl6);
                this.miPopupChangeFdisk.setEnabled(bl6);
            }
        }
    }

    public void setX86(boolean bl) {
        this.bX86 = bl;
        this.buildMenu();
    }
}

