/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.client.WBEMClient.ClientProxyException;
import com.sun.admin.usermgr.client.WBEMClient.ServerConnectException;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMTransportException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMClient;

public class MBoxProxy
implements WbemClientProxy {
    private static final String MBOX_CLASS = "Solaris_MailBox";
    private static String USER_NAME = "userName";
    private static String USER_UID = "userUID";
    private static String MAIL_SERVER = "mailServer";
    private static String MBOX_ALLOW_MOD = "mailBoxAllowModifyServer";
    private static String MBOX_FRC_MOD = "mailBoxForceModify";
    private static String NEW_USER_NAME = "newUserName";
    private CIMClient cimClient = null;
    private CIMClass cimClass = null;

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj) {
        CIMInstance cIMInstance = this.convertUserObjToInstance(cIMClass, userObj, null);
        return cIMInstance;
    }

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj, String string) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        if (string != null) {
            cIMInstance.setProperty(USER_NAME, new CIMValue((Object)string));
            if (userObj.getUserName() != null) {
                CIMValue cIMValue = new CIMValue((Object)userObj.getUserName());
                cIMInstance.setProperty(NEW_USER_NAME, cIMValue);
            }
        } else if (userObj.getUserName() != null) {
            cIMInstance.setProperty(USER_NAME, new CIMValue((Object)userObj.getUserName()));
        }
        if (userObj.getUserID() != null) {
            cIMInstance.setProperty(USER_UID, new CIMValue((Object)userObj.getUserID()));
        }
        if (userObj.getSolServicesAttr() != null) {
            if (userObj.getSolServicesAttr().getMailServer() != null) {
                cIMInstance.setProperty(MAIL_SERVER, new CIMValue((Object)userObj.getSolServicesAttr().getMailServer()));
            }
            cIMInstance.setProperty(MBOX_ALLOW_MOD, new CIMValue((Object)new Boolean(userObj.getSolServicesAttr().getModifyMailServer())));
            cIMInstance.setProperty(MBOX_FRC_MOD, new CIMValue((Object)new Boolean(userObj.getSolServicesAttr().requireModify())));
        }
        return cIMInstance;
    }

    public void createMBox(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(MBOX_CLASS);
        if (userObj.getUserName() == null) {
            throw new ClientProxyException("EXM_MBOX_ADD_BAD_NAME");
        }
        if (userObj.getUserName().trim().length() == 0) {
            throw new ClientProxyException("EXM_MBOX_ADD_BAD_NAME");
        }
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false);
            }
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj);
            this.cimClient.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_MBOX_SCTY_ADD", userObj.getUserName());
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
            solServicesAttr.setModifyMailServer(true);
            throw new ServerConnectException("EXM_MBOX_ADD_CONTACT_ERR", userObj.getUserName(), solServicesAttr.getMailServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_MBOX_ADD_UNEXP", userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_MBOX_ADD_UNEXP", userObj.getUserName(), exception.getMessage());
        }
    }

    public void deleteMBox(String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(MBOX_CLASS);
        if (string == null || string.trim().length() == 0) {
            throw new ClientProxyException("EXM_MBOX_DEL_BAD_NAME");
        }
        cIMObjectPath.addKey(USER_NAME, new CIMValue((Object)string));
        try {
            this.cimClient.deleteInstance(cIMObjectPath);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_MBOX_SCTY_DEL", string);
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_MBOX_DEL_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_MBOX_DEL_UNEXP", string, exception.getMessage());
        }
    }

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) throws AdminException {
        this.cimClient = cIMClient;
    }

    public void modifyMBox(UserObj userObj, String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(MBOX_CLASS);
        if (string == null) {
            throw new ClientProxyException("EXM_MBOX_MOD_BAD_NAME");
        }
        if (string.trim().length() == 0) {
            throw new ClientProxyException("EXM_MBOX_MOD_BAD_NAME");
        }
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false);
            }
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj, string);
            cIMObjectPath.addKey(USER_NAME, new CIMValue((Object)string));
            this.cimClient.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_DEL");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
            solServicesAttr.setModifyMailServer(true);
            throw new ServerConnectException("EXM_MBOX_MOD_CONTACT_ERR", userObj.getUserName(), solServicesAttr.getMailServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_MBOX_MOD_UNEXP", userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_MBOX_MOD_UNEXP", userObj.getUserName(), exception.getMessage());
        }
    }

    public void printInst(CIMInstance cIMInstance) {
        System.out.println("CIMInstance = " + cIMInstance.toString());
    }
}

