/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.bridge.NoEntryException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.Network;

public class DeleteClientEntry
extends PntAdmFunction {
    static final int[] supportedOptions = new int[]{121, 114, 117, 112};
    String clientIP;

    public DeleteClientEntry(String string) {
        this.clientIP = string;
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        int n = 0;
        boolean bl = this.options.isSet(121);
        if (bl && !this.isHostsManaged()) {
            bl = false;
            n = 3;
        }
        try {
            DhcpClientRecord dhcpClientRecord = new DhcpClientRecord(this.clientIP);
            Network network = DhcpCliFunction.getNetMgr().getNetwork(this.networkName);
            if (this.networkName == null) {
                this.printErrMessage(this.getString("network_name_error"));
                return 3;
            }
            DhcpCliFunction.getNetMgr().deleteClient(dhcpClientRecord, network.toString(), bl, this.getDhcpDatastore());
        }
        catch (NoEntryException noEntryException) {
            this.printErrMessage(DhcpCliFunction.getMessage(noEntryException));
            n = 2;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            n = 3;
        }
        return n;
    }
}

