/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.Util;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.Network;

public class AddClientEntry
extends PntAdmFunction {
    static final int[] supportedOptions = new int[]{99, 101, 102, 104, 105, 97, 109, 121, 115, 114, 117, 112};
    String clientIP;

    public AddClientEntry(String string) {
        this.clientIP = string;
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        int n = 0;
        try {
            Network network;
            Object object;
            String string;
            String string2;
            String string3;
            DhcpClientRecord dhcpClientRecord = new DhcpClientRecord(this.clientIP);
            String string4 = this.options.valueOf(105);
            boolean bl = this.options.isSet(97);
            if (bl) {
                if (string4 == null) {
                    String string5 = this.getString("no_clientid_specified");
                    throw new IllegalArgumentException(string5);
                }
                string4 = Util.asciiToHex(string4);
            }
            if (string4 != null) {
                dhcpClientRecord.setClientId(string4);
            }
            if ((string3 = this.options.valueOf(102)) != null) {
                dhcpClientRecord.setFlags(string3);
            }
            if ((string2 = this.options.valueOf(104)) != null) {
                if (this.isHostsManaged()) {
                    dhcpClientRecord.setClientName(string2);
                } else {
                    n = 3;
                }
            }
            if ((string = this.options.valueOf(115)) == null) {
                string = DhcpCliFunction.getSvcMgr().getServerName();
            }
            dhcpClientRecord.setServerIP(string);
            String string6 = this.options.valueOf(101);
            if (string6 != null) {
                String string7 = this.getString("expiration_format");
                dhcpClientRecord.setExpiration(string7, string6);
            }
            boolean bl2 = this.options.isSet(121);
            String string8 = this.options.valueOf(109);
            if (bl2) {
                if (string8 == null) {
                    String string9 = this.getString("no_macro_specified");
                    throw new IllegalArgumentException(string9);
                }
                try {
                    object = DhcpCliFunction.getDhcptabMgr().getMacro(string8);
                }
                catch (BridgeException bridgeException) {
                    this.printErrMessage(this.getString("macro_not_found"));
                    return 3;
                }
            }
            if (string8 != null) {
                dhcpClientRecord.setMacro(string8);
            }
            if ((object = this.options.valueOf(99)) != null) {
                dhcpClientRecord.setComment((String)object);
            }
            if ((network = DhcpCliFunction.getNetMgr().getNetwork(this.networkName)) == null) {
                this.printErrMessage(this.getString("network_name_error"));
                return 3;
            }
            DhcpCliFunction.getNetMgr().addClient(dhcpClientRecord, network.toString(), this.getDhcpDatastore());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (ExistsException existsException) {
            this.printErrMessage(DhcpCliFunction.getMessage(existsException));
            n = 1;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            n = 3;
        }
        return n;
    }
}

