/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;

public class TitleBox
extends Panel {
    private Insets insets = new Insets(7, 7, 7, 7);
    public static final Insets MINIMUM_INSETS = new Insets(10, 10, 10, 10);
    private String title = null;

    public TitleBox() {
        this.setLayout(new GridBagLayout());
    }

    public TitleBox(String string) {
        this();
        this.title = string;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public String getTitle() {
        return this.title;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        Color color3 = color.brighter().brighter();
        Color color4 = color.darker();
        Font font = this.getFont();
        FontMetrics fontMetrics = null;
        if (font != null) {
            fontMetrics = this.getFontMetrics(font);
        }
        int n = 15;
        if (fontMetrics != null) {
            n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        }
        graphics.setColor(color3);
        graphics.drawRect(this.insets.left + 1, n / 2 + 1, dimension.width - this.insets.left - this.insets.right, dimension.height - this.insets.bottom - n / 2);
        graphics.setColor(color4);
        graphics.drawRect(this.insets.left, n / 2, dimension.width - this.insets.left - this.insets.right, dimension.height - this.insets.bottom - n / 2);
        if (this.title != null) {
            graphics.clearRect(this.insets.left + fontMetrics.stringWidth("-"), n / 2, fontMetrics.stringWidth(this.title) + 4, 2);
            graphics.setColor(color3);
            graphics.drawString(this.title, this.insets.left + fontMetrics.stringWidth("-") + 2 + 1, n / 2 + fontMetrics.getHeight() / 2 - 1 + 1);
            graphics.setColor(color2.brighter());
            graphics.drawString(this.title, this.insets.left + fontMetrics.stringWidth("-") + 2, n / 2 + fontMetrics.getHeight() / 2 - 1);
        }
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

