/*
 * Copyright (c) 1990, 2013, Oracle and/or its affiliates. All rights reserved.
 */

#ifndef _SYS_HWCONF_H
#define	_SYS_HWCONF_H

#pragma ident	"@(#)hwconf.h	1.17	13/03/22 SMI"

#include <sys/dditypes.h>
#include <sys/ddipropdefs.h>
#include <sys/rwlock.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define	MAX_HWC_LINESIZE 1024

struct hwc_class {
	struct hwc_class *class_next;
	char *class_exporter;
	char *class_name;
};

struct hwc_spec {
	struct hwc_spec *hwc_next;
	char		*hwc_parent_name;
	char		*hwc_class_name;
	char		*hwc_devi_name;
	ddi_prop_t	*hwc_devi_sys_prop_ptr;
	/* For hashing */
	struct hwc_spec	*hwc_hash_next;
	major_t		hwc_major;
};

/*
 * used to create sorted linked lists of hwc_spec structs for loading parents
 */
struct par_list {
	struct par_list	*par_next;
	struct hwc_spec	*par_specs;		/* List of prototype nodes */
	major_t		par_major;		/* Simple name of parent */
};

struct bind {
	struct bind 	*b_next;
	char		*b_name;
	char		*b_bind_name;
	int		b_num;
};

#ifdef _KERNEL

#define	MOD_BIND_HASHSIZE	64
#define	MOD_BIND_HASHMASK	(MOD_BIND_HASHSIZE-1)

struct binding {
	krwlock_t b_lock;
	struct bind *b_hashtab[MOD_BIND_HASHSIZE];
};

#endif /* _KERNEL */

typedef struct mperm {
	struct mperm	*mp_next;
	char		*mp_minorname;
	mode_t		mp_mode;
	uid_t		mp_uid;
	gid_t		mp_gid;
#ifndef _KERNEL
	char		*mp_drvname;
	char		*mp_owner;
	char		*mp_group;
#endif	/* !_KERNEL */
} mperm_t;

#ifdef _KERNEL

extern struct binding mb_hash;
extern struct binding sb_hash;

extern int hwc_parse(char *, struct par_list **, ddi_prop_t **);
extern struct par_list *impl_make_parlist(major_t);
extern int impl_free_parlist(major_t);
extern void impl_delete_par_list(struct par_list *);
extern int impl_parlist_to_major(struct par_list *, char []);
extern struct hwc_spec *hwc_get_child_spec(dev_info_t *, major_t);
extern void hwc_free_spec_list(struct hwc_spec *);

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_HWCONF_H */
