#!/bin/sh

OPT=$1

HOME=%%console_home%%
CONF=%%console_conf%%/%%console_instance%%
BASE=%%console_dombase%%/%%console_instance%%
LOGD=%%console_log%%/%%console_instance%%
NATV=%%console_native%%

CAT_HOME=%%container_home%%
CAT_BASE=${BASE}
CAT_CONF=${BASE}/conf

JAVA_HOME=%%java_home%%

COMM_LOG="%%container_commons_log%%"

PID_FILE=%%console_base%%/tmp/%%console_instance%%_pid.tmp
LOG_FILE=${LOGD}/console_debug_log
VERS_FILE=${HOME}/version.txt
DATE=`date`
VERS=""
if [ -f ${VERS_FILE} ]; then
    VERS="Version `cat ${VERS_FILE}`"
fi

# If force stop, kill the underlying process
if [ "${OPT}" = "--kill" ]; then
    STAT=0
    if [ -f ${PID_FILE} ]; then
	PID=`cat ${PID_FILE}`
        if [ -n "`/bin/ps -deaf | awk '{print $2}' | grep ${PID}`" ]; then
	    kill -9 ${PID} >> ${LOG_FILE} 2>&1
	    STAT=$?
	    if [ $STAT -eq 0 ]; then
		echo "Java Web Console ${VERS} process killed on ${DATE}" >> ${LOG_FILE}
	    else
		echo "Error ${STAT} killing process ${PID}." >> ${LOG_FILE}
		STAT=1
	    fi
	else
	    echo "Error killing process ${PID}, process does not exist." >> ${LOG_FILE}
	    STAT=1
        fi
        rm -f ${PID_FILE} > /dev/null 2>&1
    else
	echo "No process id file exists, cannot kill process." >> ${LOG_FILE}
    fi
    exit $STAT
fi

echo "==============================================================" >> ${LOG_FILE}
echo "Java Web Console ${VERS} stopping on ${DATE}" >> ${LOG_FILE}
echo "==============================================================" >> ${LOG_FILE}

CP="${CAT_HOME}/bin/bootstrap.jar:${CAT_HOME}/bin/commons-logging.jar:${CAT_HOME}/bin/log4j.jar"
if [ -f "${JAVA_HOME}/lib/tools.jar" ]; then
    CP=${CP}:"${JAVA_HOME}/lib/tools.jar"
fi
if [ -f "${JAVA_HOME}/jre/lib/jsse.jar" ]; then
    CP=${CP}:"${JAVA_HOME}/jre/lib/jsse.jar"
fi

${JAVA_HOME}/bin/java \
    -classpath ${CP} \
    -Djava.library.path=${NATV} \
    -Dcatalina.home=${CAT_HOME} \
    -Dcatalina.base=${CAT_BASE} \
    -Dorg.apache.commons.logging.Log=${COMM_LOG} \
    org.apache.catalina.startup.Bootstrap stop >> ${LOG_FILE} 2>&1
STAT=$?

exit ${STAT}
