#!/bin/sh

HOME=%%console_home%%
CONF=%%console_conf%%/%%console_instance%%
BASE=%%console_dombase%%/%%console_instance%%
LOGD=%%console_log%%/%%console_instance%%
NATV=%%console_native%%

CAT_HOME=%%container_home%%
CAT_BASE=${BASE}
CAT_CONF=${BASE}/conf

JAVA_HOME=%%java_home%%
JAVA_OPTS="%%java_options%%"

COMM_LOG="%%container_commons_log%%"

PID_FILE=%%console_base%%/tmp/%%console_instance%%_pid.tmp
LOG_FILE=${LOGD}/console_debug_log
VERS_FILE=${HOME}/version.txt
DATE=`date`
VERS=""
if [ -f ${VERS_FILE} ]; then
    VERS="Version `cat ${VERS_FILE}`"
fi
echo "==============================================================" >> ${LOG_FILE}
echo "Java Web Console ${VERS} started on ${DATE}" >> ${LOG_FILE}
echo "==============================================================" >> ${LOG_FILE}

START_FILE=%%console_base%%/tmp/%%console_instance%%_start.tmp
if [ -f ${START_FILE} ]; then
    rm -f ${START_FILE}
fi

LD_LIBRARY_PATH="${NATV}"
export LD_LIBRARY_PATH

CP="${CAT_HOME}/bin/bootstrap.jar:${CAT_HOME}/bin/commons-logging.jar:${CAT_HOME}/bin/log4j.jar"
if [ -f "${JAVA_HOME}/lib/tools.jar" ]; then
    CP=${CP}:"${JAVA_HOME}/lib/tools.jar"
fi
if [ -f "${JAVA_HOME}/jre/lib/jsse.jar" ]; then
    CP=${CP}:"${JAVA_HOME}/jre/lib/jsse.jar"
fi

${JAVA_HOME}/bin/java ${JAVA_OPTS} \
    -classpath ${CP} \
    -Djava.security.manager \
    -Djava.security.policy==${CAT_CONF}/console.policy \
    -Djavax.net.ssl.trustStore=${CAT_CONF}/keystore.jks \
    -Djava.security.auth.login.config=${CAT_CONF}/consolelogin.conf \
    -Dcatalina.home=${CAT_HOME} \
    -Dcatalina.base=${CAT_BASE} \
    -Dcom.sun.web.console.home=${HOME} \
    -Dcom.sun.web.console.conf=${CONF} \
    -Dcom.sun.web.console.base=${BASE} \
    -Dcom.sun.web.console.logdir=${LOGD} \
    -Dcom.sun.web.console.native=${NATV} \
    -Dcom.sun.web.console.appbase=${BASE}/webapps \
    -Dcom.sun.web.console.secureport=%%console_httpsport%% \
    -Dcom.sun.web.console.unsecureport=%%console_httpport%% \
    -Dcom.sun.web.console.unsecurehost=%%console_unsecurehost%% \
    -Dwebconsole.default.file=${CONF}/default.properties \
    -Dwebconsole.config.file=${CONF}/service.properties \
    -Dcom.sun.web.console.startfile=${START_FILE} \
    -Djava.awt.headless=true \
    -Dorg.apache.commons.logging.Log=${COMM_LOG} \
    org.apache.catalina.startup.Bootstrap start \
    >> ${LOG_FILE} 2>&1 &

PID=$!
if [ -f $PID_FILE ]; then
    rm -f ${PID_FILE} > /dev/null 2>&1
fi
echo "${PID}" > ${PID_FILE}

exit $?
