/*
 * Copyright (c) 1998 by Sun Microsystems, Inc.
 */
#ifndef _DtTooltipDisplay_h
#define _DtTooltipDisplay_h

#include <Xm/Xm.h>
#include <Xm/DragIcon.h>

#ifndef DTWIDGET_WARNING_DISABLED
#error The DtWidget interfaces may no longer be supported in a future release of Solaris.  You may want to migrate to the GTK+ toolkit.  To disable the warning message, use #define DTWIDGET_WARNING_DISABLED within source files or -DDTWIDGET_WARNING_DISABLED at compile time.
#endif /* DTWIDGET_WARNING_DISABLED */

#ifdef __cplusplus
extern "C" {
#endif

externalref WidgetClass dtTooltipDisplayWidgetClass;

typedef struct _DtTooltipDisplayClassRec*	DtTooltipDisplayWidgetClass;
typedef struct _DtTooltipDisplayRec*		DtTooltipDisplayWidget;

#ifndef DtIsTooltipDisplay
#define DtIsTooltipDisplay(w)	(XtIsSubClass (w, dtTooltipDisplayWidgetClass))
#endif


/* Tooltip display resource strings */
#define DtNtooltipForeground		"tooltipForeground"
#define DtCTooltipForeground		"TooltipForeground"

#define DtNtooltipBackground		"tooltipBackground"
#define DtCTooltipBackground		"TooltipBackground"

#define	DtNpopupFirstDelay		"popupFirstDelay"
#define	DtCPopupFirstDelay		"PopupFirstDelay"

#define	DtNpopupTransitionDelay		"popupTransitionDelay"
#define	DtCPopupTransitionDelay		"PopupTransitionDelay"

#define	DtNpopupTransitionInterval	"popupTransitionInterval"
#define	DtCPopupTransitionInterval	"PopupTransitionInterval"

#define	DtNpopdownDelay			"popdownDelay"
#define	DtCPopdownDelay			"PopdownDelay"

#define	DtNwindowOffset			"windowOffset"
#define	DtCWindowOffset			"WindowOffset"

#define	DtNtooltipStatusSensitive	"tooltipStatusSensitive"
#define	DtCTooltipStatusSensitive	"TooltipStatusSensitive"


/* Tooltip item resource strings */
#define DtNtooltipLabel			"tooltipLabel"
#define DtCTooltipLabel			"TooltipLabel"

#define DtNtooltipSensitive		"tooltipSensitive"
#define DtCTooltipSensitive		"TooltipSensitive"

#define DtNtooltipPopNotifyCallback	"tooltipPopNotifyCallback"
#define DtCTooltipPopNotifyCallback	"tooltipPopNotifyCallback"

#define DtNtooltipStatusLabel		"tooltipStatusLabel"
#define DtCTooltipStatusLabel		"tooltipStatusLabel"

#define DtNtooltipStatusWidget		"tooltipStatusWidget"
#define DtCTooltipStatusWidget		"tooltipStatusWidget"


/* Tooltip display functions */
extern Widget	DtCreateTooltipDisplay			(Widget, char*, ArgList, Cardinal);
extern void     DtTooltipDisplayPopup			(Widget);
extern void     DtTooltipDisplayPopupAtLocation		(Widget, XRectangle*, String);
extern void     DtTooltipDisplayPopdown			(Widget);


/* Tooltip item functions */
extern void	DtCreateTooltipItem			(Widget, ArgList, Cardinal);
extern void	DtDestroyTooltipItem			(Widget);
extern void	DtTooltipItemSetValues			(Widget, ArgList, Cardinal);
extern void	DtTooltipItemGetValues			(Widget, ArgList, Cardinal);
extern void	DtTooltipItemCreateTooltipDisplay	(Widget);
extern Widget	DtTooltipItemGetTooltipDisplay		(Widget);


#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* _DtTooltipDisplay_h */

