/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_DiskIOPerformanceMonitor
implements InstanceProvider {
    public static final String PROVIDERNAME = "Solaris Disk IO Performance Monitor";
    public static final String CAPTION = "Solaris Disk IO Statistical Information : DeviceID# ";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        cimomHandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        try {
            String[] stringArray = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            String[] stringArray = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray2 = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray2, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (cIMProperty.getName().equalsIgnoreCase("Stats")) {
                    cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                }
                if (!cIMProperty.getName().equalsIgnoreCase("Element")) continue;
                cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
            }
            cIMInstance.setProperty("Stats", new CIMValue(cIMObjectPath3));
            cIMInstance.setProperty("Element", new CIMValue(cIMObjectPath2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath[] cIMObjectPathArray;
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            cIMObjectPathArray = new CIMObjectPath("Solaris_DiskIOInformation", cIMObjectPath.getNameSpace());
            Enumeration enumeration = cimomHandle.enumerateInstanceNames((CIMObjectPath)cIMObjectPathArray);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                    if (cIMObjectPath2 == null) continue;
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                    cIMObjectPath3.addKey("Stats", new CIMValue((Object)cIMObjectPath2));
                    cIMObjectPath3.addKey("Element", new CIMValue((Object)this.buildSolarisDiskDriveRef(cIMObjectPath2)));
                    vector.addElement(cIMObjectPath3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray2 = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray2, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            cIMInstanceArray = new CIMObjectPath("Solaris_DiskIOInformation", cIMObjectPath.getNameSpace());
            Enumeration enumeration = cimomHandle.enumerateInstanceNames((CIMObjectPath)cIMInstanceArray);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                    if (cIMObjectPath2 == null) continue;
                    CIMInstance cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty("Stats", new CIMValue((Object)cIMObjectPath2));
                    cIMInstance.setProperty("Element", new CIMValue((Object)this.buildSolarisDiskDriveRef(cIMObjectPath2)));
                    if (bl) {
                        cIMInstance = cIMInstance.localElements();
                    }
                    vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private String getDeviceName(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        try {
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase("Name")) continue;
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return string;
    }

    private CIMObjectPath buildSolarisDiskDriveRef(CIMObjectPath cIMObjectPath) throws CIMProviderException {
        CIMObjectPath cIMObjectPath2 = null;
        try {
            cIMObjectPath2 = new CIMObjectPath("Solaris_DiskDrive", cIMObjectPath.getNameSpace());
            cIMObjectPath2.addKey("Name", new CIMValue((Object)this.getDeviceName(cIMObjectPath)));
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
            cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cIMObjectPath2;
    }

    protected String writeLog(int n, String string, String[] stringArray, Exception exception) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        try {
            string3 = exception.getLocalizedMessage();
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", string, stringArray, string3, bl, 0, n);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (string != null) {
            string2 = this.logUtil.getLocalizedMessage(string, stringArray);
            string2 = string2 + " " + string3;
        } else {
            string2 = string3;
        }
        return string2;
    }
}

