/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMStripe
implements InstanceProvider,
Authorizable,
PropertyProvider,
MethodProvider,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) throws RemoteException {
        SVM sVM = SVM.instance();
        try {
            Vector vector = sVM.getDevices("Stripe");
            System.out.println("Stripes:");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                System.out.println(device);
                Solaris_VMUtil.printDependents(sVM, device, "ExtentInDiskGroup", "ExtentInDiskGroup:");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "BasedOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "BasedOn:");
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "ExtentRedundancyComponent:");
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.stripeToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Stripe");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMStripe"));
                    String string = null;
                    Long l = (Long)device.getProperty("device key");
                    string = l != null ? l.toString() : (String)device.getProperty("name");
                    cIMObjectPath2.addKey("Name", new CIMValue((Object)string));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Stripe");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device = (Device)vector.get(i);
                    arrayList.add(this.stripeToCI(device, cIMClass, bl, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Vector vector = (Vector)Solaris_VMUtil.getValue(cIMInstance, "StripeComponents");
        if (vector == null || vector.size() < 2) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"StripeComponents");
        }
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        if (string == null) {
            string = Solaris_VMUtil.getMDName(this.slvm, false);
        }
        UnsignedInt64 unsignedInt64 = (UnsignedInt64)Solaris_VMUtil.getValue(cIMInstance, "Interlace");
        String string2 = Solaris_VMUtil.getSliceDiskSet(this.slvm, (String)vector.get(0));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metainit");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add(string);
        arrayList.add("1");
        int n = vector.size();
        arrayList.add(String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            arrayList.add((String)vector.get(i));
        }
        if (unsignedInt64 != null) {
            arrayList.add("-i");
            arrayList.add(unsignedInt64.toString() + "b");
        }
        Solaris_VMUtil.run(arrayList, this.hostName);
        Solaris_VMUtil.flush(this.slvm, string2);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        String string3 = null;
        string3 = string2 != null ? string2 + "/" + string : string;
        Device device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string3, "name", "Stripe");
        Long l = (Long)device.getProperty("device key");
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMStripe"));
        cIMObjectPath2.addKey("Name", new CIMValue((Object)l.toString()));
        return cIMObjectPath2;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        Long l = (Long)device.getProperty("device key");
        if (l == null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"name");
        }
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaclear");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add("-f");
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        Long l = (Long)device.getProperty("device key");
        if (l == null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        Solaris_VMUtil.rename(this.slvm, device, string);
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (string.equalsIgnoreCase("attach")) {
            return this.attach(vector, cIMObjectPath);
        }
        if (string.equalsIgnoreCase("useHSP")) {
            return this.useHSP(vector, cIMObjectPath);
        }
        throw new CIMException("CIM_ERR_FAILED", (Object)string);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, false, false, null);
        CIMInstance cIMInstance = this.stripeToCI(device, cIMClass, false, false, false, null);
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (!string2.equalsIgnoreCase("MetaDevice")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        Long l = (Long)device.getProperty("device key");
        if (l == null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String string3 = (String)cIMValue.getValue();
        Solaris_VMUtil.rename(this.slvm, device, string3);
    }

    private CIMValue attach(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        Long l = (Long)device.getProperty("device key");
        if (l == null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String string = (String)device.getProperty("name");
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Name");
        }
        if (vector.size() != 2) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.get(0);
        Vector vector2 = (Vector)vector.get(1);
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metattach");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        if (unsignedInt32.intValue() != 0) {
            arrayList.add("-i");
            arrayList.add(unsignedInt32.toString() + "b");
        }
        arrayList.add(string);
        for (int i = 0; i < vector2.size(); ++i) {
            arrayList.add((String)vector2.get(i));
        }
        Solaris_VMUtil.run(arrayList, this.hostName);
        return null;
    }

    private CIMValue useHSP(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        Long l = (Long)device.getProperty("device key");
        if (l == null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (vector.size() != 1) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"inParams");
        }
        Solaris_VMUtil.useHSP(vector, device, this.slvm, this.hostName);
        return null;
    }

    private CIMInstance stripeToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) {
        Long l;
        CIMInstance cIMInstance = cIMClass.newInstance();
        String string = (String)device.getProperty("name");
        cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string));
        String string2 = "";
        Device device2 = Solaris_VMUtil.getMyMirror(this.slvm, device);
        if (device2 != null) {
            string2 = Solaris_VMUtil.getSubmirrorState(this.slvm, device, device2);
        } else if (Solaris_VMUtil.isATransLog(device)) {
            string2 = Solaris_VMUtil.getTransLogState(device);
        }
        cIMInstance.setProperty("Status", new CIMValue((Object)string2));
        cIMInstance.setProperty("MountPoint", new CIMValue((Object)((String)device.getProperty("mountpoint"))));
        Long l2 = (Long)device.getProperty("size");
        if (l2 != null) {
            cIMInstance.setProperty("Size", new CIMValue((Object)new UnsignedInt64(l2.toString())));
        }
        if ((l = (Long)device.getProperty("interlace")) != null) {
            cIMInstance.setProperty("Interlace", new CIMValue((Object)new UnsignedInt64(String.valueOf(l))));
        }
        cIMInstance.setProperty("TypeOfAlgorithm", new CIMValue((Object)new UnsignedInt16(0)));
        cIMInstance.setProperty("StorageRedundancy", new CIMValue((Object)new UnsignedInt16(0)));
        cIMInstance.setProperty("IsStriped", new CIMValue((Object)Boolean.TRUE));
        cIMInstance.setProperty("IsConcatenated", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMStripe"));
        String string3 = null;
        Long l3 = (Long)device.getProperty("device key");
        string3 = l3 != null ? l3.toString() : (String)device.getProperty("name");
        cIMInstance.setProperty("Name", new CIMValue((Object)string3));
        cIMInstance.setProperty("RedundancyStatus", new CIMValue((Object)new UnsignedInt16(1)));
        Date date = (Date)device.getProperty("time");
        if (date != null) {
            cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
        }
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }
}

