/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMHotSpares
implements InstanceProvider,
AssociatorProvider,
PropertyProvider,
Authorizable,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Group");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Spare");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
            }
            Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
            if (device2 == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            return this.hsAssocToCI(cIMObjectPath, device2, device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = this.slvm.getDevices("Hsp");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "ExtentRedundancyComponent");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(i);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Slice")) continue;
                    CIMInstance cIMInstance = this.hsAssocToCI(cIMObjectPath, device2, device, cIMClass, false, false, false, null);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMHotSpares", cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("Group", new CIMValue(cIMInstance.getProperty("Group").getValue().getValue()));
                    cIMObjectPath2.addKey("Spare", new CIMValue(cIMInstance.getProperty("Spare").getValue().getValue()));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            Vector vector = this.slvm.getDevices("Hsp");
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "ExtentRedundancyComponent");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(i);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Slice")) continue;
                    arrayList.add(this.hsAssocToCI(cIMObjectPath, device2, device, cIMClass, bl, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "Group");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "Spare");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMInstance);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        String string = (String)device.getProperty("name");
        String string2 = (String)Solaris_VMUtil.getOPValue(cIMObjectPath3, "DeviceID");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        arrayList.add("/usr/sbin/metahs");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add("-a");
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMHotSpares", cIMObjectPath.getNameSpace());
        cIMObjectPath4.addKey("Group", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath4.addKey("Spare", new CIMValue((Object)cIMObjectPath3));
        return cIMObjectPath4;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Group");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Spare");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
        if (device2 == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
        }
        String string = (String)device.getProperty("name");
        String string2 = (String)device2.getProperty("name");
        String string3 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metahs");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add("-d");
        arrayList.add(string);
        arrayList.add(string2);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string4.equalsIgnoreCase("Solaris_VMHotSparePool");
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "ExtentRedundancyComponent") : this.slvm.getDependents(device, "ExtentRedundancyComponent");
            CIMObjectPath cIMObjectPath3 = null;
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath4;
                Device device2 = (Device)vector2.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                if (bl3) {
                    if (!string6.equals("Slice")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device2.getProperty("name"))));
                } else {
                    if (!string6.equals("Hsp")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)((String)device2.getProperty("name"))));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    cIMObjectPath4 = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(string7, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath5, false, bl, bl2, stringArray);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath4, false, bl, bl2, stringArray)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                if ((cIMObjectPath4 = this.cimomhandle.getInstance(cIMObjectPath3, false, bl, bl2, stringArray)) == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
                }
                vector.addElement(cIMObjectPath4);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl = string4.equalsIgnoreCase("Solaris_VMHotSparePool");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "ExtentRedundancyComponent") : this.slvm.getDependents(device, "ExtentRedundancyComponent");
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            CIMObjectPath cIMObjectPath3 = null;
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device2 = (Device)vector.elementAt(i);
                String string6 = (String)device2.getProperty("type");
                String string7 = Solaris_VMUtil.deviceTypeToClass(string6);
                if (bl) {
                    if (!string6.equals("Slice")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device2.getProperty("name"))));
                } else {
                    if (!string6.equals("Hsp")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string7, string5);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string7));
                    cIMObjectPath3.addKey("Name", new CIMValue((Object)((String)device2.getProperty("name"))));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(string7, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath5, false, false, false, null);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath4, false, false, false, null)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                arrayList.add(cIMObjectPath3);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string2.equalsIgnoreCase("Solaris_VMHotSparePool");
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return vector;
            }
            Vector vector2 = null;
            vector2 = bl3 ? this.slvm.getAntecedents(device, "ExtentRedundancyComponent") : this.slvm.getDependents(device, "ExtentRedundancyComponent");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMHotSpares", string3);
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                Device device2 = (Device)vector2.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                CIMInstance cIMInstance = null;
                if (bl3) {
                    if (!string4.equals("Slice")) continue;
                    cIMInstance = this.hsAssocToCI(cIMObjectPath2, device2, device, cIMClass, false, bl, bl2, stringArray);
                } else {
                    if (!string4.equals("Hsp")) continue;
                    cIMInstance = this.hsAssocToCI(cIMObjectPath2, device, device2, cIMClass, false, bl, bl2, stringArray);
                }
                vector.addElement(cIMInstance);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl = string2.equalsIgnoreCase("Solaris_VMHotSparePool");
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            vector = bl ? this.slvm.getAntecedents(device, "ExtentRedundancyComponent") : this.slvm.getDependents(device, "ExtentRedundancyComponent");
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMHotSpares", string3);
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, false, false, null);
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device2 = (Device)vector.elementAt(i);
                String string4 = (String)device2.getProperty("type");
                String string5 = Solaris_VMUtil.deviceTypeToClass(string4);
                CIMInstance cIMInstance = null;
                if (bl) {
                    if (!string4.equals("Slice")) continue;
                    cIMInstance = this.hsAssocToCI(cIMObjectPath2, device2, device, cIMClass, false, false, false, null);
                } else {
                    if (!string4.equals("Hsp")) continue;
                    cIMInstance = this.hsAssocToCI(cIMObjectPath2, device, device2, cIMClass, false, false, false, null);
                }
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "Group");
                CIMObjectPath cIMObjectPath5 = (CIMObjectPath)Solaris_VMUtil.getValue(cIMInstance, "Spare");
                cIMObjectPath3.addKey("Group", new CIMValue((Object)cIMObjectPath4));
                cIMObjectPath3.addKey("Spare", new CIMValue((Object)cIMObjectPath5));
                arrayList.add(cIMObjectPath3);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance hsAssocToCI(CIMObjectPath cIMObjectPath, Device device, Device device2, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMHotSparePool", cIMObjectPath.getNameSpace());
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMHotSparePool"));
            cIMObjectPath2.addKey("Name", new CIMValue((Object)((String)device2.getProperty("name"))));
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_VMExtent", cIMObjectPath.getNameSpace());
            cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMExtent"));
            cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)((String)device.getProperty("name"))));
            cIMInstance.setProperty("Group", new CIMValue((Object)cIMObjectPath2));
            cIMInstance.setProperty("Spare", new CIMValue((Object)cIMObjectPath3));
            if (!bl) {
                if (this.inUse(device)) {
                    cIMInstance.setProperty("HotStandby", new CIMValue((Object)Boolean.FALSE));
                } else {
                    cIMInstance.setProperty("HotStandby", new CIMValue((Object)Boolean.TRUE));
                }
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private boolean inUse(Device device) {
        if (this.slvm == null) {
            return false;
        }
        try {
            Vector vector = this.slvm.getDependents(device, "ExtentRedundancyComponent");
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    Device device2 = (Device)vector.get(i);
                    String string = (String)device2.getProperty("type");
                    if (!string.equals("Slice")) continue;
                    return true;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }
}

