/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;

public class Solaris_VMExtentInDiskSet
implements InstanceProvider,
AssociatorProvider,
PropertyProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public static void main(String[] stringArray) {
        try {
            SVM sVM = SVM.instance();
            System.out.println("DiskSet associations:");
            System.out.println();
            Vector vector = sVM.getDevices("Disk");
            for (int i = 0; i < vector.size(); ++i) {
                Device device = (Device)vector.get(i);
                System.out.println("DiskSet: " + device);
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printAntecedents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printAntecedents(sVM, device, "ResidesOn", "Resides On");
                Solaris_VMUtil.printAntecedents(sVM, device, "DriveInDiskGroup", "Drive in Disk Group");
                Solaris_VMUtil.printAntecedents(sVM, device, "ExtentInDiskGroup", "Extent in Disk Group");
                Solaris_VMUtil.printDependents(sVM, device, "DriveInDiskGroup", "Drive in Disk Group");
                Solaris_VMUtil.printDependents(sVM, device, "ExtentInDiskGroup", "Extent in Disk Group");
                Solaris_VMUtil.printDependents(sVM, device, "ExtentRedundancyComponent", "Extent Redundancy Component");
                Solaris_VMUtil.printDependents(sVM, device, "BasedOn", "Based On");
                Solaris_VMUtil.printDependents(sVM, device, "ResidesOn", "ResidesOn");
            }
            System.exit(0);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception: " + remoteException.getMessage());
            System.exit(1);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Collection");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)Solaris_VMUtil.getOPValue(cIMObjectPath, "Member");
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        try {
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath3);
            if (device == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
            }
            if (device2 == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            return this.extentDsAssocToCI(cIMObjectPath, device, device2, cIMClass, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            Vector vector = this.slvm.getDevices("Diskset");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "ExtentInDiskGroup");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    CIMInstance cIMInstance = this.extentDsAssocToCI(cIMObjectPath, device, device2, cIMClass, false, false, null);
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("Solaris_VMExtentInDiskSet", cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey("Collection", new CIMValue(cIMInstance.getProperty("Collection").getValue().getValue()));
                    cIMObjectPath2.addKey("Member", new CIMValue(cIMInstance.getProperty("Member").getValue().getValue()));
                    arrayList.add(cIMObjectPath2);
                }
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            Vector vector = this.slvm.getDevices("Diskset");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                Vector vector2 = this.slvm.getAntecedents(device, "ExtentInDiskGroup");
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    Device device2 = (Device)vector2.elementAt(j);
                    arrayList.add(this.extentDsAssocToCI(cIMObjectPath, device, device2, cIMClass, bl2, bl3, stringArray));
                }
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl3 = string4.equalsIgnoreCase("Solaris_VMDiskSet");
        try {
            String string6;
            String string7;
            CIMInstance cIMInstance;
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            if (this.slvm == null) {
                return vector;
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (bl3 && device == null) {
                return vector;
            }
            Vector vector2 = null;
            if (bl3) {
                vector2 = this.slvm.getAntecedents(device, "ExtentInDiskGroup");
            } else {
                cIMInstance = this.cimomhandle.getInstance(cIMObjectPath2, false, bl, bl2, stringArray);
                String string8 = (String)Solaris_VMUtil.getValue(cIMInstance, "DeviceID");
                string7 = string8.substring(0, string8.lastIndexOf("s"));
                string6 = Solaris_VMUtil.getDeviceByAttr(this.slvm, string7, "name", "Disk");
                if (string6 == null) {
                    return vector;
                }
                vector2 = this.slvm.getDependents((Device)string6, "DriveInDiskGroup");
            }
            cIMInstance = null;
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                CIMObjectPath cIMObjectPath3;
                string7 = (Device)vector2.elementAt(i);
                string6 = (String)string7.getProperty("type");
                String string9 = Solaris_VMUtil.deviceTypeToClass(string6);
                if (bl3) {
                    if (!string6.equalsIgnoreCase("Slice")) continue;
                    cIMInstance = new CIMObjectPath(string9, string5);
                    cIMInstance.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMInstance.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMInstance.addKey("CreationClassName", new CIMValue((Object)string9));
                    cIMInstance.addKey("DeviceID", new CIMValue((Object)((String)string7.getProperty("name"))));
                } else {
                    if (!string6.equalsIgnoreCase("Diskset")) continue;
                    cIMInstance = new CIMObjectPath(string9, string5);
                    cIMInstance.addKey("CollectionID", new CIMValue(string7.getProperty("name")));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    cIMObjectPath3 = new CIMObjectPath(string, string5);
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string9, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath4, false, bl, bl2, stringArray);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                if ((cIMObjectPath3 = this.cimomhandle.getInstance((CIMObjectPath)cIMInstance, false, bl, bl2, stringArray)) == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMInstance);
                }
                vector.addElement(cIMObjectPath3);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        String string4 = cIMObjectPath2.getObjectName();
        String string5 = cIMObjectPath2.getNameSpace();
        boolean bl = string4.equalsIgnoreCase("Solaris_VMDiskSet");
        try {
            Device device;
            String string6;
            Object object;
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (bl && device2 == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            if (bl) {
                vector = this.slvm.getAntecedents(device2, "ExtentInDiskGroup");
            } else {
                object = this.cimomhandle.getInstance(cIMObjectPath2, false, false, false, null);
                String string7 = (String)Solaris_VMUtil.getValue((CIMInstance)object, "DeviceID");
                string6 = string7.substring(0, string7.lastIndexOf("s"));
                device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string6, "name", "Disk");
                if (device == null) {
                    return new CIMObjectPath[0];
                }
                vector = this.slvm.getDependents(device, "DriveInDiskGroup");
            }
            object = new ArrayList();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                string6 = null;
                device = (Device)vector.elementAt(i);
                String string8 = (String)device.getProperty("type");
                String string9 = Solaris_VMUtil.deviceTypeToClass(string8);
                if (bl) {
                    if (!string8.equalsIgnoreCase("Slice")) continue;
                    string6 = new CIMObjectPath(string9, string5);
                    string6.addKey("SystemCreationClassName", new CIMValue((Object)string9));
                    string6.addKey("SystemName", new CIMValue((Object)this.hostName));
                    string6.addKey("CreationClassName", new CIMValue((Object)string9));
                    string6.addKey("DeviceID", new CIMValue((Object)((String)device.getProperty("name"))));
                } else {
                    if (!string8.equalsIgnoreCase("Diskset")) continue;
                    string6 = new CIMObjectPath(string9, string5);
                    string6.addKey("CollectionID", new CIMValue((Object)((String)device.getProperty("name"))));
                }
                if (string != null) {
                    CIMClass cIMClass;
                    CIMObjectPath cIMObjectPath3 = new CIMObjectPath(string9, string5);
                    CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string9, string5);
                    CIMClass cIMClass2 = this.cimomhandle.getClass(cIMObjectPath3, false, false, false, null);
                    if (!Solaris_VMUtil.isSuperClass(cIMClass2, cIMClass = this.cimomhandle.getClass(cIMObjectPath4, false, false, false, null)) && !Solaris_VMUtil.isSuperClass(cIMClass, cIMClass2)) continue;
                }
                ((ArrayList)object).add(string6);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[((ArrayList)object).size()];
            ((ArrayList)object).toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        boolean bl3 = string2.equalsIgnoreCase("Solaris_VMDiskSet");
        try {
            Device device;
            String string3;
            CIMInstance cIMInstance;
            Vector<Device> vector = new Vector<Device>();
            if (this.slvm == null) {
                return vector;
            }
            Device device2 = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (bl3 && device2 == null) {
                return vector;
            }
            Vector vector2 = null;
            if (bl3) {
                vector2 = this.slvm.getAntecedents(device2, "ExtentInDiskGroup");
            } else {
                cIMInstance = this.cimomhandle.getInstance(cIMObjectPath2, false, bl, bl2, stringArray);
                string3 = (String)Solaris_VMUtil.getValue(cIMInstance, "DeviceID");
                String string4 = string3.substring(0, string3.lastIndexOf("s"));
                device2 = device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string4, "name", "Disk");
                if (device == null) {
                    return vector;
                }
                vector2 = this.slvm.getDependents(device2, "DriveInDiskGroup");
            }
            cIMInstance = new CIMObjectPath("Solaris_VMExtentInDiskSet", cIMObjectPath2.getNameSpace());
            string3 = this.cimomhandle.getClass((CIMObjectPath)cIMInstance, false, bl, bl2, stringArray);
            for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
                device = null;
                Device device3 = (Device)vector2.elementAt(i);
                String string5 = (String)device3.getProperty("type");
                if (bl3) {
                    if (!string5.equalsIgnoreCase("Slice")) continue;
                    device = this.extentDsAssocToCI(cIMObjectPath2, device2, device3, (CIMClass)string3, bl, bl2, stringArray);
                } else {
                    if (!string5.equalsIgnoreCase("Diskset")) continue;
                    device = this.extentDsAssocToCI(cIMObjectPath2, device3, device2, (CIMClass)string3, bl, bl2, stringArray);
                }
                vector.addElement(device);
            }
            return vector;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        String string2 = cIMObjectPath2.getObjectName();
        String string3 = cIMObjectPath2.getNameSpace();
        boolean bl = string2.equalsIgnoreCase("Solaris_VMDiskSet");
        try {
            Object object;
            String string4;
            Object object2;
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath2);
            if (bl && device == null) {
                return new CIMObjectPath[0];
            }
            Vector vector = null;
            if (bl) {
                vector = this.slvm.getAntecedents(device, "ExtentInDiskGroup");
            } else {
                object2 = this.cimomhandle.getInstance(cIMObjectPath2, false, false, false, null);
                String string5 = (String)Solaris_VMUtil.getValue((CIMInstance)object2, "DeviceID");
                string4 = string5.substring(0, string5.lastIndexOf("s"));
                object = Solaris_VMUtil.getDeviceByAttr(this.slvm, string4, "name", "Disk");
                if (object == null) {
                    return new CIMObjectPath[0];
                }
                vector = this.slvm.getDependents((Device)object, "DriveInDiskGroup");
            }
            object2 = new ArrayList();
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                string4 = (Device)vector.elementAt(i);
                object = (String)string4.getProperty("type");
                String string6 = Solaris_VMUtil.deviceTypeToClass((String)object);
                CIMObjectPath cIMObjectPath3 = null;
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_VMExtentInDiskSet", string3);
                if (bl) {
                    if (!((String)object).equalsIgnoreCase("Slice")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string6, string3);
                    cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string6));
                    cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                    cIMObjectPath3.addKey("DeviceID", new CIMValue(string4.getProperty("name")));
                    cIMObjectPath4.addKey("Collection", new CIMValue((Object)cIMObjectPath2));
                    cIMObjectPath4.addKey("Member", new CIMValue((Object)cIMObjectPath3));
                } else {
                    if (!((String)object).equalsIgnoreCase("Diskset")) continue;
                    cIMObjectPath3 = new CIMObjectPath(string6, string3);
                    cIMObjectPath3.addKey("CollectionID", new CIMValue((Object)((String)string4.getProperty("name"))));
                    cIMObjectPath4.addKey("Member", new CIMValue((Object)cIMObjectPath2));
                    cIMObjectPath4.addKey("Collection", new CIMValue((Object)cIMObjectPath3));
                }
                ((ArrayList)object2).add(cIMObjectPath4);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private CIMInstance extentDsAssocToCI(CIMObjectPath cIMObjectPath, Device device, Device device2, CIMClass cIMClass, boolean bl, boolean bl2, String[] stringArray) throws CIMProviderException {
        String string = (String)device.getProperty("type");
        String string2 = (String)device2.getProperty("type");
        String string3 = Solaris_VMUtil.deviceTypeToClass(string);
        String string4 = Solaris_VMUtil.deviceTypeToClass(string2);
        String string5 = cIMObjectPath.getNameSpace();
        try {
            CIMInstance cIMInstance = cIMClass.newInstance();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string4, string5);
            String string6 = (String)device.getProperty("name");
            cIMObjectPath2.addKey("CollectionID", new CIMValue((Object)string6));
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(string4, string5);
            String string7 = (String)device2.getProperty("name");
            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)string4));
            cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)string7));
            cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
            cIMInstance.setProperty("Collection", new CIMValue((Object)cIMObjectPath2));
            cIMInstance.setProperty("Member", new CIMValue((Object)cIMObjectPath3));
            return cIMInstance.filterProperties(stringArray, bl, bl2);
        }
        catch (Exception exception) {
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)exception);
        }
    }
}

