/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;

public class Solaris_VMExtent
implements InstanceProvider,
Authorizable,
PropertyProvider {
    private static final int CS_OKAY = 1;
    private static final int CS_ERRED = 2;
    private static final int CS_RESYNC = 4;
    private static final int CS_LAST_ERRED = 8;
    private static final int RCS_INIT = 1;
    private static final int RCS_OKAY = 2;
    private static final int RCS_ERRED = 4;
    private static final int RCS_LAST_ERRED = 8;
    private static final int RCS_RESYNC = 16;
    private static final int RCS_INIT_ERRED = 32;
    private static final int RCS_REGEN = 64;
    private static final int HSS_UNUSED = 0;
    private static final int HSS_AVAILABLE = 1;
    private static final int HSS_RESERVED = 2;
    private static final int HSS_BROKEN = 3;
    private static final int Type_Unknown = 0;
    private static final int Type_RaidComp = 1;
    private static final int Type_StripeConcatComp = 2;
    private static final int Type_SubMirrorComp = 3;
    private static final int Type_TransMaster = 4;
    private static final int Type_TransLog = 5;
    private static final int Type_HotSpare = 6;
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        String string = (String)Solaris_VMUtil.getOPValue(cIMObjectPath, "DeviceID");
        Enumeration enumeration = null;
        try {
            cIMObjectPath2 = new CIMObjectPath("Solaris_VMExtent", cIMObjectPath.getNameSpace());
            enumeration = this.cimomhandle.enumerateInstances(cIMObjectPath2, true, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMInstance)enumeration.nextElement();
                String string2 = (String)Solaris_VMUtil.getValue((CIMInstance)cIMObjectPath2, "Name");
                if (string2 == null || !string2.equals(string)) continue;
                return cIMObjectPath2;
            }
        }
        throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        Object object;
        ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
        String string = cIMObjectPath.getObjectName();
        String string2 = cIMObjectPath.getNameSpace();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Enumeration enumeration = null;
        try {
            object = new CIMObjectPath("Solaris_DiskPartition", string2);
            enumeration = this.cimomhandle.enumerateInstanceNames((CIMObjectPath)object);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = (CIMObjectPath)enumeration.nextElement();
                String string3 = (String)Solaris_VMUtil.getOPValue((CIMObjectPath)object, "DeviceID");
                cIMObjectPath2 = new CIMObjectPath(string, string2);
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.hostName));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMExtent"));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)string3));
                arrayList.add(cIMObjectPath2);
                arrayList2.add(string3);
            }
        }
        object = null;
        try {
            if (this.slvm != null) {
                object = this.slvm.getDevices("Slice");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (object != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                cIMObjectPath2 = (Device)((Vector)object).get(i);
                String string4 = (String)cIMObjectPath2.getProperty("name");
                boolean bl = arrayList2.contains(string4);
                if (bl) continue;
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath(string, string2);
                cIMObjectPath3.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath3.addKey("SystemName", new CIMValue((Object)this.hostName));
                cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMExtent"));
                cIMObjectPath3.addKey("DeviceID", new CIMValue((Object)string4));
                arrayList.add(cIMObjectPath3);
            }
        }
        CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
        arrayList.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        Object object;
        Object object2;
        String string;
        CIMInstance cIMInstance;
        Vector vector = null;
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        try {
            if (this.slvm != null) {
                vector = this.slvm.getDevices("Metadb");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Vector vector2 = null;
        try {
            if (this.slvm != null) {
                vector2 = this.slvm.getDevices("Slice");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Enumeration enumeration = null;
        try {
            cIMInstance = new CIMObjectPath("Solaris_DiskPartition", cIMObjectPath.getNameSpace());
            enumeration = this.cimomhandle.enumerateInstances((CIMObjectPath)cIMInstance, true, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                string = (String)Solaris_VMUtil.getValue(cIMInstance, "DeviceID");
                object2 = (UnsignedInt32)Solaris_VMUtil.getValue(cIMInstance, "Blocks");
                Long l = null;
                if (object2 != null) {
                    l = new Long(object2.longValue());
                }
                object = this.getSliceDevice(string, vector2);
                arrayList.add(this.sliceToCI(string, l, (Device)object, vector, cIMClass, bl, bl2, bl3, stringArray, false));
                arrayList2.add(string);
            }
        }
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                string = (Device)vector2.get(i);
                object2 = (String)string.getProperty("name");
                boolean bl4 = arrayList2.contains(object2);
                if (bl4) continue;
                object = (Long)string.getProperty("slice size");
                arrayList.add(this.sliceToCI((String)object2, (Long)object, (Device)string, vector, cIMClass, bl, bl2, bl3, stringArray, true));
            }
        }
        cIMInstance = new CIMInstance[arrayList.size()];
        arrayList.toArray((T[])cIMInstance);
        return cIMInstance;
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)Solaris_VMUtil.getValue(cIMInstance, "StatusInfo");
        this.enable(device, unsignedInt16);
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        if (!string2.equalsIgnoreCase("StatusInfo")) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)cIMObjectPath);
        }
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
        this.enable(device, unsignedInt16);
    }

    private void enable(Device device, UnsignedInt16 unsignedInt16) throws CIMException {
        if (unsignedInt16 == null || unsignedInt16.intValue() != 3) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)unsignedInt16);
        }
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        if (this.isHotSpare(device)) {
            String string = Solaris_VMUtil.getDiskSet(this.slvm, device);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("/usr/sbin/metahs");
            if (string != null) {
                arrayList.add("-s");
                arrayList.add(string);
            }
            arrayList.add("-e");
            String string2 = (String)device.getProperty("name");
            arrayList.add(string2);
            Solaris_VMUtil.run(arrayList, this.hostName);
        } else {
            Device device2 = this.getMirrorRaid(device);
            if (device2 != null) {
                String string = Solaris_VMUtil.getDiskSet(this.slvm, device2);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("/usr/sbin/metareplace");
                if (string != null) {
                    arrayList.add("-s");
                    arrayList.add(string);
                }
                arrayList.add("-f");
                arrayList.add("-e");
                String string3 = (String)device2.getProperty("name");
                arrayList.add(string3);
                String string4 = (String)device.getProperty("name");
                arrayList.add(string4);
                Solaris_VMUtil.run(arrayList, this.hostName);
            } else {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)"Solaris_VMMirror/Solaris_VMRaid5");
            }
        }
    }

    private CIMInstance sliceToCI(String string, Long l, Device device, Vector vector, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray, boolean bl4) {
        Date date;
        CIMInstance cIMInstance = cIMClass.newInstance();
        int n = this.getType(device);
        cIMInstance.setProperty("Status", new CIMValue((Object)this.getStatus(device, n, bl4)));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)this.hostName));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMExtent"));
        cIMInstance.setProperty("DeviceID", new CIMValue((Object)string));
        cIMInstance.setProperty("StatusInfo", new CIMValue((Object)new UnsignedInt16(this.getStatusInfo(device, n))));
        if (l != null) {
            long l2 = l;
            cIMInstance.setProperty("NumberOfBlocks", new CIMValue((Object)new UnsignedInt64(String.valueOf(l2))));
            long l3 = this.getMDBSize(string, vector);
            cIMInstance.setProperty("ConsumableBlocks", new CIMValue((Object)new UnsignedInt64(String.valueOf(l2 -= l3))));
        }
        if (device != null && (date = (Date)device.getProperty("time")) != null) {
            cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
        }
        cIMInstance.setProperty("DataOrganization", new CIMValue((Object)new UnsignedInt16(2)));
        cIMInstance.setProperty("Access", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("BlockSize", new CIMValue((Object)Solaris_VMUtil.BLOCKSIZE));
        cIMInstance.setProperty("IsBasedOnUnderlyingRedundancy", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("SequentialAccess", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("PowerManagementSupported", new CIMValue((Object)Boolean.FALSE));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(1));
        cIMInstance.setProperty("PowerManagementCapabilities", new CIMValue(vector2));
        cIMInstance.setProperty("Availability", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("LastErrorCode", new CIMValue((Object)new UnsignedInt32(0L)));
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        vector3.add(new UnsignedInt16(6));
        cIMInstance.setProperty("AdditionalAvailability", new CIMValue(vector3));
        cIMInstance.setProperty("MaxQuiesceTime", new CIMValue((Object)new UnsignedInt64("0")));
        cIMInstance.setProperty("Name", new CIMValue((Object)string));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private long getMDBSize(String string, Vector vector) {
        long l = 0L;
        Long l2 = null;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Long l3;
                String string2;
                Device device = (Device)vector.get(i);
                String string3 = (String)device.getProperty("type");
                if (string3 == null || !string3.equals("Metadb") || (string2 = (String)device.getProperty("name")) == null || !string2.equals(string)) continue;
                Long l4 = (Long)device.getProperty("size");
                if (l4 != null) {
                    l += l4.longValue();
                }
                if ((l3 = (Long)device.getProperty("startblock")) == null) continue;
                if (l2 == null) {
                    l2 = l3;
                    continue;
                }
                if (l2 <= l3) continue;
                l2 = l3;
            }
        }
        if (l != 0L && l2 != null) {
            l += l2.longValue();
        }
        return l;
    }

    private int getType(Device device) {
        Boolean bl;
        if (device == null) {
            return 0;
        }
        if (this.slvm == null) {
            return 0;
        }
        String string = (String)device.getProperty("trans component type");
        if (string != null) {
            if (string.equals("log")) {
                return 5;
            }
            return 4;
        }
        Vector vector = null;
        try {
            vector = this.slvm.getDependents(device, "BasedOn");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                String string2 = (String)device2.getProperty("type");
                if (string2.equals("Raid")) {
                    return 1;
                }
                if (!string2.equals("Stripe") && !string2.equals("Concat")) continue;
                Vector vector2 = null;
                try {
                    vector2 = this.slvm.getDependents(device2, "BasedOn");
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (vector2 != null) {
                    for (int j = 0; j < vector2.size(); ++j) {
                        Device device3 = (Device)vector2.get(j);
                        String string3 = (String)device3.getProperty("type");
                        if (!string3.equals("Mirror")) continue;
                        return 3;
                    }
                }
                return 2;
            }
        }
        if ((bl = (Boolean)device.getProperty("top level device")) != null && !bl.booleanValue()) {
            return 6;
        }
        return 0;
    }

    private String getStatus(Device device, int n, boolean bl) {
        if (device == null) {
            return "";
        }
        switch (n) {
            case 1: {
                return this.getRaidCompState(device);
            }
            case 2: {
                if (bl) {
                    return "error";
                }
                return this.getComponentState(device);
            }
            case 3: {
                return this.getComponentState(device);
            }
            case 5: {
                return Solaris_VMUtil.getTransLogState(device);
            }
            case 6: {
                if (bl) {
                    return "error";
                }
                return this.getHSState(device);
            }
        }
        return "";
    }

    private int getStatusInfo(Device device, int n) {
        if (device == null) {
            return 5;
        }
        if (n == 1) {
            Integer n2 = (Integer)device.getProperty("state");
            if (n2 == null) {
                return 2;
            }
            int n3 = n2;
            switch (n3) {
                case 4: 
                case 8: 
                case 32: {
                    return 4;
                }
            }
            Vector vector = null;
            try {
                vector = this.slvm.getDependents(device, "ExtentRedundancyComponent");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector != null && vector.size() > 0) {
                return 4;
            }
            return 3;
        }
        if (n == 3) {
            Integer n4 = (Integer)device.getProperty("state");
            if (n4 == null) {
                return 2;
            }
            int n5 = n4;
            switch (n5) {
                case 2: 
                case 4: 
                case 8: {
                    return 4;
                }
            }
            Vector vector = null;
            try {
                vector = this.slvm.getDependents(device, "ExtentRedundancyComponent");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector != null && vector.size() > 0) {
                return 4;
            }
            return 3;
        }
        if (n == 6) {
            Integer n6 = (Integer)device.getProperty("state");
            if (n6 == null) {
                return 2;
            }
            int n7 = n6;
            if (n7 == 3) {
                return 4;
            }
            return 3;
        }
        return 5;
    }

    private String getRaidCompState(Device device) {
        Integer n = (Integer)device.getProperty("state");
        if (n == null) {
            return "invalid";
        }
        int n2 = n;
        switch (n2) {
            case 1: {
                return "initializing";
            }
            case 2: {
                return "okay";
            }
            case 4: 
            case 32: {
                return "maintenance";
            }
            case 8: {
                return "last errored";
            }
            case 16: {
                return "resyncing";
            }
        }
        return "invalid";
    }

    private String getComponentState(Device device) {
        Integer n = (Integer)device.getProperty("state");
        if (n == null) {
            return "";
        }
        int n2 = n;
        switch (n2) {
            case 1: {
                return "okay";
            }
            case 2: {
                return "maintenance";
            }
            case 8: {
                return "last errored";
            }
            case 4: {
                return "resyncing";
            }
        }
        return "";
    }

    private String getHSState(Device device) {
        Integer n = (Integer)device.getProperty("state");
        if (n == null) {
            return "invalid";
        }
        int n2 = n;
        switch (n2) {
            case 0: {
                return "unused";
            }
            case 1: {
                return "available";
            }
            case 2: {
                return "reserved";
            }
            case 3: {
                return "broken";
            }
        }
        return "invalid";
    }

    private Device getSliceDevice(String string, Vector vector) {
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Device device = (Device)vector.get(i);
            String string2 = (String)device.getProperty("name");
            if (string2 == null || !string2.equals(string)) continue;
            return device;
        }
        return null;
    }

    private boolean isHotSpare(Device device) {
        Vector vector = null;
        if (this.slvm == null) {
            return false;
        }
        try {
            vector = this.slvm.getDependents(device, "ExtentRedundancyComponent");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Device device2 = (Device)vector.get(i);
            String string = (String)device2.getProperty("type");
            if (!string.equals("Hsp")) continue;
            return true;
        }
        return false;
    }

    private Device getMirrorRaid(Device device) {
        Vector vector = null;
        try {
            vector = this.slvm.getDependents(device, "BasedOn");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Device device2 = (Device)vector.get(i);
            String string = (String)device2.getProperty("type");
            if (string.equals("Raid")) {
                return device2;
            }
            if (!string.equals("Stripe") && !string.equals("Concat")) continue;
            Vector vector2 = null;
            try {
                vector2 = this.slvm.getDependents(device2, "BasedOn");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (vector2 == null) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                Device device3 = (Device)vector2.get(j);
                String string2 = (String)device3.getProperty("type");
                if (!string2.equals("Mirror")) continue;
                return device3;
            }
        }
        return null;
    }
}

