/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.trustedsolaris.TsolAttrs;
import com.sun.wbem.cimom.CommonServerSecurityContext;
import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.audit.WbemAuditService;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.cimom.security.UserPasswordProvider;
import com.sun.wbem.client.adapter.rmi.RemoteCIMListener;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;
import javax.wbem.security.UserPasswordEncryptionProvider;

public final class ServerSecurity
implements CommonServerSecurityContext {
    public static final long AUDIT_NO_SUCH_USER = -1L;
    public static final long AUDIT_BAD_PASSWD = -2L;
    public static final long AUDIT_SUCCESS = 1L;
    public static final long AUDIT_ROLE_SUCCESS = 2L;
    public static final long AUDIT_BAD_ROLE = -3L;
    private static final String WBEM_LOCAL_TYPE = "__LOCAL";
    private static final String WBEM_LOCAL_DIR = "/var/sadm/wbem/security";
    private static final int WBEM_LOCAL_NONCE_SIZE = 16;
    private static final String FAKE_HASH = ".F.A.K.E.H.A.S.H.";
    private static ThreadLocal requestSession = new ThreadLocal();
    protected static byte[] adminCred = null;
    private static boolean initialized = false;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey sprivkey;
    private static PublicKey spubkey;
    private MessageDigest md = null;
    private PublicKey cpubkey;
    private String userName = null;
    private String roleName = null;
    private String authName = null;
    private String localFile = null;
    private String clientHost = null;
    private String initialKey = "InitialKey";
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] decryptKey = null;
    private byte[] auditKey = null;
    private byte[] cf;
    private byte[] sf;
    private byte[] nameSpace;
    private String cp = null;
    private String cversion;
    private String cap = "none";
    private String capNameSpace = "__junk__";
    private boolean bLocalMode = false;
    private boolean clientSystemIsLabeled = false;
    private boolean clientRoleWSLogin = false;
    private static UserPasswordProvider upp;
    private RemoteCIMListener rl = null;
    private static boolean ssl_enabled;
    private WbemAuditSession auditSession = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    private void auditSessionInit() {
        if (this.auditSession == null) {
            WbemAuditService auditService = (WbemAuditService)ServiceRegistry.getService("auditservice");
            if (auditService != null) {
                this.auditSession = auditService.getAuditSession();
            } else {
                Debug.trace3((String)"ServiceRegistry.getService() returned null auditService");
            }
        }
    }

    static UserPasswordProvider getUserPasswordProvider() throws Exception {
        if (upp == null) {
            try {
                Class<?> c = Class.forName(System.getProperty("com.sun.wbem.cimom.pswdprov"));
                upp = (UserPasswordProvider)c.newInstance();
            }
            catch (Exception e) {
                Debug.trace1((String)"Sundigest: Error getting password provider", (Throwable)e);
                throw e;
            }
        }
        return upp;
    }

    public ServerSecurity() throws Exception {
        if (!initialized) {
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            sprivkey = keypair.getPrivate();
            spubkey = keypair.getPublic();
            String is_ssl = System.getProperty("sun.smc.internal.ssl.enable", "yes");
            if (!is_ssl.equals("yes")) {
                ssl_enabled = false;
            }
            initialized = true;
        }
        upp = ServerSecurity.getUserPasswordProvider();
        this.md = MessageDigest.getInstance("MD5");
        this.auditSessionInit();
    }

    public ServerSecurity(String userName, String roleName, String hostname, byte[] auditKey) {
        this.userName = userName;
        this.roleName = roleName;
        this.setClientHostName(hostname);
        ServerSecurity.setRequestSession(this);
        this.auditKey = auditKey;
        this.auditSessionInit();
    }

    public String getClientVersion() {
        return this.cversion;
    }

    public String getCapability() {
        return this.cap;
    }

    public String getCapabilityNS() {
        return this.capNameSpace;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getPasswd() {
        return this.cp;
    }

    public byte[] getNameSpace() {
        return this.nameSpace;
    }

    public byte[] getShadow() {
        return this.sf;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return spubkey;
    }

    public PublicKey getClientPublicKey() {
        return this.cpubkey;
    }

    public PrivateKey getPrivateKey() {
        return sprivkey;
    }

    public MessageDigest getMD() {
        return this.md;
    }

    public Signature getSigner() {
        return signer;
    }

    public RemoteCIMListener getListener() {
        return this.rl;
    }

    public void setCapability(String cap) {
        this.cap = cap;
    }

    public void setCapabilityNS(String ns) {
        this.capNameSpace = ns;
    }

    public void setClientHostName(String hostName) {
        this.clientHost = hostName;
    }

    public void setListener(RemoteCIMListener rl) {
        this.rl = rl;
    }

    public SecurityMessage generateChallenge(String version, SecurityMessage cm, byte[] sessionId) throws CIMException {
        byte[] roleWSLogin_byte;
        String roleWSLogin_str;
        if (!cm.isHello()) {
            throw new CIMSecurityException("NOT_HELLO");
        }
        this.cversion = version;
        this.sessionId = sessionId;
        byte[] cchallenge1 = cm.getChallenge();
        this.md.reset();
        this.md.update(cchallenge1);
        byte[] userHash = this.md.digest(this.initialKey.getBytes());
        this.md.reset();
        this.md.update(cchallenge1);
        this.md.update(this.initialKey.getBytes());
        this.md.update(cm.getUserDigest());
        this.md.update(cm.getNameSpace());
        this.md.update(cm.getLabeledSystem());
        this.md.update(cm.getRoleWSLogin());
        if (!MessageDigest.isEqual(this.md.digest(), cm.getChecksum())) {
            Debug.trace1((String)"Sundigest: user authentication; request checksum error");
            throw new CIMSecurityException("CHECKSUM_ERROR");
        }
        byte[] unb = SecurityUtil.extractHashedData((byte[])cm.getUserDigest(), (byte[])userHash);
        this.nameSpace = SecurityUtil.extractHashedData((byte[])cm.getNameSpace(), (byte[])userHash);
        byte[] labelSys_byte = SecurityUtil.extractHashedData((byte[])cm.getLabeledSystem(), (byte[])userHash);
        String labelSys_str = new String(labelSys_byte);
        if (labelSys_str.equals("true")) {
            this.clientSystemIsLabeled = true;
        }
        if ((roleWSLogin_str = new String(roleWSLogin_byte = SecurityUtil.extractHashedData((byte[])cm.getRoleWSLogin(), (byte[])userHash))).equals("true")) {
            this.clientRoleWSLogin = true;
        }
        this.userName = new String(unb);
        if (unb == null) {
            Debug.trace1((String)"Sundigest: user authentication; no user name");
            upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, -1L);
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", null);
        }
        this.authName = new String(unb);
        Debug.trace3((String)("Sundigest: user = " + this.authName));
        int i = this.authName.indexOf(58);
        if (i > 0) {
            this.userName = this.authName.substring(0, i);
            if (this.authName.length() > i && this.authName.substring(i + 1).equals(WBEM_LOCAL_TYPE)) {
                this.bLocalMode = true;
            } else {
                Debug.trace1((String)("Sundigest: invalid user type: " + this.authName));
                upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, -1L);
                throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)this.userName);
            }
        }
        String shadow = null;
        TsolAttrs serverTsolAttrs = new TsolAttrs();
        if (serverTsolAttrs != null && serverTsolAttrs.isSystemLabeled() && this.clientSystemIsLabeled && this.clientRoleWSLogin) {
            try {
                String cname = "com.sun.wbem.client.SolarisPswdEncryptionProvider";
                Class<?> c = Class.forName(cname);
                UserPasswordEncryptionProvider pep = (UserPasswordEncryptionProvider)c.newInstance();
                shadow = pep.encryptPassword(this.authName, "fakesalt", "__fake__pass_tsol1");
            }
            catch (Exception ex) {
                shadow = null;
                ex.printStackTrace();
            }
        } else {
            shadow = upp.getEncryptedPassword(this.userName, 1);
        }
        if (shadow == null || shadow.length() == 0) {
            Debug.trace1((String)("Sundigest: user authentication; bad user name: " + this.userName));
            upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, -1L);
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)this.userName);
        }
        byte[] salt = null;
        if (this.bLocalMode) {
            this.sf = new byte[16];
            SecurityUtil.secrand.nextBytes(this.sf);
            Debug.trace3((String)("Sundigest: shared secret: " + this.toHex(this.sf)));
            byte[] hnb = SecurityUtil.hashData((byte[])this.sf, (byte[])cchallenge1);
            String hnx = this.toHex(hnb);
            this.localFile = null;
            try {
                this.localFile = upp.writeLocalAuthenticator(this.userName, WBEM_LOCAL_DIR, hnx);
                i = this.localFile.lastIndexOf(File.separatorChar);
                if (i > 0) {
                    this.localFile = this.localFile.substring(i + 1);
                }
                String sSalt = "$__LOCAL$" + this.localFile;
                salt = sSalt.getBytes("UTF-8");
            }
            catch (Exception ex) {
                Debug.trace1((String)("Sundigest: error writing local auth file: " + ex.getMessage()));
                throw new CIMSecurityException("CIM_ERR_FAILED", (Object)"WRITE_LOCAL_AUTHENTICATOR");
            }
        }
        if (shadow.charAt(0) != '$' || ssl_enabled) {
            this.sf = shadow.getBytes();
            salt = new byte[]{this.sf[0], this.sf[1]};
        } else {
            i = shadow.lastIndexOf(36);
            try {
                this.sf = shadow.substring(i + 1).getBytes();
                salt = shadow.substring(0, i).getBytes();
            }
            catch (Exception ex) {
                Debug.trace1((String)("Sundigest: bad password encryption: " + shadow));
                throw new CIMSecurityException("INVALID_CREDENTIAL");
            }
        }
        Debug.trace3((String)("Sundigest: shared secret: " + new String(this.sf)));
        Debug.trace3((String)("Sundigest: salt = " + new String(salt)));
        Debug.trace3((String)("Sundigest: request valid: " + this.userName));
        this.schallenge1 = new byte[16];
        SecurityUtil.secrand.nextBytes(this.schallenge1);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        byte[] digest = this.md.digest();
        byte[] hashedSalt = SecurityUtil.hashData((byte[])salt, (byte[])digest);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        this.md.update(hashedSalt);
        return SecurityMessage.challenge((byte[])this.schallenge1, (byte[])hashedSalt, (byte[])sessionId, (byte[])this.md.digest(sessionId));
    }

    public SecurityMessage validateResponse(byte[] challenge, byte[] f, PublicKey pubkey, byte[] sessionKey, SecurityMessage cm) throws CIMException {
        if (this.bLocalMode) {
            this.removeLocalFile();
        }
        if (!cm.isResponse()) {
            throw new CIMSecurityException("NOT_RESPONSE");
        }
        this.sessionKey = sessionKey;
        this.cpubkey = cm.getPublicKey();
        byte[] fb = new byte[]{0};
        try {
            fb = FAKE_HASH.getBytes("UTF-8");
        }
        catch (Exception utfexc) {
            Debug.trace1((String)("Sundigest: error using UTF-8 converter: " + utfexc.getMessage()));
        }
        this.md.reset();
        this.md.update(challenge);
        this.md.update(this.initialKey.getBytes());
        byte[] digest = ssl_enabled ? this.md.digest(fb) : this.md.digest(f);
        this.md.reset();
        this.md.update(challenge);
        this.md.update(this.initialKey.getBytes());
        if (ssl_enabled) {
            this.md.update(fb);
        } else {
            this.md.update(f);
        }
        this.md.update(cm.getResponse());
        this.md.update(cm.getPublicKey().getEncoded());
        this.md.update(cm.getSessionId());
        if (!MessageDigest.isEqual(this.md.digest(), cm.getChecksum())) {
            Debug.trace1((String)("Sundigest: invalid credentials: " + this.userName));
            upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        byte[] response = SecurityUtil.extractHashedData((byte[])cm.getResponse(), (byte[])digest);
        if (response == null) {
            upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        boolean bOk = false;
        TsolAttrs serverTsolAttrs = new TsolAttrs();
        if (serverTsolAttrs != null && serverTsolAttrs.isSystemLabeled() && this.clientSystemIsLabeled && this.clientRoleWSLogin) {
            bOk = true;
        } else if (this.bLocalMode) {
            if (Arrays.equals(response, f)) {
                bOk = true;
            }
        } else {
            try {
                bOk = upp.authenticateUser(this.userName, new String(response, "UTF-8"));
            }
            catch (Exception utfexc) {
                Debug.trace1((String)("Sundigest: error creating password string with UTF-8 converter: " + utfexc.getMessage()));
            }
        }
        if (!bOk) {
            Debug.trace1((String)("Sundigest: invalid credentials: " + this.userName));
            upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        Debug.trace1((String)("Sundigest: client authenticated: " + this.userName));
        this.decryptKey = new byte[sessionKey.length];
        System.arraycopy(sessionKey, 0, this.decryptKey, 0, this.decryptKey.length);
        this.auditKey = new byte[4];
        System.arraycopy(sessionKey, 0, this.auditKey, 0, 4);
        this.md.reset();
        this.md.update(challenge);
        digest = this.md.digest(response);
        byte[] hashedKey = SecurityUtil.hashData((byte[])sessionKey, (byte[])digest);
        this.md.reset();
        this.md.update(challenge);
        this.md.update(response);
        this.md.update(cm.getSessionId());
        this.md.update(pubkey.getEncoded());
        upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, 1L);
        return SecurityMessage.result((byte[])cm.getSessionId(), (PublicKey)pubkey, (byte[])hashedKey, (byte[])this.md.digest(hashedKey));
    }

    public void assumeRole(String role_name, String encr_pswd) throws CIMException {
        String role_pswd = this.trans51Unformat(encr_pswd);
        if (!upp.authenticateRole(role_name, role_pswd, this.userName)) {
            Debug.trace1((String)("Solarisdigest: role assumption; : Could not assume role " + role_name + " for user " + this.userName));
            upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, role_name, -3L);
            throw new CIMSecurityException("CANNOT_ASSUME_ROLE", (Object)this.userName, (Object)role_name);
        }
        this.roleName = role_name;
        Debug.trace1((String)("Solarisdigest: role assumed: " + this.roleName));
        upp.auditLogin(this.getAuditSession(), this.clientHost, this.userName, role_name, 2L);
    }

    public void authenticateRequest(String[] sarray, SecurityToken st) throws CIMException {
        ServerSecurity.setRequestSession(this);
        MessageDigest digester = this.getMD();
        String s = "";
        for (int i = 0; i < sarray.length; ++i) {
            s = s + sarray[i];
        }
        byte[] ser = s.getBytes();
        digester.reset();
        digester.update(this.getSessionKey());
        digester.update(ser);
        byte[] digest = digester.digest();
        if (!MessageDigest.isEqual(digest, st.getChecksum())) {
            Debug.trace1((String)"Sundigest: method authentication; invalid digest");
            throw new CIMSecurityException("CHECKSUM_ERROR");
        }
    }

    public void incSessionKey() {
        SecurityUtil.incByteArray((byte[])this.sessionKey);
    }

    public String trans51Unformat(String inData) {
        byte[] pwb = this.fromHex(inData);
        if (pwb == null) {
            return null;
        }
        if (this.decryptKey == null) {
            return null;
        }
        int len = this.decryptKey.length;
        byte[] rb = new byte[len];
        System.arraycopy(this.decryptKey, 0, rb, 0, len);
        boolean sw = true;
        int j = 0;
        int k = len;
        for (int i = 0; i < k; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
            if (!sw || rb[i] != 0) continue;
            sw = false;
            j = i;
        }
        if (j < 1 || j > 15) {
            return null;
        }
        String sval = new String(rb, 0, j);
        return sval;
    }

    public static void setRequestSession(CommonServerSecurityContext newCtx) {
        requestSession.set(newCtx);
    }

    static CommonServerSecurityContext getRequestSession() {
        return (CommonServerSecurityContext)requestSession.get();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getClientHostName() {
        return this.clientHost;
    }

    public int getAuditId() {
        int i = 0;
        if (this.auditKey != null) {
            i = (this.auditKey[0] & 0xFF) << 24;
            i |= (this.auditKey[1] & 0xFF) << 16;
            i |= (this.auditKey[2] & 0xFF) << 8;
            i |= this.auditKey[3] & 0xFF;
        }
        return i;
    }

    public WbemAuditSession getAuditSession() {
        return this.auditSession;
    }

    public static WbemAuditSession getThreadAuditSession() {
        CommonServerSecurityContext cssc = ServerSecurity.getRequestSession();
        if (cssc != null) {
            return cssc.getAuditSession();
        }
        return null;
    }

    private void removeLocalFile() {
        if (this.localFile != null && this.localFile.length() > 0) {
            try {
                File fd = new File(WBEM_LOCAL_DIR + File.separator + this.localFile);
                fd.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String toHex(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    private byte[] fromHex(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length() / 2 * 2;
        byte[] ba = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int k;
            ba[j] = 0;
            boolean ok = false;
            char c = str.charAt(i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(k << 4 & 0xF0);
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ok = false;
            c = str.charAt(++i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(ba[j] | (byte)(k & 0xF));
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ++j;
        }
        return ba;
    }

    static {
        upp = null;
        ssl_enabled = true;
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

