/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.login;

import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.management.services.common.Debug;
import com.sun.web.console.login.LoginControlBean;
import com.sun.webui.jsf.model.Option;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

public class RoleLoginBean
implements Serializable {
    public static final String NO_ROLE_KEY = "no_role";
    private static final String BASE_NAME = "com.sun.web.console.resources.RoleResources";
    private String serverName;
    private String userName;
    private String roleName = null;
    private String password = null;
    private Option[] roleOptions = null;
    private UIInput roleDropdown;
    private UIInput passwordField;
    private PasswordCredential pc = null;

    public String getServerName() {
        try {
            this.serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.serverName = "localhost";
        }
        return this.serverName;
    }

    public String getUserName() {
        try {
            UserDataObject userDataObject = (UserDataObject)LoginControlBean.readLoginData();
            return userDataObject.getUser();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        try {
            this.pc = new PasswordCredential(string);
            UserDataObject userDataObject = (UserDataObject)LoginControlBean.readLoginData();
            userDataObject.setRoleCredential(this.pc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.password = "";
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        try {
            UserDataObject userDataObject = (UserDataObject)LoginControlBean.readLoginData();
            if (string == null || string.equals(NO_ROLE_KEY)) {
                userDataObject.setRole("**NOROLE**");
            } else {
                userDataObject.setRole(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.roleName = string;
    }

    public Option[] getRoleOptions() {
        Object object;
        String[] stringArray = null;
        try {
            object = (UserDataObject)LoginControlBean.readLoginData();
            stringArray = object.getRolelist();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Locale locale = facesContext.getViewRoot().getLocale();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(BASE_NAME, locale);
            object = resourceBundle.getString(NO_ROLE_KEY);
        }
        catch (Exception exception) {
            Debug.trace3((String)("Couldn't get localized label for no role:: " + exception));
        }
        this.roleOptions = stringArray != null && stringArray.length > 0 ? new Option[stringArray.length + 1] : new Option[1];
        this.roleOptions[0] = new Option((Object)NO_ROLE_KEY, (String)object);
        for (int i = 1; i < this.roleOptions.length; ++i) {
            this.roleOptions[i] = new Option((Object)stringArray[i - 1], stringArray[i - 1]);
        }
        return this.roleOptions;
    }

    public UIInput getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(UIInput uIInput) {
        this.passwordField = uIInput;
    }

    public UIInput getRoleDropdown() {
        return this.roleDropdown;
    }

    public void setRoleDropdown(UIInput uIInput) {
        this.roleDropdown = uIInput;
    }

    public void validateData(FacesContext facesContext, UIComponent uIComponent, Object object) {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        try {
            string = this.roleDropdown.getLocalValue().toString();
            string2 = this.passwordField.getLocalValue().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FacesMessage facesMessage = new FacesMessage();
        LoginControlBean loginControlBean = new LoginControlBean();
        if (!this.isValidData(string2)) {
            bl = true;
        }
        if (string == null || string.equals(NO_ROLE_KEY)) {
            bl2 = true;
        }
        if (bl && !bl2) {
            String[] stringArray = new String[]{""};
            loginControlBean.createLoginError("auth_failed_summary", "auth_failed_detail", "error", stringArray);
            throw new ValidatorException(facesMessage);
        }
    }

    private boolean isValidData(String string) {
        return string != null && string.trim().length() != 0;
    }
}

