/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.launch;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.Category;
import com.sun.management.services.registration.CategoryApp;
import com.sun.management.services.registration.CategoryElement;
import com.sun.management.services.registration.CategoryUtility;
import com.sun.management.services.registration.RegistrationUtil;
import com.sun.webui.jsf.component.Alert;
import com.sun.webui.jsf.component.Bubble;
import com.sun.webui.jsf.component.CommonTask;
import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.CommonTasksSection;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.Markup;
import com.sun.webui.jsf.component.StaticText;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LaunchControlBean
implements Serializable {
    private static final String COMMON_TASK_ACTION_FACET = "taskAction";
    private static final String LAUNCH_FORM_ID = "form1";
    private static final String LAUNCH_CTS_ID = "cts_1";
    private static final String LAUNCH_CTS_TITLE = "launch_cts_title";
    private static final String LAUNCH_ALERT_ID = "alert_1";
    private static final String LAUNCH_GROUP_IDBASE = "group_";
    private static final String LAUNCH_TASK_IDBASE = "task_";
    private static final String LAUNCH_TASK_LINK_IDBASE = "task_link_";
    private static final String LAUNCH_TASK_LINK_ONCLICK = "setTarget(this);";
    private static final String LAUNCH_BUBBLES_ID = "bubbles";
    private static final String LAUNCH_BUBBLE_IDBASE = "bubble_";
    private static final String LAUNCH_NOAPPS_IDBASE = "noapp_";
    private static final int CTS_NUM_COLUMNS = 2;
    private static final String CONSOLE_BUNDLE = "com.sun.web.console.resources.Resources";
    private static final String CATEGORY_ELEMENTS = "launch_page_category_elements";
    private static final String CATEGORY_LOCALE = "launch_page_category_locale";
    private static final String CATEGORY_TIME = "reginfo_cache_time";
    private static final String LAUNCH_NEW_WINDOW = "launch_in_new_window";
    private static final String LAUNCH_ACTION_HANDLER_EXPRESSION = "#{launchControlBean.taskAction}";
    private static final String LAUNCH_ACTION_LISTENER_EXPRESSION = "#{launchControlBean.taskListener}";
    private static final String LAUNCH_NOAPPS_TEXT = "launch_empty_group";
    private static final String LAUNCH_ERROR = "launch_error";
    private static final String LAUNCH_NO_APPS = "launch_no_apps";
    private static final String LAUNCH_MISS_ID = "launch_miss_id";
    private static final String LAUNCH_MISS_APP = "launch_miss_app";
    private static final String LAUNCH_BAD_URL = "launch_bad_url";
    private static final String LAUNCH_REDIRECT_ERR = "launch_redirect_err";
    private CommonTasksSection cts = null;
    private Alert alert = null;
    private ArrayList bubble_info = null;
    private Locale locale = null;
    private String action_id = null;
    private String action_name = null;
    private String link_prefix = null;
    private boolean winchk = false;
    private Subject subject = null;
    private boolean bRedoL10N = false;

    public LaunchControlBean() {
        Object object;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(true);
        this.subject = null;
        try {
            object = SSOTokenManager.getInstance();
            SSOToken sSOToken = object.createSSOToken(httpServletRequest);
            this.subject = sSOToken.getSubject();
        }
        catch (Exception exception) {
            Debug.trace1((String)"Error retrieving subject", (Throwable)exception);
        }
        this.link_prefix = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort();
        this.winchk = false;
        try {
            object = (Boolean)httpSession.getAttribute(LAUNCH_NEW_WINDOW);
            if (object != null) {
                this.winchk = (Boolean)object;
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error reading checkbox attribute: " + exception.getMessage()));
        }
    }

    public CommonTasksSection getTasks() {
        return this.cts;
    }

    public void setTasks(CommonTasksSection commonTasksSection) {
        this.cts = commonTasksSection;
        if (this.cts == null) {
            this.cts = new CommonTasksSection();
        }
        this.initLocale();
        this.initCommonTasksSection();
        this.bubble_info = new ArrayList();
        try {
            CategoryElement[] categoryElementArray = this.getCategoryData(this.subject);
            this.populateCommonTasks(categoryElementArray);
        }
        catch (Exception exception) {
            Debug.trace1((String)"Error building cts components", (Throwable)exception);
        }
    }

    public Alert getAlert() {
        return this.alert;
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
        if (this.alert == null) {
            this.alert = new Alert();
        }
        this.initLocale();
        this.initAlert();
    }

    public UIComponent getBubbles() {
        Markup markup = new Markup();
        markup.setTag("div");
        for (int i = 0; i < this.bubble_info.size(); ++i) {
            String[] stringArray = (String[])this.bubble_info.get(i);
            Bubble bubble = new Bubble();
            bubble.setId(LAUNCH_BUBBLE_IDBASE + stringArray[0]);
            bubble.setTitle(stringArray[1]);
            bubble.setAutoClose(true);
            markup.getChildren().add(bubble);
            StaticText staticText = new StaticText();
            staticText.setId(LAUNCH_BUBBLE_IDBASE + stringArray[0] + "_text");
            staticText.setText((Object)stringArray[2]);
            bubble.getChildren().add(staticText);
        }
        return markup;
    }

    public void setBubbles(UIComponent uIComponent) {
    }

    public boolean getCheckSelected() {
        return this.winchk;
    }

    public void setCheckSelected(boolean bl) {
        this.winchk = bl;
        this.saveCheckValue(this.winchk);
    }

    public boolean isCheckSelected() {
        return this.winchk;
    }

    private void initCommonTasksSection() {
        this.cts.setId(LAUNCH_CTS_ID);
        this.cts.setTitle(this.getConsoleMessage(LAUNCH_CTS_TITLE));
        this.cts.setColumns(2);
        this.cts.setRendered(true);
        this.cts.setVisible(true);
        StaticText staticText = new StaticText();
        staticText.setId("cts_1_help");
        staticText.setText((Object)"");
        staticText.setRendered(false);
        staticText.setVisible(false);
        this.cts.getFacets().put("help", staticText);
    }

    private void initAlert() {
        this.alert.setId(LAUNCH_ALERT_ID);
        this.alert.setVisible(false);
    }

    private StaticText createNoappText(int n) {
        StaticText staticText = new StaticText();
        staticText.setId(LAUNCH_NOAPPS_IDBASE + n);
        staticText.setText((Object)this.getConsoleMessage(LAUNCH_NOAPPS_TEXT));
        return staticText;
    }

    private CommonTasksGroup createTaskGroup(CategoryElement categoryElement) {
        CommonTasksGroup commonTasksGroup = new CommonTasksGroup();
        commonTasksGroup.setId(LAUNCH_GROUP_IDBASE + ((Category)categoryElement).getOrderNumber());
        commonTasksGroup.setTitle(this.getDisplayName(categoryElement));
        commonTasksGroup.setVisible(true);
        commonTasksGroup.setRendered(true);
        return commonTasksGroup;
    }

    private CommonTask createTask(CategoryElement categoryElement) {
        CommonTask commonTask = new CommonTask();
        commonTask.setId(LAUNCH_TASK_IDBASE + categoryElement.getName());
        Hyperlink hyperlink = this.createTaskLink(categoryElement);
        commonTask.getFacets().put(COMMON_TASK_ACTION_FACET, hyperlink);
        String string = this.getDisplayDesc(categoryElement);
        if (string != null && string.length() > 0) {
            commonTask.setInfoText(string);
        }
        commonTask.setTitle(null);
        commonTask.setVisible(true);
        return commonTask;
    }

    private Hyperlink createTaskLink(CategoryElement categoryElement) {
        Hyperlink hyperlink = new Hyperlink();
        String string = categoryElement.getName();
        String string2 = this.getDisplayName(categoryElement);
        hyperlink.setVisible(true);
        hyperlink.setId(LAUNCH_TASK_LINK_IDBASE + string);
        String string3 = this.link_prefix + ((CategoryApp)categoryElement).getUrl();
        hyperlink.setUrl(string3);
        hyperlink.setText((Object)string2);
        if (this.winchk) {
            hyperlink.setTarget("_blank");
        } else {
            hyperlink.setTarget("_self");
        }
        hyperlink.setOnClick(LAUNCH_TASK_LINK_ONCLICK);
        String string4 = this.getDisplayDesc(categoryElement);
        if (string4 != null && string4.trim().length() > 0) {
            String[] stringArray = new String[]{string, string2, string4};
            this.bubble_info.add(stringArray);
            String string5 = "form1:bubble_" + string;
            String string6 = "document.getElementById('" + string5 + "').open(event);";
            hyperlink.setOnMouseOver(string6);
            string6 = "document.getElementById('" + string5 + "').close();";
            hyperlink.setOnMouseOut(string6);
        }
        return hyperlink;
    }

    private void populateCommonTasks(CategoryElement[] categoryElementArray) {
        int n;
        this.initLocale();
        int n2 = categoryElementArray.length;
        if (n2 == 0) {
            this.setError(LAUNCH_ERROR, LAUNCH_NO_APPS);
            return;
        }
        Arrays.sort(categoryElementArray, new CatComparator());
        CommonTasksGroup[] commonTasksGroupArray = new CommonTasksGroup[n2];
        this.cts.getChildren().clear();
        for (n = 0; n < n2; ++n) {
            try {
                CommonTasksGroup commonTasksGroup = this.createTaskGroup(categoryElementArray[n]);
                this.cts.getChildren().add(commonTasksGroup);
                commonTasksGroupArray[n] = commonTasksGroup;
                continue;
            }
            catch (Exception exception) {
                Debug.trace1((String)("Error adding group: " + exception.getMessage()));
            }
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            Markup markup;
            Markup markup2;
            CommonTasksGroup commonTasksGroup = commonTasksGroupArray[i];
            commonTasksGroup.getChildren().clear();
            CategoryElement[] categoryElementArray2 = categoryElementArray[i].getElements();
            Markup markup3 = new Markup();
            markup3.setTag("table");
            commonTasksGroup.getChildren().add(markup3);
            if (categoryElementArray2 == null || categoryElementArray2.length == 0) {
                Markup markup4 = new Markup();
                markup4.setTag("tr");
                markup3.getChildren().add(markup4);
                markup2 = new Markup();
                markup2.setTag("td");
                markup4.getChildren().add(markup2);
                markup = this.createNoappText(i);
                markup2.getChildren().add(markup);
                continue;
            }
            for (int j = 0; j < categoryElementArray2.length; ++j) {
                try {
                    markup2 = new Markup();
                    markup2.setTag("tr");
                    markup3.getChildren().add(markup2);
                    markup = new Markup();
                    markup.setTag("td");
                    markup2.getChildren().add(markup);
                    Hyperlink hyperlink = this.createTaskLink(categoryElementArray2[j]);
                    markup.getChildren().add(hyperlink);
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    Debug.trace1((String)("Error adding task: " + exception.getMessage()));
                }
            }
        }
        if (n == 0) {
            this.setError(LAUNCH_ERROR, LAUNCH_NO_APPS);
        }
    }

    private MethodExpression createActionHandler(FacesContext facesContext) {
        MethodExpression methodExpression = null;
        try {
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            ELContext eLContext = facesContext.getELContext();
            Class clazz = String.class;
            Class[] classArray = new Class[]{};
            methodExpression = expressionFactory.createMethodExpression(eLContext, LAUNCH_ACTION_HANDLER_EXPRESSION, clazz, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodExpression;
    }

    private MethodExpression createActionListener(FacesContext facesContext) {
        MethodExpression methodExpression = null;
        try {
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            ELContext eLContext = facesContext.getELContext();
            Class[] classArray = new Class[]{ActionEvent.class};
            methodExpression = expressionFactory.createMethodExpression(eLContext, LAUNCH_ACTION_LISTENER_EXPRESSION, null, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodExpression;
    }

    private void setError(String string, String string2) {
        this.setError(string, string2, null, null, null);
    }

    private void setError(String string, String string2, String string3) {
        this.setError(string, string2, string3, null, null);
    }

    private void setError(String string, String string2, String string3, String string4) {
        this.setError(string, string2, string3, string4, null);
    }

    private void setError(String string, String string2, String string3, String string4, String string5) {
        String string6 = this.getConsoleMessage(string);
        Object[] objectArray = new String[]{string3, string4, string5};
        String string7 = this.getConsoleMessage(string2, objectArray);
        if (this.alert == null) {
            this.alert = new Alert();
            this.initAlert();
        }
        this.alert.setType("error");
        this.alert.setSummary(string6);
        this.alert.setDetail(string7);
        this.alert.setVisible(true);
    }

    private CategoryElement[] getCategoryData(Subject subject) {
        long l;
        long l2;
        Long l3;
        CategoryElement[] categoryElementArray;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpSession httpSession = (HttpSession)externalContext.getSession(false);
        this.bRedoL10N = false;
        Locale locale = (Locale)httpSession.getAttribute(CATEGORY_LOCALE);
        if (locale == null || locale != this.locale) {
            this.bRedoL10N = true;
            httpSession.setAttribute(CATEGORY_LOCALE, (Object)this.locale);
        }
        if ((categoryElementArray = (CategoryElement[])httpSession.getAttribute(CATEGORY_ELEMENTS)) != null && (l3 = (Long)httpSession.getAttribute(CATEGORY_TIME)) != null && (l2 = l3.longValue()) < (l = CategoryUtility.getRegistrationTimestamp())) {
            categoryElementArray = null;
        }
        if (categoryElementArray == null) {
            categoryElementArray = CategoryUtility.getCategorizedApplications((Subject)subject);
            long l4 = CategoryUtility.getRegistrationTimestamp();
            httpSession.setAttribute(CATEGORY_ELEMENTS, (Object)categoryElementArray);
            httpSession.setAttribute(CATEGORY_TIME, (Object)new Long(l4));
            this.bRedoL10N = true;
        }
        return categoryElementArray;
    }

    private void saveCheckValue(boolean bl) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            Boolean bl2 = new Boolean(bl);
            httpSession.setAttribute(LAUNCH_NEW_WINDOW, (Object)bl2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDisplayName(CategoryElement categoryElement) {
        String string = categoryElement.getName();
        if (!this.bRedoL10N) {
            String string2 = categoryElement.getLocalizedName();
            if (string2 == null || string2.equals("")) {
                return string;
            }
            return string2;
        }
        String string3 = categoryElement.getNameKey();
        if (categoryElement instanceof Category) {
            String string4 = this.getConsoleMessage(string3);
            if (!string4.equals(string3)) {
                string = string4;
            }
        } else if (categoryElement instanceof CategoryApp) {
            CategoryApp categoryApp = (CategoryApp)categoryElement;
            if (categoryApp.isNameLocalizable()) {
                ClassLoader classLoader = RegistrationUtil.getAppLoader((String)categoryApp.getPluginName());
                String string5 = categoryApp.getBundleName();
                string = this.getMessage(string3, string5, classLoader);
            } else {
                string = string3;
            }
        }
        categoryElement.setLocalizedName(string);
        return string;
    }

    private String getDisplayDesc(CategoryElement categoryElement) {
        CategoryApp categoryApp = (CategoryApp)categoryElement;
        String string = null;
        String string2 = categoryApp.getDescKey();
        if (string2 != null && string2.length() > 0) {
            string = string2;
            if (categoryApp.isDescLocalizable()) {
                string = categoryApp.getLocalizedDesc();
                if (this.bRedoL10N) {
                    ClassLoader classLoader = RegistrationUtil.getAppLoader((String)categoryApp.getPluginName());
                    String string3 = categoryApp.getBundleName();
                    string = this.getMessage(string2, string3, classLoader);
                    categoryApp.setLocalizedDesc(string);
                }
            }
        }
        return string;
    }

    private String getTooltip(CategoryElement categoryElement) {
        String string;
        String string2 = categoryElement.getName();
        if (!this.bRedoL10N) {
            String string3 = categoryElement.getLocalizedTooltip();
            if (string3 == null || string3.equals("")) {
                return string2;
            }
            return string3;
        }
        String string4 = categoryElement.getTooltipKey();
        if (categoryElement instanceof Category && !(string = this.getConsoleMessage(string4)).equals(string4)) {
            string2 = string;
        }
        categoryElement.setLocalizedTooltip(string2);
        return string2;
    }

    private String getURL(CategoryElement categoryElement) {
        String string = null;
        try {
            CategoryApp categoryApp = (CategoryApp)categoryElement;
            string = categoryApp.getUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getConsoleMessage(String string) {
        return this.getConsoleMessage(string, null);
    }

    private String getConsoleMessage(String string, Object[] objectArray) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string2 = this.getMessage(string, CONSOLE_BUNDLE, classLoader);
        if (objectArray != null && objectArray.length > 0) {
            String string3 = null;
            try {
                MessageFormat messageFormat = new MessageFormat(string2);
                string3 = messageFormat.format(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 != null) {
                string2 = string3;
            }
        }
        return string2;
    }

    private String getMessage(String string, String string2, ClassLoader classLoader) {
        String string3 = string;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, this.locale, classLoader);
            string3 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
        }
        return string3;
    }

    private void initLocale() {
        this.locale = null;
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.locale = facesContext.getViewRoot().getLocale();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    class CatComparator
    implements Comparator {
        CatComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n2 = category.getOrderNumber();
            if (n2 > (n = category2.getOrderNumber())) {
                return 1;
            }
            if (n > n2) {
                return -1;
            }
            return 0;
        }
    }
}

