/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeImage;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONException;
import org.json.JSONObject;

public class ImageRenderer
extends RendererBase {
    private static final String[] stringAttributes = new String[]{"align", "dir", "longDesc", "onBlur", "onClick", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove"};
    private static final String[] intAttributes = new String[]{"tabIndex", "hspace", "vspace", "border"};

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws JSONException, IOException {
        String styleclass;
        if (!(component instanceof ImageComponent)) {
            throw new IllegalArgumentException("ImageRenderer can only render ImageComponent components.");
        }
        ImageComponent image = (ImageComponent)component;
        String url = image.getUrl();
        String icon = image.getIcon();
        String alt = image.getAlt();
        int height = image.getHeight();
        int width = image.getWidth();
        boolean urlFlag = false;
        if (icon != null && icon.length() > 0 && (url == null || url.length() == 0)) {
            ThemeImage themeImage = this.getTheme().getImage(icon);
            url = themeImage.getPath();
            int dim = themeImage.getHeight();
            if (height < 0 && dim >= 0) {
                height = dim;
            }
            dim = themeImage.getWidth();
            if (width < 0 && dim >= 0) {
                width = dim;
            }
            String iconAlt = themeImage.getAlt();
            if (alt == null) {
                alt = iconAlt;
            }
        } else if (url == null || url.length() == 0) {
            if (LogUtil.warningEnabled(ImageRenderer.class)) {
                LogUtil.warning(ImageRenderer.class, " No image was specified and generally should be");
            }
        } else if (!(image instanceof Icon)) {
            url = context.getApplication().getViewHandler().getResourceURL(context, url);
            urlFlag = true;
        }
        url = url != null && url.trim().length() != 0 ? context.getExternalContext().encodeResourceURL(url) : "";
        url = WidgetUtilities.translateURL(context, (UIComponent)image, url);
        String style = image.getStyle();
        JSONObject json = new JSONObject();
        json.put("visible", image.isVisible()).put("alt", (Object)alt).put("title", (Object)image.getToolTip());
        if (!urlFlag) {
            json.put("icon", (Object)icon);
        }
        if (this.isPngAndIE(context, url)) {
            this.setPngProperties(json, width, height, this.getTheme(), style, url);
        } else {
            json.put("src", (Object)url).put("style", (Object)style);
        }
        if (width > 0) {
            json.put("width", width);
        }
        if (height > 0) {
            json.put("height", height);
        }
        if ((styleclass = image.getStyleClass()) != null && styleclass.length() > 0) {
            json.put("className", (Object)styleclass);
        }
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.image");
    }

    protected void setPngProperties(JSONObject json, int width, int height, Theme theme, String style, String url) throws JSONException, IOException {
        String imgHeight = null;
        String imgWidth = null;
        imgWidth = width >= 0 ? Integer.toString(width) : theme.getMessage("Image.defaultWidth");
        imgHeight = height >= 0 ? Integer.toString(height) : theme.getMessage("Image.defaultHeight");
        String IEStyle = theme.getMessage("Image.IEPngCSSStyleQuirk", new String[]{imgWidth, imgHeight, url});
        url = theme.getImagePath("DOT");
        style = style == null ? IEStyle : IEStyle + style;
        json.put("style", (Object)style);
        json.put("src", (Object)url);
    }

    private boolean isPngAndIE(FacesContext context, String url) {
        ClientSniffer cs = ClientSniffer.getInstance(context);
        if (!cs.isIe() || cs.isIe7up()) {
            return false;
        }
        return url.indexOf("sessionid") != -1 ? url.substring(0, url.indexOf(59)).endsWith(".png") : url.endsWith(".png");
    }
}

