/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.CommonTasksSection;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTasksGroupRenderer
extends AbstractRenderer {
    private static final String TITLE_SPAN = "_groupTitle";
    public static final String GROUP_TITLE = "commonTasks.groupTitle";
    public static final String SKIP_GROUP = "commonTasks.skipTagAltText";
    private static final String SKIP_TASKSGROUP = "skipGroup";

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        CommonTasksGroup ctg = (CommonTasksGroup)component;
        if (!ctg.isRendered()) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String title = ctg.getTitle();
        if (title == null) {
            title = theme.getMessage(GROUP_TITLE);
            ctg.setTitle(title);
        }
        writer.startElement("div", (UIComponent)ctg);
        writer.writeAttribute("id", (Object)ctg.getClientId(context), "id");
        String styles = RenderingUtilities.getStyleClasses(context, (UIComponent)ctg, theme.getStyleClass("CTS_GROUP"));
        if (styles != null) {
            writer.writeAttribute("class", (Object)styles, "class");
        }
        if (ctg.getStyle() != null) {
            writer.writeAttribute("style", (Object)ctg.getStyle(), "style");
        }
        StringBuffer jsBuffer = new StringBuffer();
        this.renderTaskGroupHeader(title, writer, context, (UIComponent)ctg, theme);
        if (!(ctg.getParent() instanceof CommonTasksSection)) {
            this.renderJavascriptImages(theme, writer, (UIComponent)ctg, context);
        }
        for (UIComponent comp : ctg.getChildren()) {
            RenderingUtilities.renderComponent(comp, context);
        }
        writer.endElement("div");
    }

    protected void renderJavascriptImages(Theme theme, ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        block2: {
            StringBuffer buff = new StringBuffer();
            try {
                JSONObject json = this.getJSONProperties(context, theme, component);
                buff.append(JavaScriptUtilities.getModule("commonTasksSection")).append(JavaScriptUtilities.getModuleName("commonTasksSection.init(")).append(JSONUtilities.getString(json)).append(");\n");
                JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), true);
            }
            catch (JSONException e) {
                if (!LogUtil.fineEnabled()) break block2;
                LogUtil.fine(e.getStackTrace().toString());
            }
        }
    }

    protected JSONObject getJSONProperties(FacesContext context, Theme theme, UIComponent component) throws IOException, JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)component.getClientId(context));
        String url = theme.getImagePath("CTS_RIGHT_TOGGLE_SELECTED");
        json.put("pic1URL", (Object)url);
        url = theme.getImagePath("CTS_RIGHT_TOGGLE_OVER");
        json.put("pic2URL", (Object)url);
        url = theme.getImagePath("CTS_RIGHT_TOGGLE");
        json.put("pic3URL", (Object)url);
        return json;
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderTaskGroupHeader(String header, ResponseWriter writer, FacesContext context, UIComponent component, Theme theme) throws IOException {
        StaticText st = new StaticText();
        st.setParent(component);
        st.setId(TITLE_SPAN);
        st.setStyleClass(theme.getStyleClass("CTS_HEADER"));
        st.setText(header);
        RenderingUtilities.renderComponent((UIComponent)st, context);
    }

    public boolean getRendersChildren() {
        return true;
    }
}

