/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.CommonTask;
import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.CommonTasksSection;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.component.util.Util;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTaskRenderer
extends AbstractRenderer {
    private static final String[] integerAttributes = new String[]{"tabIndex"};
    private static final String INFO_IMAGE_TOOLTIP = "commonTasks.infoImageTooltip";
    private static final String CLOSE_IMAGE_TOOLTIP = "commonTasks.closeImageTooltip";
    private static final String OVERVIEW_IMAGE_TOOLTIP = "commonTasks.overviewImageTooltip";
    private static final String[] stringAttributes = new String[]{"onBlur", "onFocus", "onDblClick", "onKeyDown", "onKeyPress", "onMouseUp", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String TOGGLE_IMAGE = "_toggleImg";
    private static final String CLOSE_IMAGE = "_closeImg";
    private static final String SPACER_IMAGE = "_spacerImg";
    private static final String INFO_DIV = "_info";
    private static final String INFO_TITLE = "_infoTitle";
    private static final String INFO_TEXT = "_infoText";
    private static final String COMMONTASK_LINK = "_link";
    private static final String INFO_DIV_LINK = "_infoLinkDiv";
    private static final String HREF_LINK = "_linkImage";
    private static final String LEFT_BOTTOM = "_leftBottom_";
    private static final String LEFT_TOP = "_leftTop_";
    private static final String RIGHT_BOTTOM = "_rightBottom_";
    private static final String RIGHT_TOP = "_rightTop_";
    private static final String RIGHT_BORDER = "_rightBorder_";
    private static final String LINK_TEXT = "_linkText_";
    private ImageHyperlink ihk;
    private Icon spacer;

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        CommonTask task = (CommonTask)component;
        boolean info = false;
        if (!task.isRendered()) {
            return;
        }
        if (!(task.getParent() instanceof CommonTasksGroup) && !(task.getParent() instanceof CommonTasksSection)) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        Object comp = task.getTaskAction();
        String compId = task.getClientId(context);
        writer.startElement("div", (UIComponent)task);
        writer.writeAttribute("id", (Object)task.getClientId(context), "id");
        String styles = RenderingUtilities.getStyleClasses(context, (UIComponent)task, theme.getStyleClass("CTS_TASK"));
        writer.writeAttribute("class", (Object)styles, "class");
        styles = task.getStyle();
        if (styles != null) {
            writer.writeAttribute("style", (Object)styles, "style");
        }
        writer.startElement("table", (UIComponent)task);
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_BACKGROUND"), "class");
        writer.startElement("tr", component);
        if (comp == null) {
            comp = task;
        }
        this.renderActionItem((UIComponent)comp, (UIComponent)task, context, theme, writer);
        String infoText = task.getInfoText();
        String infoTitle = task.getInfoTitle();
        UIComponent facet = task.getInfoPanel();
        if (facet != null || infoText != null || infoTitle != null) {
            this.renderInfoIcon((UIComponent)task, theme, context, writer);
            writer.endElement("tr");
            writer.endElement("table");
            writer.startElement("table", (UIComponent)task);
            writer.writeAttribute("border", (Object)"0", "border");
            writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
            writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
            this.renderInfoText(task, theme, context, writer, infoText, infoTitle, facet);
        } else {
            this.renderPlaceHolderImage((UIComponent)task, theme, context, writer);
        }
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void renderActionItem(UIComponent component, UIComponent task, FacesContext context, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("td", component);
        writer.writeAttribute("width", (Object)"2%", "width");
        writer.writeAttribute("valign", (Object)"bottom", "valign");
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_LEFT"), null);
        this.spacer = ThemeUtilities.getIcon(theme, "CTS_SPACER_IMAGE");
        this.spacer.setParent(task);
        this.spacer.setId(SPACER_IMAGE);
        RenderingUtilities.renderComponent((UIComponent)this.spacer, context);
        writer.endElement("td");
        writer.startElement("td", component);
        writer.writeAttribute("width", (Object)"100%", "width");
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_CENTER"), "class");
        if (component instanceof CommonTask) {
            this.renderDefaultTaskAction((CommonTask)component, writer, context, theme);
        } else {
            RenderingUtilities.renderComponent(component, context);
        }
        writer.endElement("td");
    }

    protected void renderPlaceHolderImage(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("td", component);
        writer.writeAttribute("width", (Object)"3%", "width");
        writer.writeAttribute("align", (Object)"right", "align");
        writer.writeAttribute("valign", (Object)"top", "valign");
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_RIGHT"), "class");
        String themeIcon = "CTS_RIGHT_TOGGLE_EMPTY";
        Icon icon = ThemeUtilities.getIcon(theme, themeIcon);
        icon.setParent(component);
        icon.setId(TOGGLE_IMAGE);
        RenderingUtilities.renderComponent((UIComponent)icon, context);
        writer.endElement("td");
    }

    protected void renderInfoIcon(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("td", component);
        writer.writeAttribute("width", (Object)"3%", "width");
        writer.writeAttribute("align", (Object)"right", "align");
        writer.writeAttribute("valign", (Object)"top", "valign");
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_RIGHT"), "class");
        this.ihk = new ImageHyperlink();
        String themeIcon = null;
        themeIcon = "CTS_RIGHT_TOGGLE";
        this.ihk.setId(TOGGLE_IMAGE);
        this.ihk.setTabIndex((Integer)component.getAttributes().get("tabIndex"));
        this.ihk.setIcon(themeIcon);
        this.ihk.setParent(component);
        this.ihk.setToolTip(theme.getMessage(INFO_IMAGE_TOOLTIP));
        RenderingUtilities.renderComponent((UIComponent)this.ihk, context);
        writer.endElement("td");
    }

    protected void renderInfoText(CommonTask task, Theme theme, FacesContext context, ResponseWriter writer, String infoText, String infoTitle, UIComponent facet) throws IOException {
        writer.startElement("tr", (UIComponent)task);
        writer.startElement("td", (UIComponent)task);
        ImageHyperlink close = new ImageHyperlink();
        writer.startElement("div", (UIComponent)task);
        writer.writeAttribute("id", (Object)(task.getClientId(context) + INFO_DIV), "id");
        StringBuffer sb = new StringBuffer();
        writer.writeAttribute("class", (Object)(theme.getStyleClass("CTS_TASK_INFOPANEL") + " " + theme.getStyleClass("HIDDEN")), "class");
        writer.startElement("div", (UIComponent)task);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_INFOPANEL_CLOSE"), "class");
        close.setParent((UIComponent)task);
        close.setId(CLOSE_IMAGE);
        close.setTabIndex(task.getTabIndex());
        close.setToolTip(theme.getMessage(CLOSE_IMAGE_TOOLTIP));
        if (close.getParent() == null) {
            close.setParent((UIComponent)task);
        }
        close.setIcon("CTS_PANEL_CLOSE");
        RenderingUtilities.renderComponent((UIComponent)close, context);
        writer.endElement("div");
        writer.startElement("p", (UIComponent)task);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_INFO"), "class");
        if (facet == null) {
            writer.startElement("span", (UIComponent)task);
            writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_HEADER"), "class");
            if (infoTitle != null) {
                writer.writeText((Object)infoTitle, null);
            }
            writer.endElement("span");
            writer.startElement("span", (UIComponent)task);
            writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_CONTENT"), "class");
            if (infoText != null) {
                writer.writeText((Object)infoText, null);
            }
            writer.endElement("span");
        } else {
            RenderingUtilities.renderComponent(facet, context);
        }
        writer.endElement("p");
        facet = task.getInfoLink();
        if (facet != null) {
            this.renderBottomInfoPanel((UIComponent)task, facet, writer, theme, context);
        }
        writer.endElement("div");
        sb = new StringBuffer();
        UIComponent section = task.getParent();
        if (section instanceof CommonTasksGroup && section.getParent() instanceof CommonTasksSection) {
            section = section.getParent();
        }
        try {
            JSONObject json = null;
            json = facet != null ? this.getJSONProperties(context, theme, (UIComponent)task, close, section, facet) : this.getJSONProperties(context, theme, (UIComponent)task, close, section);
            sb.append(JavaScriptUtilities.getDomNode(context, section)).append(".addCommonTask(").append(JSONUtilities.getString(json)).append(");\n");
            JavaScriptUtilities.renderJavaScript((UIComponent)task, writer, sb.toString(), true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        writer.endElement("td");
    }

    protected void renderBottomInfoPanel(UIComponent task, UIComponent facet, ResponseWriter writer, Theme theme, FacesContext context) throws IOException {
        writer.startElement("p", task);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TASK_MORE"), "class");
        Icon ic = new Icon();
        ic = ThemeUtilities.getIcon(theme, "HREF_LINK");
        ic.setBorder(0);
        ic.setParent(task);
        ic.setId(task.getId() + HREF_LINK);
        RenderingUtilities.renderComponent((UIComponent)ic, context);
        RenderingUtilities.renderComponent(facet, context);
        writer.endElement("p");
    }

    protected JSONObject getJSONProperties(FacesContext context, Theme theme, UIComponent component, ImageHyperlink close, UIComponent section, UIComponent bottomInfoPanel) throws IOException, JSONException {
        JSONObject json = this.getJSONProperties(context, theme, component, close, section);
        json.put("bottomInfoLink", (Object)bottomInfoPanel.getClientId(context));
        return json;
    }

    protected JSONObject getJSONProperties(FacesContext context, Theme theme, UIComponent component, ImageHyperlink close, UIComponent section) throws IOException, JSONException {
        StringBuffer tmp = new StringBuffer();
        tmp.append(this.ihk.getClientId(context)).append(":").append(this.ihk.getId()).append("_image");
        JSONObject json = new JSONObject();
        json.put("commonTaskId", (Object)component.getClientId(context)).put("closeId", (Object)close.getClientId(context)).put("spacerId", (Object)SPACER_IMAGE).put("infoIconId", (Object)tmp.toString()).put("infoPanelVar", (Object)INFO_DIV).put("imageLinkId", (Object)this.ihk.getClientId(context));
        return json;
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderDefaultTaskAction(CommonTask task, ResponseWriter writer, FacesContext context, Theme theme) throws IOException {
        String text;
        String onclick = task.getOnClick();
        String target = task.getTarget();
        String tooltip = task.getToolTip();
        writer.startElement("a", (UIComponent)task);
        writer.writeAttribute("id", (Object)(task.getClientId(context) + COMMONTASK_LINK), "id");
        this.addIntegerAttributes(context, (UIComponent)task, writer, integerAttributes);
        UIComponent form = Util.getForm(context, (UIComponent)task);
        if (form != null) {
            String formClientId = form.getClientId(context);
            StringBuffer buff = new StringBuffer(200);
            if (onclick != null) {
                buff.append(onclick);
                if (!onclick.endsWith(";")) {
                    buff.append(";");
                }
            }
            buff.append("return ").append(JavaScriptUtilities.getModuleName("hyperlink.submit")).append("(this, ").append("'").append(formClientId).append("'").append(", ");
            boolean didOnce = false;
            for (UIComponent kid : task.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                if (!didOnce) {
                    buff.append("new Array(");
                }
                String name = (String)kid.getAttributes().get("name");
                String value = (String)kid.getAttributes().get("value");
                if (!didOnce) {
                    buff.append("'");
                } else {
                    buff.append(",'");
                }
                buff.append(name);
                buff.append("','");
                buff.append(value);
                buff.append("'");
                didOnce = true;
            }
            if (!didOnce) {
                buff.append("null");
            } else {
                buff.append(")");
            }
            buff.append(");");
            writer.writeAttribute("onclick", (Object)buff.toString(), null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TEXT_BGROUND"), null);
        }
        if (null != target) {
            writer.writeAttribute("target", (Object)target, null);
        }
        if (null != tooltip) {
            writer.writeAttribute("title", (Object)tooltip, null);
        }
        this.addIntegerAttributes(context, (UIComponent)task, writer, integerAttributes);
        CommonTaskRenderer.addStringAttributes(context, (UIComponent)task, writer, stringAttributes);
        if (!Beans.isDesignTime()) {
            this.renderStyles(task, writer, theme, context);
        }
        ImageComponent img = null;
        String icon = task.getIcon();
        if (icon != null) {
            img = ThemeUtilities.getIcon(theme, icon);
        } else {
            img = new ImageComponent();
            icon = task.getImageUrl();
            if (icon != null) {
                img.setUrl(icon);
                int dim = task.getImageHeight();
                if (dim > 0) {
                    img.setHeight(dim);
                }
                if ((dim = task.getImageWidth()) > 0) {
                    img.setWidth(dim);
                }
            }
        }
        img.setId(task.getId() + "_img");
        img.setToolTip(theme.getMessage(OVERVIEW_IMAGE_TOOLTIP));
        img.setStyleClass(theme.getStyleClass("CTS_TASK_BULLET"));
        writer.startElement("span", (UIComponent)task);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_PADDING"), null);
        writer.writeAttribute("id", (Object)(task.getClientId(context) + LINK_TEXT), null);
        if (img.getUrl() != null) {
            RenderingUtilities.renderComponent((UIComponent)img, context);
        }
        if ((text = ConversionUtilities.convertValueToString((UIComponent)task, task.getText())) != null) {
            writer.writeText((Object)text, null);
        }
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void renderStyles(CommonTask component, ResponseWriter writer, Theme theme, FacesContext context) throws IOException {
        String clientId = component.getClientId(context);
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_LEFT_BOTTOM"), null);
        writer.writeAttribute("id", (Object)(clientId + LEFT_BOTTOM), null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_LEFT_TOP"), null);
        writer.writeAttribute("id", (Object)(clientId + LEFT_TOP), null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_RIGHT_BOTTOM"), null);
        writer.writeAttribute("id", (Object)(clientId + RIGHT_BOTTOM), null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_RIGHT_TOP"), null);
        writer.writeAttribute("id", (Object)(clientId + RIGHT_TOP), null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_RIGHT_BORDER"), null);
        writer.writeAttribute("id", (Object)(clientId + RIGHT_BORDER), null);
        writer.endElement("span");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        CommonTask link = (CommonTask)component;
        StringBuffer paramId = new StringBuffer();
        String clientId = component.getClientId(context);
        paramId.append(clientId).append(COMMONTASK_LINK).append("_submittedLink");
        String value = (String)context.getExternalContext().getRequestParameterMap().get(paramId.toString());
        if (value == null || !value.equals(clientId + COMMONTASK_LINK)) {
            return;
        }
        link.queueEvent((FacesEvent)new ActionEvent((UIComponent)link));
    }
}

