/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Body;
import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.FocusManager;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class BodyRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"onClick", "onDblClick", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onFocus", "onBlur", "onLoad", "onUnload"};
    private static final String[] integerAttributes = new String[]{"tabIndex"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (component instanceof Body && !((Body)component).isPreserveFocus()) {
            return;
        }
        String id = RenderingUtilities.decodeHiddenField(context, "com_sun_webui_util_FocusManager_focusElementId");
        if (id != null && (id = id.trim()).length() != 0) {
            FocusManager.setRequestFocusElementId(context, id);
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (RenderingUtilities.isPortlet(context)) {
            return;
        }
        if (!(component instanceof Body)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Body.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        writer.startElement("body", component);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (RenderingUtilities.isPortlet(context)) {
            return;
        }
        Body body = (Body)component;
        this.addCoreAttributes(context, component, writer, null);
        BodyRenderer.addStringAttributes(context, component, writer, stringAttributes);
        String imageUrl = body.getImageURL();
        if (imageUrl != null && imageUrl.length() > 0) {
            String resourceUrl = context.getApplication().getViewHandler().getResourceURL(context, imageUrl);
            writer.writeAttribute("background", (Object)resourceUrl, null);
        }
        this.addIntegerAttributes(context, component, writer, integerAttributes);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (RenderingUtilities.isPortlet(context)) {
            return;
        }
        Body body = (Body)component;
        String id = body.getClientId(context);
        String viewId = context.getViewRoot().getViewId();
        String urlString = context.getApplication().getViewHandler().getActionURL(context, viewId);
        Theme theme = ThemeUtilities.getTheme(context);
        StringBuffer buff = new StringBuffer(128);
        buff.append("new ").append(JavaScriptUtilities.getModuleName("body")).append("('").append(viewId).append("', '").append(urlString).append("'");
        String fid = this.getFocusElementId(context, body.getFocus());
        buff.append(",");
        if (fid != null && fid.length() != 0) {
            buff.append("'").append(fid).append("'");
        } else {
            buff.append("null");
        }
        String rid = FocusManager.getRequestFocusElementId(context);
        buff.append(",");
        if (rid != null && rid.length() != 0) {
            buff.append("'").append(rid).append("'");
        } else {
            buff.append("null");
        }
        buff.append(",'").append("com_sun_webui_util_FocusManager_focusElementId").append("'");
        buff.append(body.isPreserveScroll() ? ",true" : ",false").append(");");
        JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), true);
        writer.endElement("body");
    }

    protected String getFocusElementId(FacesContext context, String id) {
        block5: {
            if (id == null || id.length() == 0) {
                return null;
            }
            String absid = id;
            if (id.charAt(0) != ':') {
                absid = String.valueOf(':').concat(id);
            }
            try {
                UIComponent comp = context.getViewRoot().findComponent(absid);
                if (comp != null && comp instanceof ComplexComponent) {
                    id = ((ComplexComponent)comp).getFocusElementId(context);
                }
            }
            catch (Exception e) {
                if (!LogUtil.finestEnabled()) break block5;
                LogUtil.finest("BodyRenderer.getFocusElementId: couldn't find component with id " + absid + " rendering focus id as " + id);
            }
        }
        return id;
    }
}

