/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.WebXmlParsedTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlParserHandler
extends DefaultHandler {
    private static final String WEB_APP_DTD_PREFIX = "web-app_";
    private static final String WEB_APP_DTD_SUFFIX = ".dtd";
    private static final String ELEM_WEBAPP = "web-app";
    private static final String ELEM_PARAM_NAME = "param-name";
    private static final String ELEM_PARAM_VALUE = "param-value";
    private static final String ELEM_URL_PATTERN = "url-pattern";
    private static final String ELEM_CONTEXT_PARAM = "context-param";
    private static final String ELEM_INIT_PARAM = "init-param";
    private static final String ELEM_FILTER = "filter";
    private static final String ELEM_FILTER_NAME = "filter-name";
    private static final String ELEM_FILTER_CLASS = "filter-class";
    private static final String ELEM_FILTER_MAPPING = "filter-mapping";
    private static final String ELEM_LISTENER = "listener";
    private static final String ELEM_LISTENER_CLASS = "listener-class";
    private static final String ELEM_SERVLET = "servlet";
    private static final String ELEM_SERVLET_NAME = "servlet-name";
    private static final String ELEM_SERVLET_CLASS = "servlet-class";
    private static final String ELEM_SERVLET_MAPPING = "servlet-mapping";
    private static final String ELEM_TAGLIB = "taglib";
    private static final String ELEM_TAGLIB_URI = "taglib-uri";
    private static final String ELEM_TAGLIB_LOCATION = "taglib-location";
    private HashMap tagmap = new HashMap();
    private String dtdpath = null;
    private String systemId = "(null)";
    private boolean inContextParam = false;
    private boolean inContextParamName = false;
    private boolean inContextParamValue = false;
    private boolean inFilter = false;
    private boolean inFilterName = false;
    private boolean inFilterClass = false;
    private boolean inFilterMapping = false;
    private boolean inFilterUrlPattern = false;
    private boolean inFilterParam = false;
    private boolean inFilterParamName = false;
    private boolean inFilterParamValue = false;
    private boolean inServlet = false;
    private boolean inServletName = false;
    private boolean inServletClass = false;
    private boolean inServletMapping = false;
    private boolean inServletUrlPattern = false;
    private boolean inListener = false;
    private boolean inListenerClass = false;
    private boolean inTaglib = false;
    private boolean inTaglibName = false;
    private boolean inTaglibLocation = false;
    private boolean inIgnoreTag = false;
    private String paramName;
    private String paramValue;
    private int paramOrder;
    private String filterName;
    private String filterClass;
    private String filterUrlPattern;
    private int filterOrder;
    private String servletName;
    private String servletClass;
    private String servletUrlPattern;
    private int servletOrder;
    private String taglibName;
    private String taglibLocation;
    private int taglibOrder;
    private String listenerName;
    private String listenerClass;
    private int listenerOrder;
    private String ignoreTagName;
    private String tagValue;

    public WebXmlParserHandler(String string) {
        this.dtdpath = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public WebXmlParsedTag getParsedTag(String string, String string2) {
        WebXmlParsedTag webXmlParsedTag = this.getTag(string, string2);
        return webXmlParsedTag;
    }

    public WebXmlParsedTag[] getParsedTags(String string) {
        WebXmlParsedTag[] webXmlParsedTagArray = new WebXmlParsedTag[]{};
        if (string != null && string.length() > 0) {
            ArrayList arrayList = this.getTags(string);
            webXmlParsedTagArray = arrayList.toArray(webXmlParsedTagArray);
        }
        return webXmlParsedTagArray;
    }

    public void setDocumentLocator(Locator locator) {
        try {
            this.systemId = locator.getSystemId();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
        this.paramOrder = 0;
        this.filterOrder = 0;
        this.servletOrder = 0;
        this.taglibOrder = 0;
        this.listenerOrder = 0;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2.trim();
        if (string4.length() == 0) {
            string4 = string3.trim();
        }
        if (string4.equalsIgnoreCase(ELEM_WEBAPP)) {
            return;
        }
        this.tagValue = "";
        if (this.inIgnoreTag) {
            return;
        }
        if (string4.equalsIgnoreCase(ELEM_CONTEXT_PARAM)) {
            this.paramName = "";
            this.paramValue = "";
            ++this.paramOrder;
            this.inContextParam = true;
        } else if (string4.equalsIgnoreCase(ELEM_PARAM_NAME)) {
            this.paramName = "";
            if (this.inContextParam) {
                this.inContextParamName = true;
            } else if (this.inFilterParam) {
                this.inFilterParamName = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_PARAM_VALUE)) {
            this.paramValue = "";
            if (this.inContextParam) {
                this.inContextParamValue = true;
            } else if (this.inFilterParam) {
                this.inFilterParamValue = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_FILTER)) {
            ++this.filterOrder;
            this.inFilter = true;
        } else if (string4.equalsIgnoreCase(ELEM_INIT_PARAM)) {
            this.paramName = "";
            this.paramValue = "";
            if (this.inFilter) {
                this.inFilterParam = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_FILTER_NAME)) {
            this.filterName = "";
            if (this.inFilter || this.inFilterMapping) {
                this.inFilterName = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_FILTER_CLASS)) {
            this.filterClass = "";
            if (this.inFilter) {
                this.inFilterClass = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_FILTER_MAPPING)) {
            this.inFilterMapping = true;
        } else if (string4.equalsIgnoreCase(ELEM_URL_PATTERN)) {
            this.servletUrlPattern = "";
            this.filterUrlPattern = "";
            if (this.inServletMapping) {
                this.inServletUrlPattern = true;
            } else if (this.inFilterMapping) {
                this.inFilterUrlPattern = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET)) {
            this.servletName = "";
            this.servletClass = "";
            ++this.servletOrder;
            this.inServlet = true;
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET_NAME)) {
            this.servletName = "";
            if (this.inServlet || this.inServletMapping) {
                this.inServletName = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET_CLASS)) {
            this.servletClass = "";
            if (this.inServlet) {
                this.inServletClass = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET_MAPPING)) {
            this.servletName = "";
            this.servletUrlPattern = "";
            this.inServletMapping = true;
        } else if (string4.equalsIgnoreCase(ELEM_TAGLIB)) {
            this.taglibName = "";
            this.taglibLocation = "";
            ++this.taglibOrder;
            this.inTaglib = true;
        } else if (string4.equalsIgnoreCase(ELEM_TAGLIB_URI)) {
            this.taglibName = "";
            if (this.inTaglib) {
                this.inTaglibName = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_TAGLIB_LOCATION)) {
            this.taglibLocation = "";
            if (this.inTaglib) {
                this.inTaglibLocation = true;
            }
        } else if (string4.equalsIgnoreCase(ELEM_LISTENER)) {
            this.listenerName = "";
            this.listenerClass = "";
            ++this.listenerOrder;
            this.inListener = true;
        } else if (string4.equalsIgnoreCase(ELEM_LISTENER_CLASS)) {
            this.listenerClass = "";
            if (this.inListener) {
                this.inListenerClass = true;
            }
        } else {
            this.inIgnoreTag = true;
            this.ignoreTagName = string4;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2.trim();
        if (string4.length() == 0) {
            string4 = string3.trim();
        }
        if (string4.equalsIgnoreCase(ELEM_WEBAPP)) {
            return;
        }
        if (this.inIgnoreTag) {
            if (string4.equalsIgnoreCase(this.ignoreTagName)) {
                this.ignoreTagName = "";
                this.inIgnoreTag = false;
            }
            return;
        }
        WebXmlParsedTag webXmlParsedTag = null;
        if (string4.equalsIgnoreCase(ELEM_CONTEXT_PARAM)) {
            if (this.paramName.length() > 0) {
                webXmlParsedTag = new WebXmlParsedTag(ELEM_CONTEXT_PARAM, this.paramName);
                webXmlParsedTag.setValue(this.paramValue);
                webXmlParsedTag.setOrder(this.paramOrder);
                this.addTag(webXmlParsedTag);
            }
            this.paramName = "";
            this.paramValue = "";
            this.inContextParam = false;
        } else if (string4.equalsIgnoreCase(ELEM_PARAM_NAME)) {
            if (this.inContextParamName) {
                this.paramName = this.tagValue;
                this.inContextParamName = false;
            } else if (this.inFilterParamName) {
                this.paramName = this.tagValue;
                this.inFilterParamName = false;
            }
        } else if (string4.equalsIgnoreCase(ELEM_PARAM_VALUE)) {
            if (this.inContextParamValue) {
                this.paramValue = this.tagValue;
                this.inContextParamValue = false;
            } else if (this.inFilterParamValue) {
                this.paramValue = this.tagValue;
                this.inFilterParamValue = false;
            }
        } else if (string4.equalsIgnoreCase(ELEM_FILTER)) {
            this.filterName = "";
            this.filterClass = "";
            this.inFilter = false;
        } else if (string4.equalsIgnoreCase(ELEM_FILTER_NAME)) {
            this.filterName = this.tagValue;
            if (this.inFilter && this.filterName.length() > 0) {
                webXmlParsedTag = new WebXmlParsedTag(ELEM_FILTER, this.filterName);
                webXmlParsedTag.setOrder(this.filterOrder);
                this.addTag(webXmlParsedTag);
            }
            this.inFilterName = false;
        } else if (string4.equalsIgnoreCase(ELEM_FILTER_CLASS)) {
            this.filterClass = this.tagValue;
            if (this.filterClass.length() > 0 && (webXmlParsedTag = this.getTag(ELEM_FILTER, this.filterName)) != null) {
                webXmlParsedTag.setClassname(this.filterClass);
            }
            this.filterClass = "";
            this.inFilterClass = false;
        } else if (string4.equalsIgnoreCase(ELEM_INIT_PARAM)) {
            if (this.paramName.length() > 0 && (webXmlParsedTag = this.getTag(ELEM_FILTER, this.filterName)) != null) {
                webXmlParsedTag.addParameter(this.paramName, this.paramValue);
            }
            this.paramName = "";
            this.paramValue = "";
            this.inFilterParam = false;
        } else if (string4.equalsIgnoreCase(ELEM_FILTER_MAPPING)) {
            if (this.filterName.length() > 0 && (webXmlParsedTag = this.getTag(ELEM_FILTER, this.filterName)) != null) {
                webXmlParsedTag.setValue(this.filterUrlPattern);
            }
            this.filterName = "";
            this.filterUrlPattern = "";
            this.inFilterMapping = false;
        } else if (string4.equalsIgnoreCase(ELEM_URL_PATTERN)) {
            if (this.inServletMapping) {
                this.servletUrlPattern = this.tagValue;
                this.inServletUrlPattern = false;
            } else if (this.inFilterMapping) {
                this.filterUrlPattern = this.tagValue;
                this.inFilterUrlPattern = false;
            }
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET)) {
            if (this.servletName.length() > 0) {
                webXmlParsedTag = new WebXmlParsedTag(ELEM_SERVLET, this.servletName);
                webXmlParsedTag.setClassname(this.servletClass);
                webXmlParsedTag.setOrder(this.servletOrder);
                this.addTag(webXmlParsedTag);
            }
            this.servletName = "";
            this.servletClass = "";
            this.inServlet = false;
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET_NAME)) {
            this.servletName = this.tagValue;
            this.inServletName = false;
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET_CLASS)) {
            this.servletClass = this.tagValue;
            this.inServletClass = false;
        } else if (string4.equalsIgnoreCase(ELEM_SERVLET_MAPPING)) {
            if (this.servletName.length() > 0 && (webXmlParsedTag = this.getTag(ELEM_SERVLET, this.servletName)) != null) {
                webXmlParsedTag.setValue(this.servletUrlPattern);
            }
            this.servletName = "";
            this.servletUrlPattern = "";
            this.inServletMapping = false;
        } else if (string4.equalsIgnoreCase(ELEM_TAGLIB)) {
            if (this.taglibName.length() > 0) {
                webXmlParsedTag = new WebXmlParsedTag(ELEM_TAGLIB, this.taglibName);
                webXmlParsedTag.setValue(this.taglibLocation);
                webXmlParsedTag.setOrder(this.taglibOrder);
                this.addTag(webXmlParsedTag);
            }
            this.taglibName = "";
            this.taglibLocation = "";
            this.inTaglib = false;
        } else if (string4.equalsIgnoreCase(ELEM_TAGLIB_URI)) {
            this.taglibName = this.tagValue;
            this.inTaglibName = false;
        } else if (string4.equalsIgnoreCase(ELEM_TAGLIB_LOCATION)) {
            this.taglibLocation = this.tagValue;
            this.inTaglibLocation = false;
        } else if (string4.equalsIgnoreCase(ELEM_LISTENER)) {
            if (this.listenerName.length() > 0) {
                webXmlParsedTag = new WebXmlParsedTag(ELEM_LISTENER, this.listenerName);
                webXmlParsedTag.setClassname(this.listenerClass);
                webXmlParsedTag.setOrder(this.listenerOrder);
                this.addTag(webXmlParsedTag);
            }
            this.listenerName = "";
            this.listenerClass = "";
            this.inListener = false;
        } else if (string4.equalsIgnoreCase(ELEM_LISTENER_CLASS)) {
            this.listenerName = this.listenerClass = this.tagValue;
            int n = this.listenerClass.lastIndexOf(".");
            if (n >= 0 && n < this.listenerClass.length() - 1) {
                this.listenerName = this.listenerClass.substring(n + 1);
            }
            this.inListenerClass = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        if (string.length() > 0) {
            this.tagValue = this.tagValue + string;
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        if (string2 != null && string2.endsWith(WEB_APP_DTD_SUFFIX)) {
            String string3 = string2;
            int n = string2.lastIndexOf("/");
            if (n >= 0) {
                string3 = string3.substring(n + 1);
            }
            if (string3.startsWith(WEB_APP_DTD_PREFIX)) {
                if (!string3.equalsIgnoreCase("web-app_2_3.dtd")) {
                    throw new SAXException("DOCTYPE DTD system ID is invalid: " + string2);
                }
                String string4 = !this.dtdpath.startsWith("/") && this.dtdpath.startsWith(":", 1) ? "File:///" + this.dtdpath : "File://" + this.dtdpath;
                inputSource = new InputSource(string4);
            }
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTag(WebXmlParsedTag webXmlParsedTag) {
        String string = webXmlParsedTag.getType() + "." + webXmlParsedTag.getName();
        HashMap hashMap = this.tagmap;
        synchronized (hashMap) {
            this.tagmap.put(string, webXmlParsedTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebXmlParsedTag getTag(String string, String string2) {
        WebXmlParsedTag webXmlParsedTag = null;
        String string3 = string + "." + string2;
        HashMap hashMap = this.tagmap;
        synchronized (hashMap) {
            webXmlParsedTag = (WebXmlParsedTag)this.tagmap.get(string3);
        }
        return webXmlParsedTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getTags(String string) {
        ArrayList<WebXmlParsedTag> arrayList = new ArrayList<WebXmlParsedTag>();
        HashMap hashMap = this.tagmap;
        synchronized (hashMap) {
            Set set = this.tagmap.keySet();
            if (set.isEmpty()) {
                return arrayList;
            }
            String string2 = string + ".";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!string3.startsWith(string2)) continue;
                WebXmlParsedTag webXmlParsedTag = (WebXmlParsedTag)this.tagmap.get(string3);
                arrayList.add(webXmlParsedTag);
            }
        }
        return arrayList;
    }

    private String fixStringValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private int getVersionNumber(String string) {
        int n = 0;
        try {
            String[] stringArray = string.trim().split("[^0123456789.]");
            string = "0" + stringArray[0];
        }
        catch (Exception exception) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n4 = stringTokenizer.countTokens();
            if (n4 > 0) {
                string2 = stringTokenizer.nextToken();
                n2 = new Integer(string2);
            }
            if (n4 > 1) {
                string2 = stringTokenizer.nextToken();
                n3 = new Integer(string2);
            }
            n = n2 * 100 + n3;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private int checkAttrName(Attributes attributes, String string) {
        int n = -1;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string2 = attributes.getLocalName(i);
                if ("".equals(string2)) {
                    string2 = attributes.getQName(i);
                }
                if (!string2.equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void dumpTags() {
        Set set = this.tagmap.keySet();
        if (set.isEmpty()) {
            System.out.println("Parser handler: no parsed tag objects");
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                WebXmlParsedTag webXmlParsedTag = (WebXmlParsedTag)this.tagmap.get(string);
                if (webXmlParsedTag == null) continue;
                System.out.println("    " + webXmlParsedTag.toString());
            }
        }
    }
}

