/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.management.services.registration.RegistrationInfo;
import com.sun.web.util.AppXmlChecker;
import com.sun.web.util.CliSubcommand;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import com.sun.web.util.WebXmlChecker;
import java.io.File;

public class CliXmlChecker
implements CliSubcommand {
    private static final String APP_OPT_SHORT = "-a";
    private static final String APP_OPT_LONG = "--app";
    private static final String WEB_OPT_SHORT = "-w";
    private static final String WEB_OPT_LONG = "--web";
    private static final String ALL_OPT_SHORT = "-A";
    private static final String ALL_OPT_LONG = "--all";
    private static final String HELP_PREFIX = "check_help_";
    private static final String WEB_INF_SUBDIR = "WEB-INF";
    private static final String CHECK_FILE_PATH = WebUtilConstants.SYSTEM_SUBDIR + File.separator + "app_checkfile";
    private String console_home;
    private WebUtilLogger logger = null;

    public CliXmlChecker(String string) {
        this.console_home = string;
        this.logger = new WebUtilLogger("validate");
    }

    public int execute(String[] stringArray) throws WebUtilException {
        int n;
        Object object;
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = null;
        if (stringArray.length != 2) {
            this.printError("cli_err_01", null);
            return 2;
        }
        String[] stringArray2 = stringArray[1].split("_WxS_");
        boolean bl6 = true;
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray2.length) {
            string3 = this.stripQuotes(stringArray2[n3]);
            if (bl6) {
                if (string3.equals("-h") || string3.equals("--help") || string3.equals("-?")) {
                    this.showHelp();
                    return 0;
                }
                if (string3.equals(APP_OPT_SHORT) || string3.equals(APP_OPT_LONG)) {
                    bl3 = true;
                    ++n2;
                    ++n3;
                    continue;
                }
                if (string3.equals(WEB_OPT_SHORT) || string3.equals(WEB_OPT_LONG)) {
                    bl4 = true;
                    ++n2;
                    ++n3;
                    continue;
                }
                if (string3.equals(ALL_OPT_SHORT) || string3.equals(ALL_OPT_LONG)) {
                    bl5 = true;
                    ++n2;
                    ++n3;
                    continue;
                }
                if (string3.equals("-j") || string3.equals("--jato")) {
                    bl = true;
                    ++n3;
                    continue;
                }
                if (string3.equals("-f") || string3.equals("--faces")) {
                    bl2 = true;
                    ++n3;
                    continue;
                }
            }
            if (string3.startsWith("-")) {
                string4 = "cli_err_02";
                break;
            }
            bl6 = false;
            if (string == null) {
                string = string3;
                ++n3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                ++n3;
                continue;
            }
            string4 = "cli_err_08";
        }
        if (string4 != null) {
            this.printError(string4, string3);
            return 2;
        }
        if (n2 != 1) {
            this.printError("check_err_01", string3);
            return 2;
        }
        if (string == null || string.length() == 0) {
            this.printError("check_err_03", string3);
            return 2;
        }
        if (bl5) {
            bl3 = true;
            bl4 = true;
        }
        if (!bl && !bl2) {
            bl2 = true;
        }
        if (string2 == null) {
            string2 = this.console_home + CHECK_FILE_PATH;
        }
        String string5 = string;
        String string6 = string;
        if (!string.endsWith(".xml")) {
            string5 = string + File.separator + WEB_INF_SUBDIR + File.separator + "app.xml";
            string6 = string + File.separator + WEB_INF_SUBDIR + File.separator + "web.xml";
        }
        int n4 = 0;
        if (bl3) {
            RegistrationInfo registrationInfo = null;
            object = null;
            try {
                object = new AppXmlChecker(this.console_home, this.logger);
                registrationInfo = ((AppXmlChecker)object).parse(true, string5);
                if (n4 < 2) {
                    n4 = ((AppXmlChecker)object).check(registrationInfo);
                }
            }
            catch (WebUtilException webUtilException) {
                this.printMessage(0, webUtilException);
                n4 = 2;
            }
            catch (Exception exception) {
                this.printError("check_err_25", "app.xml", exception.getLocalizedMessage());
                n4 = 2;
            }
        }
        int n5 = 0;
        if (bl4) {
            object = null;
            try {
                object = new WebXmlChecker(string2, this.console_home, this.logger);
                n5 = ((WebXmlChecker)object).parse(true, string6);
                if (n5 < 2) {
                    n5 = ((WebXmlChecker)object).check(bl, bl2);
                }
            }
            catch (WebUtilException webUtilException) {
                this.printMessage(0, webUtilException);
                n5 = 2;
            }
            catch (Exception exception) {
                this.printError("check_err_25", "web.xml", exception.getLocalizedMessage());
                n5 = 2;
            }
        }
        if (n5 > (n = n4)) {
            n = n5;
        }
        return n;
    }

    public String getDescription() {
        WebUtilException webUtilException = new WebUtilException("usage_100");
        return webUtilException.getLocalizedMessage();
    }

    private String stripQuotes(String string) {
        if (string.startsWith("\"") && (string = string.substring(1)).endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void showHelp() {
        boolean bl = true;
        int n = 0;
        System.out.println("");
        while (bl) {
            String string = HELP_PREFIX + ++n;
            String string2 = new WebUtilException(string).getLocalizedMessage();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.equals("EOM") || string2.equals(string)) break;
            System.out.println(string2);
        }
        System.out.println("");
    }

    private void printInfo(String string, String string2) {
        this.printMessage(2, string, string2, null, null);
    }

    private void printWarning(String string, String string2) {
        this.printMessage(1, string, string2, null, null);
    }

    private void printError(String string, String string2) {
        this.printMessage(0, string, string2, null, null);
    }

    private void printError(String string, String string2, String string3) {
        this.printMessage(0, string, string2, string3, null);
    }

    private void printMessage(int n, String string, String string2, String string3, String string4) {
        WebUtilException webUtilException = new WebUtilException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        this.printMessage(n, webUtilException);
    }

    private void printMessage(int n, WebUtilException webUtilException) {
        String string = webUtilException.getLocalizedMessage();
        if (this.logger != null) {
            this.logger.log(string, n);
        } else if (n == 0) {
            System.err.println(string);
        } else {
            System.out.println(string);
        }
    }
}

