/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.log;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogServiceInterface;
import com.sun.wbem.solarisprovider.logsvc.LogServiceWrapper;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;

public class LogUtil
implements LogServiceInterface {
    public static LogUtil theOnlyUtil = null;
    public static final int CATEGORY_INVALID = -1;
    public static final int APPLICATION_LOG = 0;
    public static final int SECURITY_LOG = 1;
    public static final int SYSTEM_LOG = 2;
    public static final int SEVERITY_INVALID = -1;
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static final String LOG_MESSAGES_FILE = "LogMessages";
    public CIMOMHandle cimomhandle = null;
    LogServiceWrapper wrap = null;

    public LogUtil(CIMOMHandle chandle) {
        this.cimomhandle = chandle;
    }

    public static synchronized LogUtil getInstance(CIMOMHandle chandle) {
        if (theOnlyUtil == null) {
            theOnlyUtil = new LogUtil(chandle);
        }
        return theOnlyUtil;
    }

    public synchronized String writeLog(String providerName, String summaryMesgID, String detailedMesgID, String[] args, String data, boolean syslog_flag, int category, int severity) throws CIMException {
        return this.writeLog(providerName, summaryMesgID, detailedMesgID, args, data, syslog_flag, category, severity, null);
    }

    public synchronized String writeLog(byte[] providerName, byte[] summaryMesg, byte[] detailedMesg, String data, boolean syslog_flag, int category, int severity) throws CIMException {
        String user = "N/A";
        String addendum = null;
        user = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentRole();
        if (user == null || user.trim().length() == 0) {
            user = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentUser();
        } else {
            String user_nam = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentUser();
            addendum = this.getMessage("LM_1406", user_nam, user);
        }
        if (user == null) {
            user = "N/A";
        }
        String client_addr = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentClientHost();
        String server_addr = null;
        String host_name = null;
        try {
            InetAddress ip_addr = InetAddress.getByName(client_addr);
            host_name = ip_addr.getHostName();
            server_addr = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            host_name = client_addr;
        }
        if (host_name == null) {
            host_name = client_addr;
        }
        String summaryMessage = null;
        String detailedMessage = null;
        String provider_name = null;
        if (summaryMesg != null) {
            summaryMessage = new String(summaryMesg);
        }
        if (detailedMesg != null) {
            detailedMessage = new String(detailedMesg);
        }
        if (providerName != null) {
            provider_name = new String(providerName);
        }
        LogRecord rec = new LogRecord(provider_name, category, severity, user, host_name, server_addr, summaryMessage, detailedMessage, null);
        if (addendum != null) {
            data = data != null ? data + " " + addendum : addendum;
        }
        rec.addData(data);
        if (this.wrap == null) {
            try {
                this.wrap = LogServiceWrapper.getInstance((CIMOMHandle)((ProviderCIMOMHandle)this.cimomhandle));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            if (this.wrap != null) {
                this.wrap.writeRecord(rec, syslog_flag);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return detailedMessage;
    }

    public LogRecord readRecord(long recordId, int hashCode, String fileName) throws AdminLogException {
        return null;
    }

    public void writeRecord(LogRecord rec, boolean syslog_flag) throws AdminLogException {
        this.writeRecord(rec, syslog_flag, null);
    }

    public void writeRecord(LogRecord rec, boolean syslog_flag, String bundleName) throws AdminLogException {
        try {
            this.writeLog(rec.getAppName(), rec.getSummaryMesgId(), rec.getDetailedMesgId(), rec.getSubstArgs(), rec.getData(), syslog_flag, rec.getCategory(), rec.getSeverity(), bundleName);
        }
        catch (CIMException ex) {
            throw new AdminLogException(ex.getMessage());
        }
    }

    public long getNumRecords(String fileName) throws AdminLogException {
        return -1L;
    }

    public Vector getList(int numRecords, Filterable logFilter, long recordId, String fileName) throws AdminLogException {
        return null;
    }

    public void clearLog(String fileName) throws AdminLogException {
    }

    public String[] listLogFiles() throws AdminLogException {
        return null;
    }

    public String getCurrentLogFileName() {
        return null;
    }

    public long getMaxLogFileSize(String fileName) throws AdminLogException {
        return -1L;
    }

    public long getLogFileSize(String fileName) throws AdminLogException {
        return -1L;
    }

    public int getNumLogFiles() {
        return -1;
    }

    public String getSyslogSwitch() {
        return null;
    }

    public String getLogStorageName() {
        return null;
    }

    public String getLogFileDir() {
        return null;
    }

    public void setProperties(int size, int num, String syslogSwitch, String dir) throws AdminLogException {
    }

    public String getSummaryMesg(String summaryMesgId, boolean locale_flag) {
        return this.getSummaryMesg(summaryMesgId, locale_flag, null);
    }

    public String getDetailedMesg(String detailedMesgId, boolean locale_flag, String[] args) {
        return this.getDetailedMesg(detailedMesgId, locale_flag, args, null);
    }

    public String getMessage(String key) {
        Locale loc = new Locale("", "");
        return LogUtil.getPattern(key, loc, null);
    }

    public String getMessage(String key, String arg) {
        String[] substArgs = new String[]{arg};
        Locale loc = new Locale("", "");
        return this.getLocalizedMessage(key, substArgs, loc, null);
    }

    public String getMessage(String key, String arg1, String arg2) {
        String[] substArgs = new String[]{arg1, arg2};
        Locale loc = new Locale("", "");
        return this.getLocalizedMessage(key, substArgs, loc, null);
    }

    public String getMessage(String key, String arg1, String arg2, String arg3) {
        String[] substArgs = new String[]{arg1, arg2, arg3};
        Locale loc = new Locale("", "");
        return this.getLocalizedMessage(key, substArgs, loc, null);
    }

    public String getMessage(String key, String[] substArgs) {
        Locale loc = new Locale("", "");
        return this.getLocalizedMessage(key, substArgs, loc, null);
    }

    public String getLocalizedMessage(String key, String[] substArgs) {
        return this.getLocalizedMessage(key, substArgs, (String)null);
    }

    public String getLocalizedMessage(String key, String[] substArgs, Locale loc) {
        return this.getLocalizedMessage(key, substArgs, loc, null);
    }

    public synchronized String writeLog(String providerName, String summaryMesgID, String detailedMesgID, String[] args, String data, boolean syslog_flag, int category, int severity, String bundleName) throws CIMException {
        String user = "N/A";
        String addendum = null;
        user = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentRole();
        if (user == null || user.trim().length() == 0) {
            user = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentUser();
        } else {
            String user_nam = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentUser();
            addendum = this.getMessage("LM_1406", user_nam, user);
        }
        if (user == null) {
            user = "N/A";
        }
        String client_addr = ((ProviderCIMOMHandle)this.cimomhandle).getCurrentClientHost();
        String server_addr = null;
        String host_name = null;
        try {
            InetAddress ip_addr = InetAddress.getByName(client_addr);
            host_name = ip_addr.getHostName();
            server_addr = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            host_name = client_addr;
        }
        if (host_name == null) {
            host_name = client_addr;
        }
        String summaryMesg = this.getSummaryMesg(summaryMesgID, true, bundleName);
        String detailedMesg = this.getDetailedMesg(detailedMesgID, true, args, bundleName);
        String provider_name = this.getSummaryMesg(providerName, true, bundleName);
        LogRecord rec = new LogRecord(provider_name, category, severity, user, host_name, server_addr, summaryMesg, detailedMesg, null);
        if (addendum != null) {
            data = data != null ? data + " " + addendum : addendum;
        }
        rec.addData(data);
        if (this.wrap == null) {
            try {
                this.wrap = LogServiceWrapper.getInstance((CIMOMHandle)((ProviderCIMOMHandle)this.cimomhandle));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            if (this.wrap != null) {
                this.wrap.writeRecord(rec, syslog_flag);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return detailedMesg;
    }

    public String getSummaryMesg(String summaryMesgId, boolean locale_flag, String bundleName) {
        String retStr = "";
        Locale loc = locale_flag ? Locale.getDefault() : new Locale("", "");
        retStr = LogUtil.getPattern(summaryMesgId, loc, bundleName);
        if (retStr != null) {
            return retStr;
        }
        return "";
    }

    public String getDetailedMesg(String detailedMesgId, boolean locale_flag, String[] args, String bundleName) {
        if (args == null) {
            args = new String[]{};
        }
        Locale loc = locale_flag ? Locale.getDefault() : new Locale("", "");
        return this.getLocalizedMessage(detailedMesgId, args, loc, bundleName);
    }

    public String getLocalizedMessage(String key, String[] substArgs, String bundleName) {
        Locale loc = Locale.getDefault();
        return this.getLocalizedMessage(key, substArgs, loc, bundleName);
    }

    public String getLocalizedMessage(String key, String[] substArgs, Locale loc, String bundleName) {
        boolean i = false;
        String retStr = key;
        if (substArgs == null) {
            return retStr;
        }
        try {
            retStr = MessageFormat.format(LogUtil.getPattern(retStr, loc, bundleName), substArgs);
        }
        catch (Exception x) {
            // empty catch block
        }
        return retStr;
    }

    protected static String getBundleName() {
        return "com.sun.wbem.utility.log.LogMessages";
    }

    private static String getPattern(String key, Locale loc, String bundleName) {
        PropertyResourceBundle prb = null;
        String ptrn = null;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String str1 = bundleName == null ? LogUtil.getBundleName() : bundleName;
        try {
            prb = (PropertyResourceBundle)ResourceBundle.getBundle(str1, loc);
            ptrn = prb.getString(key);
        }
        catch (Exception x) {
            ptrn = key;
        }
        return ptrn;
    }
}

