/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableSetup;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryTableFactory {
    public static DirectoryTable getDirectoryTableInstance(String contextUrl) throws DirectoryTableException {
        int separator = 0;
        separator = contextUrl.indexOf(":/");
        if (separator == -1 || separator < 2) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        String directoryServiceName = contextUrl.substring(0, 1).toUpperCase() + contextUrl.substring(1, separator).toLowerCase();
        String remainingContext = contextUrl.length() > separator + 2 ? contextUrl.substring(separator + 2) : "";
        String className = "com.sun.wbem.utility.directorytable." + directoryServiceName + "DirectoryTable";
        try {
            DirectoryTable dirTableInstance = (DirectoryTable)Class.forName(className).newInstance();
            if (dirTableInstance != null) {
                dirTableInstance.setContext(remainingContext);
            }
            return dirTableInstance;
        }
        catch (ClassNotFoundException e) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", directoryServiceName);
        }
        catch (InstantiationException e) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", directoryServiceName);
        }
        catch (IllegalAccessException e) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", directoryServiceName);
        }
    }

    public static DirectoryTable getDirectoryTableInstance(String datastore, String domain, String nameserver) {
        try {
            return DirectoryTableFactory.getDirectoryTableInstance(datastore + ":/" + nameserver + "/" + domain);
        }
        catch (DirectoryTableException e) {
            return null;
        }
    }

    public static DirectoryTable getDirectoryTableInstance(String datastore, String domain, String nameserver, String user, String pass) {
        try {
            return DirectoryTableFactory.getDirectoryTableInstance(datastore + ":/" + nameserver + "/" + domain + "/authName = " + user + ", authPassword = " + pass);
        }
        catch (DirectoryTableException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("Instantiate a table for a given nameservice");
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance("File", "", "");
            System.out.println("Open the hosts table");
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("hosts");
            try {
                directoryTable.open(tableDefinitions);
            }
            catch (DirectoryTableDoesNotExistException e) {
                directoryTable.create(tableDefinitions);
            }
            DirectoryRow newRow = directoryTable.getRowInstance();
            newRow.putColumn(tableDefinitions.getColumnNumber("addr"), "128.99.99.99");
            newRow.putColumn(tableDefinitions.getColumnNumber("cname"), "testhost");
            newRow.putColumn(tableDefinitions.getColumnNumber("aliases"), "testalias");
            newRow.putColumn(tableDefinitions.getColumnNumber("comment"), "test entry");
            System.out.println("Add the new row we built");
            directoryTable.addRow(newRow);
            System.out.println("Now delete the row we added before");
            directoryTable.deleteRow(newRow);
            System.out.println("Build a different new row to add");
            newRow = directoryTable.getRowInstance();
            newRow.putColumn(tableDefinitions.getColumnNumber("addr"), "128.98.98.98");
            newRow.putColumn(tableDefinitions.getColumnNumber("cname"), "testhost2");
            newRow.putColumn(tableDefinitions.getColumnNumber("aliases"), "testalias2");
            newRow.putColumn(tableDefinitions.getColumnNumber("comment"), "test entry2");
            System.out.println("Add the new row we built");
            directoryTable.addRow(newRow);
            System.out.println("Build a modify template");
            DirectoryRow modRow = newRow.extractRows(1, 1);
            modRow.putColumn(tableDefinitions.getColumnNumber("cname"), "testhost3");
            System.out.println("Modify the last row we added");
            directoryTable.modifyRow(newRow, modRow);
            System.out.println("Now enumerate the filtered rows with first/next");
            DirectoryFilter filter = new DirectoryFilter(1);
            filter.add(tableDefinitions.getColumnNumber("cname"), 1, 5, "testhost3");
            DirectoryRow row = directoryTable.getFirstRow(filter);
            int rowNum = 0;
            while (row != null) {
                System.out.print("Row " + rowNum + ": ");
                for (int i = 1; i <= row.getNumberOfColumns(); ++i) {
                    System.out.print(tableDefinitions.getColumnName(i) + " = " + row.getColumn(i) + " ");
                }
                System.out.println("");
                row = directoryTable.getNextRow(filter);
                ++rowNum;
            }
            System.out.println("Now delete the row we modified");
            directoryTable.deleteRow(modRow);
            System.out.println("Now enumerate the rows sorted by cname");
            row = directoryTable.getAll();
            if (row != null) {
                row.sortByColumn(tableDefinitions.getColumnNumber("cname"), tableDefinitions);
                for (int j = 1; j <= row.getNumberOfRows(); ++j) {
                    System.out.print("Row " + j + ": ");
                    for (int i = 1; i <= row.getNumberOfColumns(); ++i) {
                        System.out.print(tableDefinitions.getColumnName(i) + " = " + row.getColumn(i, j) + " ");
                    }
                    System.out.println("");
                }
            }
            System.out.println("Close the table");
            directoryTable.close();
        }
        catch (DirectoryTableException d) {
            System.out.println(d.getMessage());
        }
    }

    static {
        DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
        directoryTableSetup.setup();
    }
}

