/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SecureReader
implements PrivilegedAction {
    protected InputStream iStream = null;
    protected static boolean libraryLoaded = false;

    protected static void loadLibrary() {
        try {
            System.loadLibrary("provutil");
            libraryLoaded = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Object run() {
        if (!libraryLoaded) {
            SecureReader.loadLibrary();
        }
        if (this.iStream == null) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.iStream));
            this.echoOff();
            String input = br.readLine();
            this.echoOn();
            return input;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static String readLine(InputStream stream) {
        if (stream == null) {
            return null;
        }
        SecureReader secRead = new SecureReader();
        secRead.iStream = stream;
        try {
            Object o = AccessController.doPrivileged(secRead);
            return (String)o;
        }
        catch (Throwable t) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                return br.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected void echoOff() {
        if (libraryLoaded) {
            SecureReader.doEchoOff();
        }
    }

    protected void echoOn() {
        if (libraryLoaded) {
            SecureReader.doEchoOn();
        }
    }

    protected static native void doEchoOff();

    protected static native void doEchoOn();
}

