/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CommonTools {
    public static final String TRACE_STDOUT_NAME = "stdout";
    public static final String TRACE_STDERR_NAME = "stderr";
    public static final int TRACE_OFF = 0;
    public static final String PREFERENCES_GLOBAL = "global";
    private static final String WIN_BAT_SUFFIX = ".bat";
    private static final int TRACE_NONE = 0;
    private static final int TRACE_STDOUT = 1;
    private static final int TRACE_STDERR = 2;
    private static final int TRACE_FILE = 3;
    private static final int TRACE_RETRY = 5;
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static int trace_out = 3;
    private static FileWriter trace_fw;
    private static BufferedWriter trace_bw;
    private static PrintWriter trace_pw;
    private static Hashtable preferences;

    public static void CMN_TraceOpen(int level, String filename) {
        String trace_file = null;
        String trace_sufx = null;
        if (trace_init) {
            return;
        }
        trace_level = level;
        if (filename != null && filename.trim().length() != 0) {
            if (filename.equals(TRACE_STDOUT_NAME)) {
                trace_out = 1;
            } else if (filename.equals(TRACE_STDERR_NAME)) {
                trace_out = 2;
            } else {
                trace_out = 3;
                trace_file = filename.trim();
            }
        } else {
            trace_level = 0;
        }
        if (trace_out == 3 && trace_level > 0) {
            int i;
            trace_file = CommonTools.CMN_GetTempDir() + File.separator + trace_file;
            SimpleDateFormat sdf = new SimpleDateFormat("MMdd_HHmm");
            trace_sufx = sdf.format(new Date());
            String name = trace_file = trace_file + trace_sufx;
            for (i = 1; i < 5; ++i) {
                try {
                    File fd1 = new File(name);
                    if (!fd1.exists()) break;
                    name = trace_file + "_" + i;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (i < 5) {
                try {
                    trace_fw = new FileWriter(name);
                    trace_bw = new BufferedWriter(trace_fw);
                    trace_pw = new PrintWriter((Writer)trace_bw, true);
                }
                catch (Exception ex) {
                    trace_level = 0;
                }
            } else {
                trace_level = 0;
            }
        }
        trace_init = true;
    }

    public static void CMN_Trace1(String message) {
        if (trace_level > 0) {
            CommonTools.writeTrace(message);
        }
    }

    public static void CMN_Trace2(String message) {
        if (trace_level > 1) {
            CommonTools.writeTrace(message);
        }
    }

    public static void CMN_Trace3(String message) {
        if (trace_level > 2) {
            CommonTools.writeTrace(message);
        }
    }

    public static void CMN_TraceStack(int level, Exception ex) {
        if (trace_level >= level) {
            try {
                if (trace_out == 3) {
                    trace_pw.println(ex.getMessage());
                    ex.printStackTrace(trace_pw);
                } else if (trace_out == 1) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace(trace_pw);
                } else if (trace_out == 2) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace(trace_pw);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String CMN_CallingClassMethod() {
        String clm = null;
        try {
            InputStream is = CommonTools.getStackStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            br.readLine();
            String line = br.readLine();
            clm = CommonTools.getCaller(line);
            br.close();
        }
        catch (Exception ex) {
            clm = "??:??";
        }
        return clm;
    }

    public static void CMN_HandleOutput(String strText) {
        if (trace_level > 2) {
            CommonTools.writeTrace(strText);
        }
    }

    public static String[] CMN_exec(String[] strCmd) {
        String[] strReturnVal = null;
        Vector vLines = new Vector();
        try {
            vLines = CommonTools.CMN_ExecWithStdErr(null, strCmd, null);
            String[] stdOutArray = (String[])vLines.elementAt(0);
            strReturnVal = new String[stdOutArray.length];
            for (int ii = 0; ii < stdOutArray.length; ++ii) {
                strReturnVal[ii] = stdOutArray[ii];
            }
        }
        catch (Exception ioe) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + strCmd);
        }
        return strReturnVal;
    }

    public static Vector CMN_exec(String[] strCmd, boolean bKeepStdErr) {
        Object strReturnVal = null;
        Vector vLines = new Vector();
        try {
            vLines = CommonTools.CMN_ExecWithStdErr(null, strCmd, null);
        }
        catch (Exception ioe) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + strCmd);
        }
        if (!bKeepStdErr) {
            vLines.removeElementAt(1);
        }
        return vLines;
    }

    public static Vector CMN_exec(String[] strCmd, boolean bKeepStdErr, String[] Env) {
        Object strReturnVal = null;
        Vector vLines = new Vector();
        try {
            vLines = CommonTools.CMN_ExecWithStdErr(null, strCmd, Env);
        }
        catch (Exception ioe) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + strCmd);
        }
        if (!bKeepStdErr) {
            vLines.removeElementAt(1);
        }
        return vLines;
    }

    public static String[] CMN_exec(String strCmd) {
        String[] strReturnVal = null;
        Vector vLines = new Vector();
        try {
            vLines = CommonTools.CMN_ExecWithStdErr(strCmd, null, null);
            String[] stdOutArray = (String[])vLines.elementAt(0);
            strReturnVal = new String[stdOutArray.length];
            for (int ii = 0; ii < stdOutArray.length; ++ii) {
                strReturnVal[ii] = stdOutArray[ii];
            }
        }
        catch (Exception ioe) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + strCmd);
        }
        return strReturnVal;
    }

    public static String[] CMN_exec(String strCmd, String[] Env) {
        String[] strReturnVal = null;
        Vector vLines = new Vector();
        try {
            vLines = CommonTools.CMN_ExecWithStdErr(strCmd, null, Env);
            String[] stdOutArray = (String[])vLines.elementAt(0);
            strReturnVal = new String[stdOutArray.length];
            for (int ii = 0; ii < stdOutArray.length; ++ii) {
                strReturnVal[ii] = stdOutArray[ii];
            }
        }
        catch (Exception ioe) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + strCmd);
        }
        return strReturnVal;
    }

    public static Vector CMN_exec(String strCmd, boolean bKeepStdErr) {
        Object strReturnVal = null;
        Vector vLines = new Vector();
        try {
            vLines = CommonTools.CMN_ExecWithStdErr(strCmd, null, null);
        }
        catch (Exception ioe) {
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + strCmd);
        }
        if (!bKeepStdErr) {
            vLines.removeElementAt(1);
        }
        return vLines;
    }

    private static Vector CMN_ExecWithStdErr(String command, String[] commandArray, String[] EnvArray) throws Exception {
        Vector<Object[]> results = new Vector<Object[]>();
        Vector<String> stdOut = new Vector<String>();
        Vector<String> stdErr = new Vector<String>();
        Process process = null;
        try {
            Runtime runtime;
            if (EnvArray == null) {
                runtime = Runtime.getRuntime();
                process = command == null ? runtime.exec(commandArray) : runtime.exec(command);
            } else {
                runtime = Runtime.getRuntime();
                process = command == null ? runtime.exec(commandArray, EnvArray) : runtime.exec(command, EnvArray);
            }
            InputStream stdOutStream = process.getInputStream();
            InputStream stdErrStream = process.getErrorStream();
            StringBuffer stdOutLine = new StringBuffer("");
            StringBuffer stdErrLine = new StringBuffer("");
            boolean done = false;
            while (!done) {
                try {
                    char c;
                    while (stdOutStream.available() > 0) {
                        c = (char)stdOutStream.read();
                        if (c == '\n') {
                            stdOutLine.append(c);
                            stdOut.addElement(stdOutLine.toString());
                            stdOutLine.setLength(0);
                            continue;
                        }
                        stdOutLine.append(c);
                    }
                    while (stdErrStream.available() > 0) {
                        c = (char)stdErrStream.read();
                        if (c == '\n') {
                            stdErr.addElement(stdErrLine.toString());
                            stdErrLine.setLength(0);
                            continue;
                        }
                        stdErrLine.append(c);
                    }
                    int exitValue = process.exitValue();
                    done = true;
                }
                catch (IllegalThreadStateException e) {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
            }
        }
        catch (Exception e) {
            if (process != null) {
                process.destroy();
            }
            results = null;
            throw e;
        }
        Object[] array = new String[stdOut.size()];
        if (stdOut.size() != 0) {
            stdOut.copyInto(array);
            results.addElement(array);
        } else {
            results.addElement(array);
        }
        array = new String[stdErr.size()];
        if (stdErr.size() != 0) {
            stdErr.copyInto(array);
            results.addElement(array);
        } else {
            results.addElement(array);
        }
        return results;
    }

    public static Vector CMN_ExecWithStdErrNoCRLF(String[] commandArray) {
        Vector<Object[]> results = new Vector<Object[]>();
        Vector<String> stdOut = new Vector<String>();
        Vector<String> stdErr = new Vector<String>();
        Process process = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            process = runtime.exec(commandArray);
            InputStream stdOutStream = process.getInputStream();
            InputStream stdErrStream = process.getErrorStream();
            StringBuffer stdOutLine = new StringBuffer("");
            StringBuffer stdErrLine = new StringBuffer("");
            boolean done = false;
            while (!done) {
                try {
                    char c;
                    while (stdOutStream.available() > 0) {
                        c = (char)stdOutStream.read();
                        if (c == '\n') {
                            stdOutLine.append(c);
                            stdOut.addElement(stdOutLine.toString());
                            stdOutLine.setLength(0);
                            continue;
                        }
                        stdOutLine.append(c);
                    }
                    while (stdErrStream.available() > 0) {
                        c = (char)stdErrStream.read();
                        stdErrLine.append(c);
                    }
                    if (stdErrLine.length() > 0) {
                        stdErr.addElement(stdErrLine.toString());
                        stdErrLine.setLength(0);
                    }
                    int exitValue = process.exitValue();
                    done = true;
                }
                catch (IllegalThreadStateException e) {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
            }
        }
        catch (Exception e) {
            if (process != null) {
                process.destroy();
            }
            results = null;
            CommonTools.CMN_HandleOutput("Exception in CMN_exec with :" + commandArray);
        }
        Object[] array = new String[stdOut.size()];
        if (stdOut.size() != 0) {
            stdOut.copyInto(array);
            results.addElement(array);
        } else {
            results.addElement(array);
        }
        array = new String[stdErr.size()];
        if (stdErr.size() != 0) {
            stdErr.copyInto(array);
            results.addElement(array);
        } else {
            results.addElement(array);
        }
        return results;
    }

    public static synchronized String CMN_parseLinesForData(String[] strAllData, String strNTKeyWord) {
        String tmpStr = "";
        String strResult = "";
        int ii = 0;
        for (ii = 0; ii < strAllData.length; ++ii) {
            tmpStr = strAllData[ii];
            if (tmpStr == null || tmpStr.indexOf(strNTKeyWord) == -1) continue;
            int resultOffset = tmpStr.indexOf(strNTKeyWord) + strNTKeyWord.length();
            strResult = tmpStr.substring(resultOffset);
            strResult = strResult.trim();
            break;
        }
        return strResult;
    }

    public static String CMN_CheckScriptName(String script_name) {
        String name = script_name;
        String os = System.getProperty("os.name");
        if (os != null && os.regionMatches(true, 0, "Win", 0, 3) && !script_name.endsWith(WIN_BAT_SUFFIX)) {
            name = script_name.concat(WIN_BAT_SUFFIX);
        }
        return name;
    }

    public static String CMN_GetTempDir() {
        Properties systemProperties = System.getProperties();
        String key = systemProperties.getProperty("java.io.tmpdir");
        if (key == null) {
            String os = systemProperties.getProperty("os.name");
            key = os.regionMatches(true, 0, "Win", 0, 3) ? "C:\\TEMP" : "/tmp";
        }
        return key;
    }

    public static File CMN_CreateTempFile(String directory, String pattern) throws IOException {
        String name;
        File file;
        int i = 0;
        while ((file = new File(directory, name = pattern + "." + i)).exists()) {
            ++i;
        }
        FileOutputStream newFile = new FileOutputStream(file);
        newFile.close();
        return file;
    }

    public static File CMN_CreateTempFile(String pattern) throws IOException {
        String tempDirectory = CommonTools.CMN_GetTempDir();
        File directory = new File(tempDirectory);
        if (!(directory.exists() && directory.isDirectory() && directory.canWrite())) {
            directory = new File(pattern);
            tempDirectory = directory.getParent();
        }
        File file = CommonTools.CMN_CreateTempFile(tempDirectory, pattern);
        return file;
    }

    public static void CMN_WriteArray(File file, String[] data) throws IOException {
        FileOutputStream outStream = new FileOutputStream(file);
        for (int i = 0; i < data.length; ++i) {
            byte[] bytes = data[i].getBytes();
            outStream.write(bytes);
        }
        outStream.close();
    }

    public static Vector CMN_ArrayToVector(Object[] array) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < array.length; ++i) {
            vector.addElement(array[i]);
        }
        return vector;
    }

    public static Object[] CMN_VectorToArray(Vector vector) {
        int size = vector.size();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = vector.elementAt(i);
        }
        return array;
    }

    public static void CMN_setPreference(String sectionName, Object key, Object value) {
        if (!preferences.containsKey(sectionName)) {
            preferences.put(sectionName, new Hashtable());
        }
        Hashtable section = (Hashtable)preferences.get(sectionName);
        section.put(key, value);
    }

    public static Object CMN_getPreference(String sectionName, Object key, Object defaultValue) {
        if (!preferences.containsKey(sectionName)) {
            return defaultValue;
        }
        Hashtable section = (Hashtable)preferences.get(sectionName);
        if (!section.containsKey(key)) {
            return defaultValue;
        }
        return section.get(key);
    }

    private static synchronized void writeTrace(String msg) {
        try {
            if (trace_out == 3) {
                trace_pw.println(msg);
            } else if (trace_out == 1) {
                System.out.println(msg);
            } else if (trace_out == 2) {
                System.err.println(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream getStackStream() {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(os);
            new Exception().printStackTrace(pw);
            pw.close();
            is = new ByteArrayInputStream(os.toByteArray());
        }
        catch (Exception ex) {
            is = null;
        }
        return is;
    }

    private static String getCaller(String line) {
        String str = line;
        int i = line.indexOf(40);
        if (i > 0) {
            str = line.substring(0, i);
        }
        if ((i = str.indexOf("at")) > 0) {
            str = str.substring(i + 3);
        }
        if ((i = str.lastIndexOf(46)) > 0) {
            String mth = str.substring(i + 1);
            String cls = (i = (str = str.substring(0, i)).lastIndexOf(46)) > 0 ? str.substring(i + 1) : str;
            str = cls + ":" + mth;
        }
        return str;
    }

    static {
        preferences = new Hashtable();
    }
}

