/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogFilter;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_MessageLog
implements InstanceProvider,
MethodProvider,
Authorizable {
    public static final String LOGSVC_WRITE_RIGHT = "solaris.admin.logsvc.write";
    public static final String LOGSVC_PURGE_RIGHT = "solaris.admin.logsvc.purge";
    public static final String LOGSVC_READ_RIGHT = "solaris.admin.logsvc.read";
    public static final String LOG_CCN = "CreationClassName";
    public static final String LOG_NAME = "Name";
    public static final String LOG_CAPABILITIES = "Capabilities";
    public static final String LOG_CAPABILITY_DESC = "CapabilitiesDescriptions";
    public static final String LOG_MAXSIZE = "MaxLogSize";
    public static final String LOG_HDRSIZE = "SizeOfHeader";
    public static final String LOG_HDRFORMAT = "HeaderFormat";
    public static final String LOG_MAXRECSIZE = "MaxRecordSize";
    public static final String LOG_RECHDRSIZE = "SizeOfRecordHeader";
    public static final String LOG_RECHDRFORMAT = "RecordHeaderFormat";
    public static final String LOG_MAXREC = "MaxNumberOfRecords";
    public static final String LOG_NUMREC = "CurrentNumberOfRecords";
    public static final String LOG_OVERWRITEPOLICY = "OverwritePolicy";
    public static final String LOG_OTHERPOLICYDESC = "OtherPolicyDescription";
    public static final String LOG_TIMEOUTDATED = "TimeWhenOutdated";
    public static final String LOG_PERCENTFULL = "PercentageNearFull";
    public static final String LOG_LASTCHANGE = "LastChange";
    public static final String LOG_TIMEOFLASTCHANGE = "TimeOfLastChange";
    public static final String LOG_RECORDCHANGED = "RecordLastChanged";
    public static final String LOG_ISFROZEN = "IsFrozen";
    public static final String LOG_CHARACTERSET = "CharacterSet";
    public static final String LOG_DESC = "Description";
    public static final String LOG_INSTALLDATE = "InstallDate";
    public static final String LOG_CAPTION = "Caption";
    public static final String LOG_STATUS = "Status";
    public static final String SOLARIS_LOG_TYPE = "Type";
    public static final String SOLARIS_LOG_VERSION = "Version";
    private static final String[] SYSLOG_CAPABILITIES = new String[]{"8"};
    private static final String[] SYSLOG_DESC = new String[]{"Supports variable length records"};
    private static final String[] WBEMLOG_CAPABILITIES = new String[]{"2", "4", "5", "6", "8"};
    private static final String[] WBEMLOG_DESC = new String[]{"Supports writing of records", "Supports variable length records", "Allows traversal in chronological and reverse chronological order", "FreezeLog supported, but once a log is frozen, it cannot be *thawed*(?)", "ClearLog supported except on the active log in which case it is treated like a backup. ClearLog in the case of a historical log implies deletion of the log.", "Variable length records supported"};
    private LogService logsvc = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, "Logging Service");
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        String logName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
            logName = (String)cp.getValue().getValue();
        }
        if (logName == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        return this.getCIMInstance(cc, logName, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        CIMObjectPath cop;
        int i;
        String[] syslogFiles;
        String[] logFiles;
        Vector<CIMObjectPath> logVec;
        block9: {
            if (this.logsvc == null) {
                try {
                    this.logsvc = LogService.getInstance();
                }
                catch (AdminLogException ex) {
                    throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
                }
            }
            logVec = new Vector<CIMObjectPath>();
            logFiles = null;
            syslogFiles = null;
            try {
                logFiles = this.logsvc.listLogFiles();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
            try {
                syslogFiles = this.logsvc.listSyslogFiles();
            }
            catch (AdminLogException ex) {
                if (logFiles != null) break block9;
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        for (i = 0; logFiles != null && logFiles.length > 0 && i < logFiles.length; ++i) {
            cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey(LOG_NAME, new CIMValue((Object)logFiles[i]));
            cop.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
            logVec.addElement(cop);
        }
        for (i = 0; syslogFiles != null && syslogFiles.length > 0 && i < syslogFiles.length; ++i) {
            cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            cop.addKey(LOG_NAME, new CIMValue((Object)syslogFiles[i]));
            cop.addKey(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
            logVec.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[logVec.size()];
        logVec.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMInstance ci;
        int i;
        String[] syslogFiles;
        String[] logFiles;
        Vector<CIMInstance> logVec;
        block9: {
            if (this.logsvc == null) {
                try {
                    this.logsvc = LogService.getInstance();
                }
                catch (AdminLogException ex) {
                    throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
                }
            }
            logVec = new Vector<CIMInstance>();
            logFiles = null;
            syslogFiles = null;
            try {
                logFiles = this.logsvc.listLogFiles();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
            try {
                syslogFiles = this.logsvc.listSyslogFiles();
            }
            catch (AdminLogException ex) {
                if (logFiles != null) break block9;
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        for (i = 0; logFiles != null && logFiles.length > 0 && i < logFiles.length; ++i) {
            ci = this.getCIMInstance(cc, logFiles[i], localOnly, includeQualifiers, includeClassOrigin, propertyList);
            logVec.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        }
        for (i = 0; syslogFiles != null && syslogFiles.length > 0 && i < syslogFiles.length; ++i) {
            ci = this.getCIMInstance(cc, syslogFiles[i], localOnly, includeQualifiers, includeClassOrigin, propertyList);
            logVec.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[logVec.size()];
        logVec.toArray(ciArray);
        return ciArray;
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        String logName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
            logName = (String)cp.getValue().getValue();
        }
        if (logName == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.clearLog(logName);
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] v = null;
            v = this.enumerateInstances(op, false, false, false, null, cc);
            for (int i = 0; v != null && i < v.length; ++i) {
                if (where != null && !where.apply((CIMElement)v[i])) continue;
                result.addElement(attrs.apply((CIMElement)v[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        CIMValue results = null;
        String fileName = null;
        Enumeration e = op.getKeys().elements();
        if (e != null) {
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
                fileName = (String)cp.getValue().getValue();
            }
        }
        if (methodName.equalsIgnoreCase("ClearLog")) {
            this.provUtil.checkRights(LOGSVC_PURGE_RIGHT, op);
            if (fileName == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            return new CIMValue((Object)this.clearLog(fileName));
        }
        if (methodName.equalsIgnoreCase("PositionToFirstRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("PositionAtRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("GetRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("DeleteRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("WriteRecord")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("CancelIteration")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("FreezeLog")) {
            this.provUtil.checkRights(LOGSVC_PURGE_RIGHT, op);
            if (fileName == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            return new CIMValue((Object)this.freezeLog(fileName));
        }
        if (methodName.equalsIgnoreCase("FlagRecordForOverwrite")) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        if (methodName.equalsIgnoreCase("ListRecordsInLog")) {
            results = this.getList(op, inParams, outParams);
            return results;
        }
        if (methodName.equalsIgnoreCase("GetLogSize")) {
            this.provUtil.checkAuthenticated();
            if (fileName == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            return new CIMValue((Object)this.getLogFileSize(fileName, outParams));
        }
        if (methodName.equalsIgnoreCase("GetSyslogSwitch")) {
            this.provUtil.checkAuthenticated();
            return new CIMValue((Object)this.getSyslogSwitch(outParams));
        }
        if (methodName.equalsIgnoreCase("GetLogDirectory")) {
            this.provUtil.checkAuthenticated();
            return new CIMValue((Object)this.getLogFileDir(outParams));
        }
        throw new CIMException("NO_SUCH_METHOD");
    }

    public Integer clearLog(String fileName) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        try {
            String type = this.logsvc.getLogType(fileName);
            if (type.equalsIgnoreCase("Syslog")) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            this.logsvc.clearLog(fileName);
            return new Integer(0);
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
    }

    public Integer freezeLog(String fileName) throws CIMException {
        String currentLogFile = null;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
                currentLogFile = this.logsvc.getCurrentLogFileName();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        if (currentLogFile.equalsIgnoreCase(fileName)) {
            return this.clearLog(fileName);
        }
        return null;
    }

    public Long getLogFileSize(String fileName, Vector outParams) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        Long fileSize = null;
        try {
            fileSize = new Long(this.logsvc.getLogFileSize(fileName));
            outParams.addElement(new CIMValue((Object)fileSize));
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        return fileSize;
    }

    public Integer getSyslogSwitch(Vector outParams) throws CIMException {
        String syslogswitch;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        if ((syslogswitch = this.logsvc.getSyslogSwitch()) != null) {
            outParams.addElement(new CIMValue((Object)syslogswitch));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    public Integer getLogFileDir(Vector outParams) throws CIMException {
        String dirName;
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        if ((dirName = this.logsvc.getLogFileDir()) != null) {
            outParams.addElement(new CIMValue((Object)dirName));
            return new Integer(0);
        }
        return new Integer(-1);
    }

    private CIMValue getList(CIMObjectPath op, Vector inParams, Vector outParams) throws CIMException {
        String filter = null;
        String[] records = null;
        CIMValue iv = null;
        String logName = null;
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase(LOG_NAME)) continue;
            logName = (String)cp.getValue().getValue();
        }
        if (logName == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (inParams != null && inParams.size() > 0) {
            try {
                iv = (CIMValue)inParams.elementAt(0);
                filter = (String)iv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        String type = null;
        Vector<String> vOutParam = new Vector<String>();
        try {
            type = this.logsvc.getLogType(logName);
            if (type.equalsIgnoreCase("Syslog")) {
                records = this.logsvc.getSyslogRecords(logName);
                for (int i = 0; records != null && i < records.length; ++i) {
                    vOutParam.addElement(records[i]);
                }
                CIMDataType dtype = new CIMDataType(22);
                CIMValue outVal = new CIMValue(vOutParam, dtype);
                outParams.addElement(outVal);
                outParams.addElement(new CIMValue((Object)"Syslog", new CIMDataType(8)));
                CIMValue rv = new CIMValue((Object)new Integer(0));
                return rv;
            }
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        Vector lRec = null;
        try {
            long recId;
            int numRec;
            LogFilter lfilt;
            if (filter != null) {
                lfilt = new LogFilter(filter);
                lfilt.setFileName(null);
                numRec = 0;
                recId = 0L;
                numRec = (int)((long)numRec + this.logsvc.getNumRecords(logName));
                lRec = this.logsvc.getList(numRec, lfilt, recId, logName);
            } else {
                lfilt = new LogFilter();
                numRec = 0;
                recId = 0L;
                numRec = (int)((long)numRec + this.logsvc.getNumRecords(logName));
                lRec = this.logsvc.getList(numRec, lfilt, recId, logName);
            }
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        if (lRec != null && lRec.size() > 0) {
            Enumeration enum1 = lRec.elements();
            int i = 0;
            while (enum1.hasMoreElements()) {
                LogRecord l_rec = (LogRecord)enum1.nextElement();
                vOutParam.addElement(l_rec.formatRecord());
                ++i;
            }
            CIMDataType dtype = new CIMDataType(22);
            CIMValue outVal = new CIMValue(vOutParam, dtype);
            outParams.addElement(outVal);
            outParams.addElement(new CIMValue((Object)"WBEM Log", new CIMDataType(8)));
        }
        CIMValue rv = new CIMValue((Object)new Integer(0));
        return rv;
    }

    private CIMInstance getCIMInstance(CIMClass cc, String fileName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        String type = null;
        String version = null;
        CIMInstance ci = cc.newInstance();
        long fileSize = 0L;
        long sizeOfLogHeader = 0L;
        long sizeOfRecordHeader = 0L;
        String logHeaderFormat = "";
        String recordHeaderFormat = "";
        long numRecords = 0L;
        int percentFull = 0;
        long timeOfLastChange = 0L;
        long installdate = 0L;
        String currentLogFile = null;
        Date lastchange = null;
        Date startdate = null;
        Vector<UnsignedInt16> capabilities = new Vector<UnsignedInt16>();
        Vector<String> capabilityStrings = new Vector<String>();
        String overWritePolicyDesc = "";
        UnsignedInt16 overWritePolicy = new UnsignedInt16("0");
        boolean isFrozen = false;
        UnsignedInt16 characterSet = new UnsignedInt16("0");
        try {
            type = this.logsvc.getLogType(fileName);
            version = this.logsvc.getLogVersion(fileName);
            fileSize = this.logsvc.getMaxLogFileSize(fileName);
            sizeOfLogHeader = this.logsvc.getLogHeaderSize(fileName);
            sizeOfRecordHeader = this.logsvc.getRecordHeaderSize(fileName);
            logHeaderFormat = this.logsvc.getLogHeaderFormat(fileName);
            recordHeaderFormat = this.logsvc.getRecordHeaderFormat(fileName);
            numRecords = this.logsvc.getNumRecords(fileName);
            percentFull = this.logsvc.getLogPercentageFull(fileName);
            timeOfLastChange = this.logsvc.getTimeOfLastChange(fileName);
            lastchange = new Date(timeOfLastChange);
            currentLogFile = this.logsvc.getCurrentLogFileName();
            installdate = this.logsvc.getStartDate(fileName);
            if (installdate > 0L) {
                startdate = new Date(installdate);
            }
        }
        catch (AdminLogException ex) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        ci.setProperty(SOLARIS_LOG_VERSION, new CIMValue((Object)version));
        ci.setProperty(SOLARIS_LOG_TYPE, new CIMValue((Object)type));
        if (localOnly) {
            return ci;
        }
        ci.setProperty(LOG_CCN, new CIMValue((Object)"Solaris_MessageLog"));
        ci.setProperty(LOG_NAME, new CIMValue((Object)fileName));
        if (type.equalsIgnoreCase("Syslog")) {
            for (int i = 0; i < SYSLOG_CAPABILITIES.length; ++i) {
                capabilities.addElement(new UnsignedInt16(SYSLOG_CAPABILITIES[i]));
                capabilityStrings.addElement(SYSLOG_DESC[i]);
            }
            isFrozen = false;
            characterSet = new UnsignedInt16("2");
        } else if (type.equalsIgnoreCase("WBEM Log")) {
            overWritePolicy = new UnsignedInt16("1");
            overWritePolicyDesc = "The current log is backed up and a new log is created in its place. The log file gets deleted if the total number of logs exceeds the maximum specified through the log service properties file";
            isFrozen = !currentLogFile.equalsIgnoreCase(fileName);
            for (int i = 0; i < WBEMLOG_CAPABILITIES.length; ++i) {
                capabilities.addElement(new UnsignedInt16(WBEMLOG_CAPABILITIES[i]));
                capabilityStrings.addElement(WBEMLOG_DESC[i]);
            }
        }
        ci.setProperty(LOG_CAPABILITIES, new CIMValue(capabilities));
        ci.setProperty(LOG_CAPABILITY_DESC, new CIMValue(capabilityStrings));
        ci.setProperty(LOG_MAXSIZE, new CIMValue((Object)new UnsignedInt64(Long.toString(fileSize))));
        ci.setProperty(LOG_HDRSIZE, new CIMValue((Object)new UnsignedInt64(Long.toString(sizeOfLogHeader))));
        ci.setProperty(LOG_HDRFORMAT, new CIMValue((Object)logHeaderFormat));
        ci.setProperty(LOG_MAXRECSIZE, new CIMValue((Object)new UnsignedInt64("0")));
        ci.setProperty(LOG_RECHDRSIZE, new CIMValue((Object)new UnsignedInt64(Long.toString(sizeOfRecordHeader))));
        ci.setProperty(LOG_RECHDRFORMAT, new CIMValue((Object)recordHeaderFormat));
        ci.setProperty(LOG_MAXREC, new CIMValue((Object)new UnsignedInt64("0")));
        ci.setProperty(LOG_NUMREC, new CIMValue((Object)new UnsignedInt64(Long.toString(numRecords))));
        ci.setProperty(LOG_OVERWRITEPOLICY, new CIMValue((Object)overWritePolicy));
        ci.setProperty(LOG_OTHERPOLICYDESC, new CIMValue((Object)overWritePolicyDesc));
        ci.setProperty(LOG_TIMEOUTDATED, new CIMValue((Object)new CIMDateTime(new Date(0L))));
        ci.setProperty(LOG_PERCENTFULL, new CIMValue((Object)new UnsignedInt8(Integer.toString(percentFull))));
        ci.setProperty(LOG_LASTCHANGE, new CIMValue((Object)new UnsignedInt8("1")));
        ci.setProperty(LOG_TIMEOFLASTCHANGE, new CIMValue((Object)new CIMDateTime(lastchange)));
        ci.setProperty(LOG_RECORDCHANGED, new CIMValue((Object)new UnsignedInt64("0")));
        ci.setProperty(LOG_ISFROZEN, new CIMValue((Object)new Boolean(isFrozen)));
        ci.setProperty(LOG_CHARACTERSET, new CIMValue((Object)characterSet));
        if (startdate != null) {
            ci.setProperty(LOG_INSTALLDATE, new CIMValue((Object)new CIMDateTime(startdate)));
        }
        ci.setProperty(LOG_STATUS, new CIMValue((Object)"Unknown"));
        ci.setProperty(LOG_CAPTION, new CIMValue((Object)"Message Log File"));
        ci.setProperty(LOG_DESC, new CIMValue((Object)("File containing " + type + " records")));
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }
}

