/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import java.util.Vector;

public class FilterThread
implements Runnable {
    Buffer shared_buffer;
    Filterable log_filter;
    int numRecords;
    Vector headers;

    public FilterThread(Buffer record_vector, Filterable log_filter, int numRecords) {
        this.shared_buffer = record_vector;
        this.log_filter = log_filter;
        this.numRecords = numRecords;
        this.headers = new Vector();
    }

    public void run() {
        Vector un_filtered;
        while (this.shared_buffer.retSize() < this.numRecords && (this.shared_buffer.getMessage() || !this.shared_buffer.isEmpty()) && (un_filtered = this.shared_buffer.getRecs()) != null) {
            this.headers = this.apply_filter(un_filtered);
            int i = this.headers.size();
            if ((i += this.shared_buffer.retSize()) >= this.numRecords) {
                this.headers.setSize(this.headers.size() - (i - this.numRecords));
                this.shared_buffer.addToVect(this.headers);
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(false);
                break;
            }
            this.shared_buffer.addToVect(this.headers);
        }
    }

    private Vector apply_filter(Vector records) {
        int j = records.size();
        Vector<LogRecord> headers = new Vector<LogRecord>();
        for (int i = 0; i < j; ++i) {
            DataRecord rec = (DataRecord)records.elementAt(i);
            LogRecord log_record = (LogRecord)rec.getRecord();
            log_record.setRecordId(rec.getOffset());
            log_record.setHashCode(rec.getHash());
            if (!this.log_filter.checkConstraints(log_record)) continue;
            headers.addElement(log_record);
        }
        return headers;
    }
}

