/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sunvts.ui;

import com.sun.deg.sunvts.data.CompositeTypeOption;
import com.sun.deg.sunvts.data.Device;
import com.sun.deg.sunvts.data.LTOption;
import com.sun.deg.sunvts.data.SimpleTypeOption;
import com.sun.sunvts.bean.DeviceOptionBean;
import com.sun.sunvts.bean.LTOptionBean;
import com.sun.sunvts.ui.BreadcrumbLink;
import com.sun.sunvts.ui.CheckBoxHeader;
import com.sun.sunvts.ui.DeviceOptionsPanel;
import com.sun.sunvts.ui.HLinkRenderer;
import com.sun.sunvts.ui.LTGroupPanel;
import com.sun.sunvts.ui.MyItemListener;
import com.sun.sunvts.ui.SunvtsGUIApp;
import com.sun.sunvts.ui.TestPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXHyperlink;

public class LTOptionsPanel
extends JPanel {
    private final String TEST_OPTIONS = "Test Options";
    private final String TEST_GROUP = "Test Group";
    private String panelName = "Test Options";
    private static LTOptionsPanel ltoptionspanel = null;
    private ButtonGroup bgSchedPolicy;
    private ButtonGroup bgStress;
    private JLabel lblSchedPolicy;
    private JLabel lblSchedPolicyHelp;
    private JRadioButton rbTestPasses;
    private JRadioButton rbTestTime;
    private JTextField txtTestPasses;
    private JTextField txtTestTime;
    GroupLayout jPanel1Layout = null;
    private JButton btnOK = new JButton("Ok");
    private JButton btnCancel = new JButton("Cancel");
    ResourceMap resourceMap = null;
    private List options = null;
    LTOptionBean ltoptionbean = null;
    private ArrayList<Device> deviceList;
    private String testName = null;
    private String deviceName = null;
    private JPanel jPanel1;
    GroupLayout.SequentialGroup hseqG = null;
    GroupLayout.SequentialGroup vseqG = null;
    GroupLayout.ParallelGroup hpg1 = null;
    GroupLayout.ParallelGroup hpg2 = null;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JLabel lblTestName;
    private JPanel devicetablePanel;
    private JScrollPane devicetableScrollPane;
    private JTable deviceTable;
    private JButton disableButton;
    private JButton enableButton;

    private LTOptionsPanel() {
        this.initComponents();
        this.ltoptionbean = LTOptionBean.getLTOptionBean();
        this.testName = this.ltoptionbean.getTestName();
        this.lblTestName.setText(this.getTestName() + " Test Options");
        this.options = this.ltoptionbean.getLTOptions();
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LTOptionsPanel.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LTOptionsPanel.this.btnOkActionPerformed(e);
            }
        });
        this.resourceMap = ((SunvtsGUIApp)Application.getInstance(SunvtsGUIApp.class)).getContext().getResourceMap(LTOptionsPanel.class);
    }

    public static LTOptionsPanel getLTOptionsPanel() {
        if (ltoptionspanel == null) {
            ltoptionspanel = new LTOptionsPanel();
        }
        return ltoptionspanel;
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        Iterator itr = this.getOptions().iterator();
        int compSize = this.jPanel1.getComponentCount();
        while (itr.hasNext()) {
            CompositeTypeOption compositeoption;
            String optName;
            LTOption ltoption = (LTOption)itr.next();
            if (ltoption instanceof SimpleTypeOption) {
                SimpleTypeOption simpleoption = (SimpleTypeOption)ltoption;
                optName = simpleoption.getName();
                ArrayList<String> chkboxVal = new ArrayList<String>();
                for (int i = 0; i < compSize; ++i) {
                    JCheckBox cb;
                    JTextField tf;
                    JRadioButton rb;
                    Component c = this.jPanel1.getComponent(i);
                    if (c instanceof JRadioButton && (rb = (JRadioButton)c).getName().equalsIgnoreCase("rb" + optName + rb.getText()) && rb.isSelected()) {
                        simpleoption.setValue(new String[]{rb.getText()});
                        break;
                    }
                    if (c instanceof JTextField && (tf = (JTextField)c).getName().equalsIgnoreCase("txt" + optName)) {
                        simpleoption.setValue(new String[]{tf.getText()});
                        break;
                    }
                    if (!(c instanceof JCheckBox) || !(cb = (JCheckBox)c).getName().equalsIgnoreCase("cb" + optName + cb.getText())) continue;
                    if (cb.isSelected()) {
                        chkboxVal.add(cb.getText());
                    }
                    if (chkboxVal.size() != 0) {
                        String[] s = new String[chkboxVal.size()];
                        s = chkboxVal.toArray(s);
                        simpleoption.setValue(s);
                        continue;
                    }
                    simpleoption.setValue(new String[]{"None"});
                }
                if (optName.contains("Devices") && this.ltoptionbean.isDeviceOptExist()) {
                    ArrayList<String> valDeviceList = new ArrayList<String>();
                    Device device = null;
                    for (int i = 0; i < this.deviceList.size(); ++i) {
                        device = this.deviceList.get(i);
                        if (!device.isDeviceState()) continue;
                        valDeviceList.add(device.getDeviceName());
                    }
                    if (valDeviceList.size() > 0) {
                        Object[] objects = valDeviceList.toArray();
                        String[] valDeviceArr = new String[objects.length];
                        for (int i = 0; i < objects.length; ++i) {
                            valDeviceArr[i] = (String)objects[i];
                        }
                        simpleoption.setValue(valDeviceArr);
                    } else {
                        simpleoption.setValue(new String[]{"null"});
                    }
                }
            }
            if (!(ltoption instanceof CompositeTypeOption) || !(optName = (compositeoption = (CompositeTypeOption)ltoption).getName()).equalsIgnoreCase("Scheduling Policy")) continue;
            List nestedoptions = compositeoption.getNestedOptionsList();
            for (LTOption option : nestedoptions) {
                if (!(option instanceof SimpleTypeOption)) continue;
                SimpleTypeOption soption = (SimpleTypeOption)option;
                String name = soption.getName();
                if (name.equalsIgnoreCase("Test Time") && this.rbTestTime.isSelected()) {
                    soption.setValue(new String[]{this.txtTestTime.getText()});
                    compositeoption.setValue(new String[]{this.rbTestTime.getText()});
                }
                if (!name.equalsIgnoreCase("Test Passes") || !this.rbTestPasses.isSelected()) continue;
                soption.setValue(new String[]{this.txtTestPasses.getText()});
                compositeoption.setValue(new String[]{this.rbTestPasses.getText()});
            }
        }
        this.ltoptionbean.setLTOptions();
        TestPanel tp = TestPanel.getTestPanel();
        LTGroupPanel ltgrouppanel = LTGroupPanel.getLTGroupPanel();
        this.panelName = "Test Group";
        tp.changeMainPanelChild3(ltgrouppanel, this, this.getPanelName());
        tp.showLTPagedata();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        TestPanel tp = TestPanel.getTestPanel();
        LTGroupPanel ltgrouppanel = LTGroupPanel.getLTGroupPanel();
        this.panelName = "Test Group";
        tp.changeMainPanelChild3(ltgrouppanel, this, this.getPanelName());
    }

    public void fillpropertySheet() {
        this.ltoptionbean = LTOptionBean.getLTOptionBean();
        this.lblTestName.setText(this.ltoptionbean.getTestName() + " Test Options");
        this.options = this.ltoptionbean.getLTOptions();
        this.devicetablePanel = null;
        this.devicetableScrollPane = null;
        this.deviceTable = null;
        if (this.jPanel1 != null) {
            ltoptionspanel.remove(this.jPanel1);
        }
        this.addToMainPanel();
        this.jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1Layout.setAutocreateGaps(true);
        this.jPanel1Layout.setAutocreateContainerGaps(true);
        this.jPanel1.setLayout(this.jPanel1Layout);
        Iterator itr = this.getOptions().iterator();
        this.getLTComponents(itr);
        GroupLayout.SequentialGroup btnSeqGrp = this.jPanel1Layout.createSequentialGroup();
        btnSeqGrp.add(this.btnOK);
        btnSeqGrp.add(this.btnCancel);
        this.hpg1.add(btnSeqGrp);
        GroupLayout.ParallelGroup btnvpg = this.jPanel1Layout.createParallelGroup(1);
        btnvpg.add(this.btnOK);
        btnvpg.add(this.btnCancel);
        this.vseqG.add(btnvpg);
    }

    private void getLTComponents(Iterator itr) {
        this.hseqG = this.jPanel1Layout.createSequentialGroup();
        this.vseqG = this.jPanel1Layout.createSequentialGroup();
        this.hpg1 = this.jPanel1Layout.createParallelGroup(1);
        this.hpg2 = this.jPanel1Layout.createParallelGroup(1);
        int i = 0;
        String[] deviceNameArray = null;
        String[] selectedDeviceArray = null;
        while (itr.hasNext()) {
            ++i;
            LTOption option = (LTOption)itr.next();
            if (option instanceof SimpleTypeOption) {
                SimpleTypeOption simpleOption = (SimpleTypeOption)option;
                String optName = simpleOption.getName();
                JLabel lbloptionName = new JLabel();
                lbloptionName.setText(optName);
                lbloptionName.setName("lbl" + optName.trim());
                lbloptionName.setFont(this.resourceMap.getFont("lblOptionName.font"));
                this.hpg1.add(lbloptionName);
                GroupLayout.ParallelGroup vpgsimple = this.jPanel1Layout.createParallelGroup(1);
                vpgsimple.add(lbloptionName);
                this.vseqG.add(vpgsimple);
                this.vseqG.addContainerGap(20, 20);
                GroupLayout.SequentialGroup typeSeqGrp = this.jPanel1Layout.createSequentialGroup();
                switch (option.getType()) {
                    case 0: {
                        JRadioButton[] rbgItems = null;
                        this.bgStress = new ButtonGroup();
                        String[] strOptions = simpleOption.getRange();
                        rbgItems = new JRadioButton[strOptions.length];
                        for (int j = 0; j < strOptions.length; ++j) {
                            rbgItems[j] = new JRadioButton(strOptions[j]);
                            rbgItems[j].setFont(this.resourceMap.getFont("rbItem.font"));
                            rbgItems[j].setName("rb" + simpleOption.getName() + strOptions[j]);
                            rbgItems[j].setText(strOptions[j]);
                        }
                        JRadioButton rb1 = rbgItems[0];
                        JRadioButton rb2 = rbgItems[1];
                        this.bgStress.add(rb1);
                        this.bgStress.add(rb2);
                        lbloptionName.setLabelFor(rb1);
                        lbloptionName.setLabelFor(rb2);
                        typeSeqGrp.add(rb1);
                        typeSeqGrp.addPreferredGap(0);
                        typeSeqGrp.add(rb2);
                        this.hpg2.add(rb1);
                        this.hpg2.add(rb2);
                        if (simpleOption.getValue()[0].equalsIgnoreCase(rb1.getText())) {
                            rb1.setSelected(true);
                            break;
                        }
                        rb2.setSelected(true);
                        break;
                    }
                    case 1: {
                        if (this.ltoptionbean.isDeviceOptExist()) {
                            deviceNameArray = simpleOption.getRange();
                            selectedDeviceArray = simpleOption.getValue();
                            this.displayDeviceTable(deviceNameArray, selectedDeviceArray);
                            this.hpg2.add(this.devicetablePanel, 500, 500, 500);
                            vpgsimple.add(this.devicetablePanel);
                            break;
                        }
                        String[] optionRangeArr = simpleOption.getRange();
                        String[] optionValueArr = simpleOption.getValue();
                        JCheckBox[] cboptionArr = new JCheckBox[optionRangeArr.length];
                        for (int k = 0; k < optionRangeArr.length; ++k) {
                            cboptionArr[k] = new JCheckBox();
                            cboptionArr[k].setName("cb" + optName + optionRangeArr[k]);
                            cboptionArr[k].setFont(this.resourceMap.getFont("rbItem.font"));
                            cboptionArr[k].setText(optionRangeArr[k]);
                            for (int j = 0; j < optionValueArr.length; ++j) {
                                if (!optionRangeArr[k].equalsIgnoreCase(optionValueArr[j])) continue;
                                cboptionArr[k].setSelected(true);
                            }
                            this.hpg2.add(cboptionArr[k]);
                            typeSeqGrp.add(cboptionArr[k]);
                        }
                        break;
                    }
                    case 4: {
                        JTextField txtOption = new JTextField();
                        txtOption.setText(simpleOption.getValue()[0]);
                        txtOption.setName("txt" + optName);
                        lbloptionName.setLabelFor(txtOption);
                        this.hpg2.add(txtOption, 100, 100, 100);
                        typeSeqGrp.add(txtOption);
                    }
                }
                if (typeSeqGrp != null) {
                    vpgsimple.add(typeSeqGrp);
                    if (simpleOption.getInLineHelp() != null && !"".equals(simpleOption.getInLineHelp().trim())) {
                        JLabel lblHelp = new JLabel(simpleOption.getInLineHelp());
                        lblHelp.setName("lbl" + optName + "Help");
                        lblHelp.setFont(this.resourceMap.getFont("lblOptionHelp.font"));
                        this.hpg2.add(lblHelp);
                        typeSeqGrp.add(lblHelp);
                    }
                }
            }
            if (!(option instanceof CompositeTypeOption)) continue;
            GroupLayout.ParallelGroup vpgcomp = this.jPanel1Layout.createParallelGroup(1);
            CompositeTypeOption compositeTypeOption = (CompositeTypeOption)option;
            List list = compositeTypeOption.getNestedOptionsList();
            if (list == null || list.size() != 2) continue;
            String optName = option.getName();
            this.lblSchedPolicy = new JLabel(optName);
            this.lblSchedPolicy.setName("lblSchedPolicy");
            this.lblSchedPolicy.setFont(this.resourceMap.getFont("lblOptionName.font"));
            this.hpg1.add(this.lblSchedPolicy);
            vpgcomp.add(this.lblSchedPolicy);
            this.vseqG.add(vpgcomp);
            String[] value = compositeTypeOption.getValue();
            for (Object o : list) {
                SimpleTypeOption simpleTypeOption = (SimpleTypeOption)o;
                this.getCompositeProperty(simpleTypeOption, value[0], vpgcomp);
            }
            if (compositeTypeOption.getInLineHelp() == null || "".equals(compositeTypeOption.getInLineHelp().trim())) continue;
            this.lblSchedPolicyHelp = new JLabel("" + compositeTypeOption.getInLineHelp());
            this.lblSchedPolicyHelp.setName("lblSchedPolicyHelp");
            this.lblSchedPolicyHelp.setFont(this.resourceMap.getFont("lblOptionHelp.font"));
            this.hpg2.add(this.lblSchedPolicyHelp);
            this.vseqG.add(this.lblSchedPolicyHelp);
            this.vseqG.addContainerGap(20, 20);
        }
        this.hseqG.add(this.hpg1);
        this.hseqG.addContainerGap(50, 50);
        this.hseqG.add(this.hpg2);
        this.jPanel1Layout.setHorizontalGroup(this.hseqG);
        this.vseqG.addContainerGap();
        this.jPanel1Layout.setVerticalGroup(this.vseqG);
    }

    private void getCompositeProperty(SimpleTypeOption simpleTypeOption, String compositeVal, GroupLayout.ParallelGroup vpg) {
        String rbName;
        String simpleoptionName = simpleTypeOption.getName();
        String inlineHelp = "";
        if (simpleTypeOption.getInLineHelp() != null) {
            inlineHelp = simpleTypeOption.getInLineHelp();
        }
        String[] value = simpleTypeOption.getValue();
        String unit = "";
        if (simpleTypeOption.getUnit() != null) {
            inlineHelp = simpleTypeOption.getUnit();
        }
        this.bgSchedPolicy = new ButtonGroup();
        if (simpleoptionName.equalsIgnoreCase("Test time")) {
            rbName = "Test Time";
            if (!unit.equalsIgnoreCase("")) {
                rbName = rbName.concat("(").concat(unit).concat(")");
            }
            this.rbTestTime = new JRadioButton(rbName);
            this.rbTestTime.setName("rbTestTime");
            this.rbTestTime.setFont(this.resourceMap.getFont("lblOptionName.font"));
            if (simpleoptionName.equalsIgnoreCase(compositeVal)) {
                this.rbTestTime.setSelected(true);
            }
            this.txtTestTime = new JTextField();
            this.txtTestTime.setName("txtTestTime");
            this.txtTestTime.setText(value[0]);
            GroupLayout.SequentialGroup timeSeqGrp = this.jPanel1Layout.createSequentialGroup();
            timeSeqGrp.add(this.rbTestTime);
            timeSeqGrp.add(this.txtTestTime, 100, 100, 100);
            this.hpg2.add(timeSeqGrp);
            vpg.add(this.rbTestTime);
            vpg.add(this.txtTestTime);
        }
        if (simpleoptionName.equalsIgnoreCase("Test passes")) {
            rbName = "Test Passes";
            if (!unit.equalsIgnoreCase("")) {
                rbName = rbName.concat("(").concat(unit).concat(")");
            }
            this.rbTestPasses = new JRadioButton(rbName);
            this.rbTestPasses.setName("rbTestPasses");
            this.rbTestPasses.setFont(this.resourceMap.getFont("lblOptionName.font"));
            if (simpleoptionName.equalsIgnoreCase(compositeVal)) {
                this.rbTestPasses.setSelected(true);
            }
            this.txtTestPasses = new JTextField();
            this.txtTestPasses.setName("txtTestPasses");
            this.txtTestPasses.setText(value[0]);
            GroupLayout.SequentialGroup passSeqGrp = this.jPanel1Layout.createSequentialGroup();
            passSeqGrp.add(this.rbTestPasses);
            passSeqGrp.add(this.txtTestPasses, 100, 100, 100);
            this.hpg2.add(passSeqGrp);
            GroupLayout.ParallelGroup rvpg = this.jPanel1Layout.createParallelGroup(1);
            rvpg.add(this.rbTestPasses);
            rvpg.add(this.txtTestPasses);
            this.vseqG.add(rvpg);
        }
        this.bgSchedPolicy.add(this.rbTestTime);
        this.bgSchedPolicy.add(this.rbTestPasses);
    }

    private void initComponents() {
        this.lblTestName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setName("Form");
        ResourceMap resourceMap = ((SunvtsGUIApp)Application.getInstance(SunvtsGUIApp.class)).getContext().getResourceMap(LTOptionsPanel.class);
        this.lblTestName.setText(resourceMap.getString("lblTestName.text", new Object[0]));
        this.lblTestName.setName("lblTestName");
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setBackground(resourceMap.getColor("jTextArea1.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(resourceMap.getString("jTextArea1.text", new Object[0]));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 588, Short.MAX_VALUE).add(this.lblTestName)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.lblTestName).addPreferredGap(0).add(this.jScrollPane1, -2, -1, -2).addContainerGap(404, Short.MAX_VALUE)));
    }

    private void addToMainPanel() {
        this.jPanel1 = new JPanel();
        this.jPanel1.setName("jPanel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 588, Short.MAX_VALUE).add(this.lblTestName)).addContainerGap()).add(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.lblTestName).addPreferredGap(0).add(this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    public void changeMainPanelChild3(JPanel newpanel, JPanel oldpanel, String pName) {
        JPanel mainpanel = (JPanel)this.getParent();
        GroupLayout mainPanelLayout = (GroupLayout)mainpanel.getLayout();
        oldpanel.setVisible(false);
        newpanel.setVisible(true);
        int mainpanelComponentSize = mainpanel.getComponentCount();
        JPanel[] mainpanelComponents = new JPanel[mainpanelComponentSize];
        for (int i = 0; i < mainpanelComponentSize; ++i) {
            mainpanelComponents[i] = (JPanel)mainpanel.getComponent(i);
        }
        mainpanelComponents[1].removeAll();
        GroupLayout breadcrumbPanelLayout = (GroupLayout)mainpanelComponents[1].getLayout();
        if (pName.equalsIgnoreCase("Test Options")) {
            BreadcrumbLink b1 = new BreadcrumbLink("Test Group", newpanel);
            JLabel lblTO = new JLabel(">");
            JLabel lblB1 = new JLabel(pName);
            breadcrumbPanelLayout.setHorizontalGroup(breadcrumbPanelLayout.createParallelGroup(1).add(breadcrumbPanelLayout.createSequentialGroup().addContainerGap().add(b1.getLink()).addPreferredGap(0).add(lblTO).addPreferredGap(0).add(lblB1).addPreferredGap(0).addContainerGap(748, Short.MAX_VALUE)));
            breadcrumbPanelLayout.setVerticalGroup(breadcrumbPanelLayout.createParallelGroup(1).add(breadcrumbPanelLayout.createSequentialGroup().addContainerGap().add(breadcrumbPanelLayout.createParallelGroup(3).add(b1.getLink()).add(lblTO).add(lblB1)).addContainerGap(-1, Short.MAX_VALUE)));
        } else {
            BreadcrumbLink b1 = new BreadcrumbLink("Test Group", newpanel);
            BreadcrumbLink b2 = new BreadcrumbLink("Test Options", newpanel);
            JLabel lblB1 = new JLabel(pName);
            JLabel lblTO = new JLabel(">");
            JLabel lblTO1 = new JLabel(">");
            breadcrumbPanelLayout.setHorizontalGroup(breadcrumbPanelLayout.createParallelGroup(1).add(breadcrumbPanelLayout.createSequentialGroup().addContainerGap().add(b1.getLink()).addPreferredGap(0).add(lblTO).add(b2.getLink()).addPreferredGap(0).add(lblTO1).addPreferredGap(0).add(lblB1).addContainerGap(748, Short.MAX_VALUE)));
            breadcrumbPanelLayout.setVerticalGroup(breadcrumbPanelLayout.createParallelGroup(1).add(breadcrumbPanelLayout.createSequentialGroup().addContainerGap().add(breadcrumbPanelLayout.createParallelGroup(3).add(b1.getLink()).add(lblTO).add(b2.getLink()).add(lblTO1).add(lblB1)).addContainerGap(-1, Short.MAX_VALUE)));
        }
        mainpanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(1).add(mainpanelComponents[0], -1, -1, Short.MAX_VALUE).add(mainpanelComponents[1], -1, -1, Short.MAX_VALUE).add(newpanel, -1, -1, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().add(mainpanelComponents[0], -2, -1, -2).addPreferredGap(0).add(mainpanelComponents[1], -2, -1, -2).addPreferredGap(0).add(newpanel, -2, -1, -2).addContainerGap()));
    }

    public List getOptions() {
        return this.options;
    }

    public void setOptions(List options) {
        this.options = options;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    private void displayDeviceTable(String[] deviceNameArray, String[] selectedDeviceArray) {
        this.devicetablePanel = new JPanel();
        this.devicetableScrollPane = new JScrollPane();
        this.deviceTable = new JTable();
        this.devicetablePanel.setBackground(this.resourceMap.getColor("testtablePanel.background"));
        this.devicetablePanel.setBorder(BorderFactory.createLineBorder(this.resourceMap.getColor("testtablePanel.border.lineColor")));
        this.devicetablePanel.setName("testtablePanel");
        this.devicetableScrollPane.setName("testtableScrollPane2");
        Object[][] data = null;
        String[] columns = null;
        if (this.ltoptionbean.isDeviceOptExist()) {
            this.deviceList = this.ltoptionbean.getDevicesGroup(deviceNameArray, selectedDeviceArray);
            if (this.deviceList != null) {
                data = new Object[this.deviceList.size()][];
                columns = new String[]{"", "Device Name", "State"};
                int i = 0;
                String enableState = new String(" ");
                for (Device device : this.deviceList) {
                    enableState = device.isDeviceState() ? "Enabled" : "Disabled";
                    Object[] o = new Object[]{new Boolean(false), device.getDeviceName(), enableState};
                    data[i] = o;
                    ++i;
                }
            }
        }
        this.deviceTable.setModel(new DefaultTableModel(data, columns){
            Class[] types;
            {
                this.types = new Class[]{Boolean.class, Object.class, Object.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.deviceTable.setName("deviceTable");
        this.deviceTable.setSelectionMode(0);
        this.devicetableScrollPane.setViewportView(this.deviceTable);
        this.deviceTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.deviceTable.getColumnModel().getColumn(0).setCellEditor(this.deviceTable.getDefaultEditor(Boolean.class));
        this.deviceTable.getColumnModel().getColumn(0).setHeaderRenderer(new CheckBoxHeader(new MyItemListener(this.deviceTable)));
        this.deviceTable.getColumn("Device Name").setCellRenderer(new HLinkRenderer());
        this.deviceTable.getColumn("Device Name").setCellEditor(new LinkEditor(new JCheckBox()));
        this.deviceTable.getColumnModel().getColumn(1).setHeaderValue("Device Name");
        this.deviceTable.getColumnModel().getColumn(2).setHeaderValue("State");
        this.enableButton = new JButton();
        this.disableButton = new JButton();
        this.enableButton.setFont(this.resourceMap.getFont("enableButton.font"));
        this.enableButton.setText(this.resourceMap.getString("enableButton.text", new Object[0]));
        this.enableButton.setName("enableButton");
        this.enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LTOptionsPanel.this.enableButtonActionPerformed(evt);
            }
        });
        this.disableButton.setFont(this.resourceMap.getFont("disableButton.font"));
        this.disableButton.setText(this.resourceMap.getString("disableButton.text", new Object[0]));
        this.disableButton.setName("disableButton");
        this.disableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LTOptionsPanel.this.disableButtonActionPerformed(evt);
            }
        });
        GroupLayout devicetablePanelLayout = new GroupLayout(this.devicetablePanel);
        this.devicetablePanel.setLayout(devicetablePanelLayout);
        devicetablePanelLayout.setHorizontalGroup(devicetablePanelLayout.createParallelGroup(1).add(devicetablePanelLayout.createSequentialGroup().add(this.enableButton).add(18, 18, 18).add(this.disableButton).addContainerGap(901, Short.MAX_VALUE)).add(this.devicetableScrollPane, -1, 1069, Short.MAX_VALUE));
        devicetablePanelLayout.setVerticalGroup(devicetablePanelLayout.createParallelGroup(1).add(2, devicetablePanelLayout.createSequentialGroup().addContainerGap().add(devicetablePanelLayout.createParallelGroup(3).add(this.enableButton, -2, 20, Short.MAX_VALUE).add(this.disableButton, -2, 20, -2)).add(12, 12, 12).add(this.devicetableScrollPane, -2, 183, -2)));
    }

    private void enableButtonActionPerformed(ActionEvent evt) {
        int i;
        int tableRowCount = this.deviceTable.getRowCount();
        Object[] o = new Object[tableRowCount];
        for (i = 0; i < tableRowCount; ++i) {
            o[i] = this.deviceTable.getModel().getValueAt(i, 0);
        }
        this.deviceList = this.ltoptionbean.doEnableDevice(o);
        for (i = 0; i < this.deviceList.size(); ++i) {
            if (this.deviceList.get(i).isDeviceState()) {
                this.deviceTable.getModel().setValueAt("Enabled", i, 2);
            } else {
                this.deviceTable.getModel().setValueAt("Disabled", i, 2);
            }
            this.deviceTable.getModel().setValueAt(false, i, 0);
        }
        this.deviceTable.clearSelection();
    }

    private void disableButtonActionPerformed(ActionEvent evt) {
        int i;
        int tableRowCount = this.deviceTable.getRowCount();
        Object[] o = new Object[tableRowCount];
        for (i = 0; i < tableRowCount; ++i) {
            o[i] = this.deviceTable.getModel().getValueAt(i, 0);
        }
        this.deviceList = this.ltoptionbean.doDisableDevice(o);
        for (i = 0; i < this.deviceList.size(); ++i) {
            if (this.deviceList.get(i).isDeviceState()) {
                this.deviceTable.getModel().setValueAt("Enabled", i, 2);
            } else {
                this.deviceTable.getModel().setValueAt("Disabled", i, 2);
            }
            this.deviceTable.getModel().setValueAt(false, i, 0);
        }
        this.deviceTable.clearSelection();
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    class LinkEditor
    extends DefaultCellEditor {
        JXHyperlink hlink;
        private String label;
        private boolean isPushed;

        public LinkEditor(JCheckBox checkBox) {
            super(checkBox);
            this.label = "";
            this.isPushed = false;
            this.hlink = new JXHyperlink();
            this.hlink.setOpaque(true);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.label = value == null ? "" : value.toString();
            this.hlink.setAction(new LinkAction(this.label));
            this.isPushed = true;
            return this.hlink;
        }

        public Object getCellEditorValue() {
            if (this.isPushed) {
                // empty if block
            }
            this.isPushed = false;
            return new String(this.label);
        }
    }

    private static class LinkAction
    extends AbstractAction {
        public LinkAction(String s) {
            super.putValue("Name", s);
            super.putValue("ShortDescription", "To view Device Options page");
        }

        public void actionPerformed(ActionEvent e) {
            String selectedDeviceName = "";
            selectedDeviceName = e.getActionCommand();
            DeviceOptionBean deviceoptionbean = DeviceOptionBean.getDeviceOptionBean();
            deviceoptionbean.setTestName(LTOptionBean.getLTOptionBean().getTestName());
            deviceoptionbean.setDeviceName(selectedDeviceName);
            LTOptionsPanel.getLTOptionsPanel().setDeviceName(selectedDeviceName);
            LTOptionsPanel oldpanel = LTOptionsPanel.getLTOptionsPanel();
            DeviceOptionsPanel deviceoptionpanel = DeviceOptionsPanel.getDeviceOptionPanel();
            LTOptionsPanel.getLTOptionsPanel().changeMainPanelChild3(deviceoptionpanel, oldpanel, "Device Options");
            deviceoptionpanel.fillPropertySheet();
        }
    }
}

