/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sunvts.ui;

import java.awt.Component;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected CheckBoxHeader rendererComponent = this;
    protected int column;
    protected boolean mousePressed = false;

    public CheckBoxHeader(ItemListener itemListener) {
        this.rendererComponent.addItemListener(itemListener);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            header.addMouseListener(this.rendererComponent);
        }
        this.setColumn(column);
        return this.rendererComponent;
    }

    protected void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    protected void processClickEvent(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            TableColumnModel columnModel = tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = tableView.convertColumnIndexToModel(viewColumn);
            if (viewColumn == this.column && e.getClickCount() == 1 && column != -1) {
                this.doClick();
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processClickEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

